/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.property;

import org.apache.chemistry.opencmis.commons.enums.PropertyType;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.search.SortType;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.common.error.NumberToken;
import org.structr.core.GraphObject;
import org.structr.core.converter.PropertyConverter;
import org.structr.core.property.AbstractPrimitiveProperty;
import org.structr.core.property.DoubleProperty;
import org.structr.core.property.NumericalPropertyKey;

public class LongProperty
extends AbstractPrimitiveProperty<Long>
implements NumericalPropertyKey<Long> {
    private static final Logger logger = LoggerFactory.getLogger((String)DoubleProperty.class.getName());

    public LongProperty(String name) {
        super(name);
    }

    @Override
    public String typeName() {
        return "Long";
    }

    @Override
    public Class valueType() {
        return Long.class;
    }

    @Override
    public SortType getSortType() {
        return SortType.Long;
    }

    @Override
    public PropertyConverter<Long, Long> databaseConverter(SecurityContext securityContext) {
        return null;
    }

    @Override
    public PropertyConverter<Long, Long> databaseConverter(SecurityContext securityContext, GraphObject entity) {
        return null;
    }

    @Override
    public PropertyConverter<?, Long> inputConverter(SecurityContext securityContext) {
        return new InputConverter(securityContext);
    }

    @Override
    public Long convertToNumber(Double source) {
        if (source != null) {
            return source.longValue();
        }
        return null;
    }

    @Override
    public Object fixDatabaseProperty(Object value) {
        if (value != null) {
            if (value instanceof Long) {
                return value;
            }
            if (value instanceof Number) {
                return ((Number)value).longValue();
            }
            try {
                return Long.parseLong(value.toString());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public void index(GraphObject entity, Object value) {
        super.index(entity, this.fixDatabaseProperty(value));
    }

    @Override
    public PropertyType getDataType() {
        return PropertyType.INTEGER;
    }

    protected class InputConverter
    extends PropertyConverter<Object, Long> {
        public InputConverter(SecurityContext securityContext) {
            super(securityContext);
        }

        @Override
        public Object revert(Long source) throws FrameworkException {
            return source;
        }

        @Override
        public Long convert(Object source) throws FrameworkException {
            if (source == null) {
                return null;
            }
            if (source instanceof Number) {
                return ((Number)source).longValue();
            }
            if (source instanceof String && StringUtils.isNotBlank((CharSequence)((String)source))) {
                try {
                    return Long.valueOf(source.toString());
                }
                catch (Throwable t) {
                    throw new FrameworkException(422, "Cannot parse input for property " + LongProperty.this.jsonName(), new NumberToken(LongProperty.this.declaringClass.getSimpleName(), LongProperty.this));
                }
            }
            return null;
        }
    }
}

