/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.property;

import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.Predicate;
import org.structr.api.search.Occurrence;
import org.structr.api.search.SortType;
import org.structr.api.util.Iterables;
import org.structr.common.NotNullPredicate;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.app.Query;
import org.structr.core.app.StructrApp;
import org.structr.core.converter.PropertyConverter;
import org.structr.core.entity.ManyStartpoint;
import org.structr.core.entity.Relation;
import org.structr.core.entity.Target;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.search.EmptySearchAttribute;
import org.structr.core.graph.search.SearchAttribute;
import org.structr.core.graph.search.SourceSearchAttribute;
import org.structr.core.notion.Notion;
import org.structr.core.notion.ObjectNotion;
import org.structr.core.property.Property;
import org.structr.core.property.RelationProperty;

public class StartNodes<S extends NodeInterface, T extends NodeInterface>
extends Property<List<S>>
implements RelationProperty<S> {
    private static final Logger logger = LoggerFactory.getLogger((String)StartNodes.class.getName());
    private Relation<S, T, ManyStartpoint<S>, ? extends Target> relation = null;
    private Notion notion = null;
    private Class<S> destType = null;

    public StartNodes(String name, Class<? extends Relation<S, T, ManyStartpoint<S>, ? extends Target>> relationClass) {
        this(name, relationClass, (Notion)new ObjectNotion());
    }

    public StartNodes(String name, Class<? extends Relation<S, T, ManyStartpoint<S>, ? extends Target>> relationClass, Notion notion) {
        super(name);
        try {
            this.relation = relationClass.newInstance();
        }
        catch (Throwable t) {
            logger.warn("", t);
        }
        this.notion = notion;
        this.destType = this.relation.getSourceType();
        this.notion.setType(this.destType);
        this.notion.setRelationProperty(this);
        StructrApp.getConfiguration().registerConvertedProperty(this);
    }

    public StartNodes(String name, Relation<S, T, ManyStartpoint<S>, ? extends Target> relation, Notion notion) {
        super(name);
        this.relation = relation;
        this.notion = notion;
        this.destType = relation.getSourceType();
        this.notion.setType(this.destType);
        this.notion.setRelationProperty(this);
        StructrApp.getConfiguration().registerConvertedProperty(this);
    }

    @Override
    public String typeName() {
        return "collection";
    }

    @Override
    public Class valueType() {
        return this.relatedType();
    }

    @Override
    public SortType getSortType() {
        return SortType.Default;
    }

    @Override
    public PropertyConverter<List<S>, ?> databaseConverter(SecurityContext securityContext) {
        return null;
    }

    @Override
    public PropertyConverter<List<S>, ?> databaseConverter(SecurityContext securityContext, GraphObject entity) {
        return null;
    }

    @Override
    public PropertyConverter<?, List<S>> inputConverter(SecurityContext securityContext) {
        return this.getNotion().getCollectionConverter(securityContext);
    }

    @Override
    public List<S> getProperty(SecurityContext securityContext, GraphObject obj, boolean applyConverter) {
        return this.getProperty(securityContext, obj, applyConverter, (Predicate)null);
    }

    @Override
    public List<S> getProperty(SecurityContext securityContext, GraphObject obj, boolean applyConverter, Predicate<GraphObject> predicate) {
        ManyStartpoint<S> startpoint = this.relation.getSource();
        if (predicate != null) {
            return Iterables.toList((Iterable)Iterables.filter(predicate, (Iterable)Iterables.filter((Predicate)new NotNullPredicate(), (Iterable)startpoint.get(securityContext, (NodeInterface)obj, (Predicate)null))));
        }
        return Iterables.toList((Iterable)Iterables.filter((Predicate)new NotNullPredicate(), (Iterable)startpoint.get(securityContext, (NodeInterface)obj, (Predicate)null)));
    }

    @Override
    public Object setProperty(SecurityContext securityContext, GraphObject obj, List<S> collection) throws FrameworkException {
        ManyStartpoint<S> startpoint = this.relation.getSource();
        return startpoint.set(securityContext, (NodeInterface)obj, (Iterable<S>)collection);
    }

    @Override
    public Class relatedType() {
        return this.destType;
    }

    @Override
    public boolean isCollection() {
        return true;
    }

    @Override
    public Property<List<S>> indexed() {
        return this;
    }

    @Override
    public Property<List<S>> passivelyIndexed() {
        return this;
    }

    @Override
    public Object fixDatabaseProperty(Object value) {
        return null;
    }

    @Override
    public void index(GraphObject entity, Object value) {
    }

    @Override
    public Notion getNotion() {
        return this.notion;
    }

    @Override
    public void addSingleElement(SecurityContext securityContext, GraphObject obj, S s) throws FrameworkException {
        Object list = this.getProperty(securityContext, obj, false);
        list.add(s);
        this.setProperty(securityContext, obj, (List<S>)list);
    }

    @Override
    public Class<S> getTargetType() {
        return this.destType;
    }

    @Override
    public List<S> convertSearchValue(SecurityContext securityContext, String requestParameter) throws FrameworkException {
        PropertyConverter inputConverter = this.inputConverter(securityContext);
        if (inputConverter != null) {
            LinkedList<String> sources = new LinkedList<String>();
            if (requestParameter != null) {
                for (String part : requestParameter.split("[,;]+")) {
                    sources.add(part);
                }
            }
            return inputConverter.convert(sources);
        }
        return null;
    }

    @Override
    public SearchAttribute getSearchAttribute(SecurityContext securityContext, Occurrence occur, List<S> searchValue, boolean exactMatch, Query query) {
        Predicate<GraphObject> predicate = query != null ? query.toPredicate() : null;
        SourceSearchAttribute attr = new SourceSearchAttribute(occur);
        LinkedHashSet<GraphObject> intersectionResult = new LinkedHashSet<GraphObject>();
        boolean alreadyAdded = false;
        if (searchValue != null && !StringUtils.isBlank((CharSequence)searchValue.toString())) {
            if (exactMatch) {
                for (NodeInterface node : searchValue) {
                    switch (occur) {
                        case REQUIRED: {
                            if (!alreadyAdded) {
                                intersectionResult.addAll(this.getRelatedNodesReverse(securityContext, node, this.declaringClass, predicate));
                                alreadyAdded = true;
                                break;
                            }
                            intersectionResult.retainAll(this.getRelatedNodesReverse(securityContext, node, this.declaringClass, predicate));
                            break;
                        }
                        case OPTIONAL: {
                            intersectionResult.addAll(this.getRelatedNodesReverse(securityContext, node, this.declaringClass, predicate));
                            break;
                        }
                    }
                }
            } else {
                for (NodeInterface node : searchValue) {
                    intersectionResult.addAll(this.getRelatedNodesReverse(securityContext, node, this.declaringClass, predicate));
                }
            }
        } else {
            return new EmptySearchAttribute<Object>(this, null);
        }
        attr.setResult(intersectionResult);
        return attr;
    }

    @Override
    protected <T extends NodeInterface> Set<T> getRelatedNodesReverse(SecurityContext securityContext, NodeInterface obj, Class destinationType, Predicate<GraphObject> predicate) {
        LinkedHashSet<NodeInterface> relatedNodes = new LinkedHashSet<NodeInterface>();
        try {
            Object target = this.relation.getTarget().get(securityContext, obj, predicate);
            if (target != null) {
                if (target instanceof Iterable) {
                    Iterable nodes = (Iterable)target;
                    for (NodeInterface n : nodes) {
                        relatedNodes.add(n);
                    }
                } else {
                    relatedNodes.add((NodeInterface)target);
                }
            }
        }
        catch (Throwable t) {
            logger.warn("Unable to fetch related node: {}", (Object)t.getMessage());
        }
        return relatedNodes;
    }

    @Override
    public Relation getRelation() {
        return this.relation;
    }

    @Override
    public boolean doAutocreate() {
        if (this.relation != null) {
            switch (this.relation.getAutocreationFlag()) {
                case 2: 
                case 3: {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public String getAutocreateFlagName() {
        if (this.relation != null) {
            return Relation.CASCADING_DESCRIPTIONS[this.relation.getAutocreationFlag()];
        }
        return Relation.CASCADING_DESCRIPTIONS[0];
    }

    @Override
    public String getDirectionKey() {
        return "in";
    }
}

