/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.property;

import javax.mail.internet.ContentType;
import javax.mail.internet.ParseException;
import org.apache.chemistry.opencmis.commons.enums.PropertyType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.search.SortType;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.converter.PropertyConverter;
import org.structr.core.property.AbstractPrimitiveProperty;

public class StringProperty
extends AbstractPrimitiveProperty<String> {
    private static final Logger logger = LoggerFactory.getLogger((String)StringProperty.class.getName());
    private ContentType contentType;

    public StringProperty(String jsonName) {
        super(jsonName);
    }

    public StringProperty(String jsonName, String dbName) {
        super(jsonName);
        this.dbName = dbName;
    }

    @Override
    public String typeName() {
        return "String";
    }

    @Override
    public Class valueType() {
        return String.class;
    }

    @Override
    public Object fixDatabaseProperty(Object value) {
        if (value != null) {
            if (value instanceof String) {
                return value;
            }
            return value.toString();
        }
        return null;
    }

    @Override
    public SortType getSortType() {
        return SortType.Default;
    }

    @Override
    public PropertyConverter<String, ?> databaseConverter(SecurityContext securityContext) {
        return null;
    }

    @Override
    public PropertyConverter<String, ?> databaseConverter(SecurityContext securityContext, GraphObject entity) {
        return null;
    }

    @Override
    public PropertyConverter<?, String> inputConverter(SecurityContext securityContext) {
        return new PropertyConverter<Object, String>(securityContext){

            @Override
            public Object revert(String source) throws FrameworkException {
                return source;
            }

            @Override
            public String convert(Object source) throws FrameworkException {
                if (source != null) {
                    return source.toString();
                }
                return null;
            }
        };
    }

    public String contentType() {
        return this.contentType != null ? this.contentType.toString() : null;
    }

    public StringProperty contentType(String contentType) {
        this.contentType = StringProperty.parse(contentType);
        return this;
    }

    @Override
    public PropertyType getDataType() {
        return PropertyType.STRING;
    }

    private static ContentType parse(String contentTypeString) {
        try {
            return new ContentType(contentTypeString);
        }
        catch (ParseException pe) {
            logger.warn("Could not parse " + contentTypeString, (Throwable)pe);
            return null;
        }
    }
}

