/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.property;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.Predicate;
import org.structr.api.search.SortType;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.converter.PropertyConverter;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.RelationshipInterface;
import org.structr.core.property.Property;
import org.structr.core.property.TargetId;

public class TargetNodeProperty
extends Property<NodeInterface> {
    private static final Logger logger = LoggerFactory.getLogger((String)TargetId.class.getName());

    public TargetNodeProperty(String name) {
        super(name);
        this.passivelyIndexed();
    }

    @Override
    public Class relatedType() {
        return null;
    }

    @Override
    public NodeInterface getProperty(SecurityContext securityContext, GraphObject obj, boolean applyConverter) {
        return this.getProperty(securityContext, obj, applyConverter, (Predicate)null);
    }

    @Override
    public NodeInterface getProperty(SecurityContext securityContext, GraphObject obj, boolean applyConverter, Predicate<GraphObject> predicate) {
        if (obj instanceof RelationshipInterface) {
            return ((RelationshipInterface)obj).getTargetNode();
        }
        return null;
    }

    @Override
    public Object setProperty(SecurityContext securityContext, GraphObject obj, NodeInterface value) throws FrameworkException {
        if (obj instanceof RelationshipInterface && value != null) {
            try {
                ((RelationshipInterface)obj).setTargetNodeId(value.getUuid());
            }
            catch (Throwable t) {
                logger.warn("", t);
            }
        }
        return null;
    }

    @Override
    public boolean isCollection() {
        return false;
    }

    @Override
    public SortType getSortType() {
        return SortType.Default;
    }

    @Override
    public Object fixDatabaseProperty(Object value) {
        return null;
    }

    @Override
    public String typeName() {
        return null;
    }

    @Override
    public Class valueType() {
        return String.class;
    }

    @Override
    public PropertyConverter<NodeInterface, ?> databaseConverter(SecurityContext securityContext) {
        return null;
    }

    @Override
    public PropertyConverter<NodeInterface, ?> databaseConverter(SecurityContext securityContext, GraphObject entity) {
        return null;
    }

    @Override
    public PropertyConverter<?, NodeInterface> inputConverter(SecurityContext securityContext) {
        return null;
    }
}

