/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.property;

import java.util.LinkedHashSet;
import java.util.Set;
import org.structr.api.DatabaseService;
import org.structr.api.graph.Label;
import org.structr.api.graph.Node;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.app.StructrApp;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.search.SearchCommand;
import org.structr.core.property.StringProperty;

public class TypeProperty
extends StringProperty {
    public TypeProperty() {
        super("type");
        this.systemInternal();
        this.readOnly();
        this.indexed();
        this.writeOnce();
    }

    @Override
    public Object setProperty(SecurityContext securityContext, GraphObject obj, String value) throws FrameworkException {
        super.setProperty(securityContext, obj, value);
        if (obj instanceof NodeInterface) {
            Class type = StructrApp.getConfiguration().getNodeEntityClass(value);
            TypeProperty.updateLabels(StructrApp.getInstance().getDatabaseService(), (NodeInterface)obj, type);
        }
        return null;
    }

    public static Set<String> getLabelsForType(Class type) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (Class supertype : SearchCommand.typeAndAllSupertypes(type)) {
            String supertypeName = supertype.getName();
            if (!supertypeName.startsWith("org.structr.") && !supertypeName.startsWith("com.structr.")) continue;
            result.add(supertype.getSimpleName());
        }
        return result;
    }

    public static void updateLabels(DatabaseService graphDb, NodeInterface node, Class newType) {
        LinkedHashSet intersection = new LinkedHashSet();
        LinkedHashSet<Label> toRemove = new LinkedHashSet<Label>();
        LinkedHashSet<Object> toAdd = new LinkedHashSet<Object>();
        Node dbNode = node.getNode();
        for (Label label : dbNode.getLabels()) {
            toRemove.add(label);
        }
        for (Class clazz : SearchCommand.typeAndAllSupertypes(newType)) {
            String supertypeName = clazz.getName();
            if (!supertypeName.startsWith("org.structr.") && !supertypeName.startsWith("com.structr.")) continue;
            toAdd.add(graphDb.forName(Label.class, clazz.getSimpleName()));
        }
        intersection.addAll(toAdd);
        intersection.retainAll(toRemove);
        toAdd.removeAll(intersection);
        toRemove.removeAll(intersection);
        for (Label label : toRemove) {
            dbNode.removeLabel(label);
        }
        for (Label label : toAdd) {
            dbNode.addLabel(label);
        }
    }
}

