/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.rest;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.stream.JsonWriter;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.core.GraphObject;
import org.structr.core.Value;
import org.structr.core.converter.PropertyConverter;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.PropertyMap;

public class GraphObjectGSONAdapter {
    private static final Logger logger = LoggerFactory.getLogger((String)GraphObjectGSONAdapter.class.getName());
    private static final long MAX_SERIALIZATION_TIME = TimeUnit.SECONDS.toMillis(30L);
    private final Map<String, Serializer> serializerCache = new LinkedHashMap<String, Serializer>(100);
    private final Map<String, Serializer> serializers = new LinkedHashMap<String, Serializer>();
    private final Set<String> nonSerializerClasses = new LinkedHashSet<String>();
    private final Serializer<GraphObject> root = new RootSerializer();
    private int outputNestingDepth = 3;
    private SecurityContext securityContext = SecurityContext.getSuperUserInstance();
    private Value<String> propertyView = null;
    private JsonWriter writer = null;

    public GraphObjectGSONAdapter(Value<String> propertyView, int outputNestingDepth) {
        this.propertyView = propertyView;
        this.outputNestingDepth = outputNestingDepth;
        this.serializers.put(GraphObject.class.getName(), this.root);
        this.serializers.put(PropertyMap.class.getName(), new PropertyMapSerializer());
        this.serializers.put(Iterable.class.getName(), new IterableSerializer());
        this.serializers.put(Map.class.getName(), new MapSerializer());
        this.nonSerializerClasses.add(Object.class.getName());
        this.nonSerializerClasses.add(String.class.getName());
        this.nonSerializerClasses.add(Integer.class.getName());
        this.nonSerializerClasses.add(Long.class.getName());
        this.nonSerializerClasses.add(Double.class.getName());
        this.nonSerializerClasses.add(Float.class.getName());
        this.nonSerializerClasses.add(Byte.class.getName());
        this.nonSerializerClasses.add(Character.class.getName());
        this.nonSerializerClasses.add(StringBuffer.class.getName());
        this.nonSerializerClasses.add(Boolean.class.getName());
    }

    public JsonElement serialize(GraphObject src, long startTime) {
        String localPropertyView = this.propertyView.get(null);
        if (System.currentTimeMillis() > startTime + MAX_SERIALIZATION_TIME) {
            logger.error("JSON serialization took more than {} ms, aborted. Please review output view size or adjust timeout.", (Object)MAX_SERIALIZATION_TIME);
            return null;
        }
        return this.root.serialize(src, localPropertyView, 0);
    }

    public JsonElement serializeObject(Object src, long startTime) {
        String localPropertyView = this.propertyView.get(null);
        if (System.currentTimeMillis() > startTime + MAX_SERIALIZATION_TIME) {
            logger.error("JSON serialization took more than {} ms, aborted. Please review output view size or adjust timeout.", (Object)MAX_SERIALIZATION_TIME);
            return null;
        }
        return this.root.serializeRoot(src, localPropertyView, 0);
    }

    private static JsonElement toPrimitive(Object value) {
        JsonPrimitive p = null;
        if (value != null) {
            p = value instanceof Number ? new JsonPrimitive((Number)value) : (value instanceof Character ? new JsonPrimitive((Character)value) : (value instanceof String ? new JsonPrimitive((String)value) : (value instanceof Boolean ? new JsonPrimitive((Boolean)value) : new JsonPrimitive(value.toString()))));
        }
        return p;
    }

    private Serializer getSerializerForType(Class type) {
        Class localType = type;
        Serializer serializer = this.serializerCache.get(type.getName());
        if (serializer == null && !this.nonSerializerClasses.contains(type.getName())) {
            do {
                if ((serializer = this.serializers.get(localType.getName())) == null) {
                    Class interfaceType;
                    LinkedHashSet<Class> interfaces = new LinkedHashSet<Class>();
                    this.collectAllInterfaces(localType, interfaces);
                    Iterator iterator = interfaces.iterator();
                    while (iterator.hasNext() && (serializer = this.serializers.get((interfaceType = (Class)iterator.next()).getName())) == null) {
                    }
                }
                localType = localType.getSuperclass();
            } while (serializer == null && !localType.equals(Object.class));
            if (serializer != null) {
                this.serializerCache.put(type.getName(), serializer);
            }
        }
        return serializer;
    }

    private void collectAllInterfaces(Class type, Set<Class> interfaces) {
        if (interfaces.contains(type)) {
            return;
        }
        for (Class<?> iface : type.getInterfaces()) {
            this.collectAllInterfaces(iface, interfaces);
            interfaces.add(iface);
        }
    }

    public class PropertyMapSerializer
    extends Serializer<PropertyMap> {
        @Override
        public JsonElement serialize(PropertyMap source, String localPropertyView, int depth) {
            JsonObject object = new JsonObject();
            if (depth > GraphObjectGSONAdapter.this.outputNestingDepth) {
                Object value = ((Map)((Object)source)).get("id");
                object.add("id", GraphObjectGSONAdapter.toPrimitive(value));
            } else {
                for (Map.Entry<PropertyKey, Object> entry : source.entrySet()) {
                    PropertyKey key = entry.getKey();
                    Object value = entry.getValue();
                    object.add(key.jsonName(), this.serializeProperty(key, value, localPropertyView, depth));
                }
            }
            return object;
        }
    }

    public class MapSerializer
    extends Serializer {
        public JsonElement serialize(Object source, String localPropertyView, int depth) {
            JsonObject object = new JsonObject();
            if (depth > GraphObjectGSONAdapter.this.outputNestingDepth) {
                Object value = ((Map)source).get("id");
                object.add("id", GraphObjectGSONAdapter.toPrimitive(value));
            } else {
                for (Map.Entry entry : ((Map)source).entrySet()) {
                    String key = (String)entry.getKey();
                    Object value = entry.getValue();
                    object.add(key, this.serializeRoot(value, localPropertyView, depth));
                }
            }
            return object;
        }
    }

    public class IterableSerializer
    extends Serializer<Iterable> {
        @Override
        public JsonElement serialize(Iterable value, String localPropertyView, int depth) {
            if (depth > GraphObjectGSONAdapter.this.outputNestingDepth) {
                return null;
            }
            JsonArray array = new JsonArray();
            for (Object o : value) {
                array.add(this.serializeRoot(o, localPropertyView, depth));
            }
            return array;
        }
    }

    public class RootSerializer
    extends Serializer<GraphObject> {
        @Override
        public JsonElement serialize(GraphObject source, String localPropertyView, int depth) {
            Iterable<PropertyKey> keys;
            JsonObject jsonObject = new JsonObject();
            String uuid = source.getUuid();
            if (uuid != null) {
                jsonObject.add("id", (JsonElement)new JsonPrimitive(uuid));
            } else {
                logger.debug("Found object without UUID: {}", (Object)source);
            }
            if (depth <= GraphObjectGSONAdapter.this.outputNestingDepth && (keys = source.getPropertyKeys(localPropertyView)) != null) {
                for (PropertyKey key : keys) {
                    Object value = source.getProperty(key);
                    PropertyKey localKey = key;
                    if (value != null) {
                        jsonObject.add(localKey.jsonName(), this.serializeProperty(key, value, localPropertyView, depth + 1));
                        continue;
                    }
                    jsonObject.add(localKey.jsonName(), null);
                }
            }
            return jsonObject;
        }
    }

    public abstract class Serializer<T> {
        public abstract JsonElement serialize(T var1, String var2, int var3);

        public JsonElement serializeRoot(Object value, String localPropertyView, int depth) {
            Serializer serializer;
            if (value != null && (serializer = GraphObjectGSONAdapter.this.getSerializerForType(value.getClass())) != null) {
                return serializer.serialize(value, localPropertyView, depth + 1);
            }
            return GraphObjectGSONAdapter.toPrimitive(value);
        }

        public JsonElement serializeProperty(PropertyKey key, Object value, String localPropertyView, int depth) {
            try {
                PropertyConverter<?, Object> converter = key.inputConverter(GraphObjectGSONAdapter.this.securityContext);
                if (converter != null) {
                    try {
                        return this.serializeRoot(converter.revert(value), localPropertyView, depth);
                    }
                    catch (ClassCastException cce) {
                        value = key.fixDatabaseProperty(value);
                        return this.serializeRoot(converter.revert(value), localPropertyView, depth);
                    }
                }
                return this.serializeRoot(value, localPropertyView, depth);
            }
            catch (Throwable t) {
                logger.warn("Exception while serializing property {} ({}) of entity {} (value {}) : {}", new Object[]{key.jsonName(), key.getClass(), key.getClass().getDeclaringClass(), value.getClass().getName(), value, t.getMessage()});
                return null;
            }
        }
    }
}

