/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.script;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunctionCall;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.StructrApp;
import org.structr.core.graph.Tx;
import org.structr.core.script.Scripting;
import org.structr.core.script.StructrScriptable;
import org.structr.schema.action.ActionContext;

public class BatchFunctionCall
implements IdFunctionCall {
    private static final Logger logger = LoggerFactory.getLogger(BatchFunctionCall.class);
    private StructrScriptable scriptable = null;
    private ActionContext actionContext = null;

    public BatchFunctionCall(ActionContext actionContext, StructrScriptable scriptable) {
        this.actionContext = actionContext;
        this.scriptable = scriptable;
    }

    public Object execIdCall(IdFunctionObject f, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (args.length < 1) {
            logger.warn("Invalid number of arguments for Structr.batch(): expected at least 1, got " + args.length + ". Usage: Structr.batch(function, [runInBackground]);");
            return null;
        }
        Script mainCall = this.toScript("function", args, 0);
        boolean background = this.toBoolean(args, 1);
        Thread workerThread = new Thread(() -> {
            Scripting.setupJavascriptContext();
            try {
                scope.put("Structr", scope, (Object)this.scriptable);
                boolean runAgain = true;
                while (runAgain) {
                    try {
                        Tx tx = StructrApp.getInstance(this.actionContext.getSecurityContext()).tx();
                        Throwable throwable = null;
                        try {
                            Object result = mainCall.exec(cx, scope);
                            if (!Boolean.TRUE.equals(result)) {
                                runAgain = false;
                            }
                            tx.success();
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (tx == null) continue;
                            if (throwable != null) {
                                try {
                                    tx.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            tx.close();
                        }
                    }
                    catch (FrameworkException fex) {
                        fex.printStackTrace();
                    }
                }
            }
            finally {
                Scripting.destroyJavascriptContext();
            }
        });
        workerThread.start();
        if (!background) {
            try {
                workerThread.join();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return null;
    }

    private Script toScript(String name, Object[] args, int index) {
        if (index >= args.length) {
            return null;
        }
        Object value = args[index];
        if (value instanceof Script) {
            return (Script)value;
        }
        if (value == null) {
            logger.warn("Invalid argument {} for Structr.batch(): expected script, got null.");
        } else {
            logger.warn("Invalid argument {} for Structr.batch(): expected script, got {}", (Object)name, value.getClass());
        }
        return null;
    }

    private boolean toBoolean(Object[] args, int index) {
        if (index >= args.length) {
            return false;
        }
        Object value = args[index];
        if (value != null && value instanceof Boolean) {
            return (Boolean)value;
        }
        return false;
    }
}

