/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.script;

import java.lang.reflect.Constructor;
import java.util.LinkedList;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.ToolProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.core.GraphObject;
import org.structr.core.function.Functions;
import org.structr.schema.action.ActionContext;
import org.structr.schema.compiler.CharSequenceJavaFileObject;
import org.structr.schema.compiler.ClassFileManager;

public class FunctionsCompiler {
    private static final Logger logger = LoggerFactory.getLogger((String)FunctionsCompiler.class.getName());
    public static final String PROXY_CLASS_NAME = "org.structr.core.script.FunctionsProxy";
    private static final JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
    private static final JavaFileManager fileManager = new ClassFileManager(compiler.getStandardFileManager(null, null, null));
    private static Constructor constructor = null;
    private static boolean initialized = false;

    public static Object getProxy(SecurityContext securityContext, ActionContext actionContext, GraphObject entity) {
        try {
            FunctionsCompiler.initializeProxy();
            if (constructor != null) {
                return constructor.newInstance(securityContext, actionContext, entity);
            }
        }
        catch (Throwable t) {
            logger.warn("", t);
        }
        return null;
    }

    public static void initializeProxy() throws ClassNotFoundException, NoSuchMethodException {
        if (!initialized) {
            String className = PROXY_CLASS_NAME;
            LinkedList<CharSequenceJavaFileObject> jfiles = new LinkedList<CharSequenceJavaFileObject>();
            jfiles.add(new CharSequenceJavaFileObject(PROXY_CLASS_NAME, FunctionsCompiler.getContent()));
            compiler.getTask(null, fileManager, null, null, null, jfiles).call();
            ClassLoader loader = fileManager.getClassLoader(null);
            Class<?> proxyClass = loader.loadClass(PROXY_CLASS_NAME);
            constructor = proxyClass.getConstructor(SecurityContext.class, ActionContext.class, GraphObject.class);
            initialized = true;
        }
    }

    private static String getContent() {
        StringBuilder buf = new StringBuilder();
        buf.append("package org.structr.core.script;\n\n");
        buf.append("import org.structr.common.error.FrameworkException;\n");
        buf.append("import org.structr.core.parser.Functions;\n");
        buf.append("import org.structr.schema.action.ActionContext;\n");
        buf.append("import org.structr.common.SecurityContext;\n");
        buf.append("import org.structr.schema.action.Function;\n");
        buf.append("import org.structr.core.GraphObject;\n\n");
        buf.append("public class FunctionsProxy {\n\n");
        buf.append("\tprivate SecurityContext securityContext = null;\n");
        buf.append("\tprivate ActionContext actionContext     = null;\n");
        buf.append("\tprivate GraphObject entity              = null;\n\n");
        buf.append("\tpublic FunctionsProxy(final SecurityContext securityContext, final ActionContext actionContext, final GraphObject entity) {\n");
        buf.append("\t\tthis.securityContext = securityContext;\n");
        buf.append("\t\tthis.actionContext   = actionContext;\n");
        buf.append("\t\tthis.entity          = entity;\n");
        buf.append("\t}\n\n");
        for (String name : Functions.getNames()) {
            if ("if".equals(name)) continue;
            buf.append("\tpublic Object ").append(name).append("(final Object... params) throws FrameworkException {\n");
            buf.append("\t\treturn Functions.functions.get(\"").append(name).append("\").apply(actionContext, entity, params);\n");
            buf.append("\t}\n\n");
        }
        buf.append("}\n");
        return buf.toString();
    }
}

