/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.script;

import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptContext;

public class StructrScriptContext
implements ScriptContext {
    private Map<Integer, Bindings> bindingMap = new HashMap<Integer, Bindings>();
    private Writer errorWriter = null;
    private Reader reader = null;
    private Writer writer = null;

    @Override
    public void setBindings(Bindings bindings, int scope) {
        this.bindingMap.put(scope, bindings);
    }

    @Override
    public Bindings getBindings(int scope) {
        return this.bindingMap.get(scope);
    }

    @Override
    public void setAttribute(String name, Object value, int scope) {
        Bindings bindings = this.getBindings(scope);
        if (bindings != null) {
            bindings.put(name, value);
        }
    }

    @Override
    public Object getAttribute(String name, int scope) {
        Bindings bindings = this.getBindings(scope);
        if (bindings != null) {
            return bindings.get(name);
        }
        return null;
    }

    @Override
    public Object removeAttribute(String name, int scope) {
        Bindings bindings = this.getBindings(scope);
        if (bindings != null) {
            return bindings.remove(name);
        }
        return null;
    }

    @Override
    public Object getAttribute(String name) {
        Bindings bindings = this.getBindings(200);
        if (bindings != null) {
            return bindings.get(name);
        }
        return null;
    }

    @Override
    public int getAttributesScope(String name) {
        for (Map.Entry<Integer, Bindings> entry : this.bindingMap.entrySet()) {
            if (!entry.getValue().containsKey(name)) continue;
            return entry.getKey();
        }
        return -1;
    }

    @Override
    public Writer getWriter() {
        return this.writer;
    }

    @Override
    public Writer getErrorWriter() {
        return this.errorWriter;
    }

    @Override
    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    @Override
    public void setErrorWriter(Writer writer) {
        this.errorWriter = writer;
    }

    @Override
    public Reader getReader() {
        return this.reader;
    }

    @Override
    public void setReader(Reader reader) {
        this.reader = reader;
    }

    @Override
    public List<Integer> getScopes() {
        return new LinkedList<Integer>(this.bindingMap.keySet());
    }
}

