/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.script;

import java.io.IOException;
import java.io.Reader;
import java.util.LinkedList;
import java.util.List;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.error.FrameworkException;
import org.structr.common.error.UnlicensedException;
import org.structr.core.GraphObject;
import org.structr.core.function.Functions;
import org.structr.core.script.StructrScriptEngineFactory;
import org.structr.schema.action.ActionContext;

public class StructrScriptEngine
extends AbstractScriptEngine {
    private static final Logger logger = LoggerFactory.getLogger((String)StructrScriptEngine.class.getName());
    private StructrScriptEngineFactory factory = null;

    public StructrScriptEngine(StructrScriptEngineFactory factory) {
        this.factory = factory;
    }

    @Override
    public Object eval(String script, ScriptContext context) throws ScriptException {
        try {
            ActionContext actionContext = (ActionContext)this.get("_actionContext");
            GraphObject entity = (GraphObject)this.get("_entity");
            return Functions.evaluate(actionContext, entity, script);
        }
        catch (FrameworkException | UnlicensedException fex) {
            throw new ScriptException(fex);
        }
    }

    @Override
    public Object eval(Reader reader, ScriptContext context) throws ScriptException {
        try {
            return this.eval(IOUtils.toString((Reader)reader), context);
        }
        catch (IOException ioex) {
            logger.error("Unable to read from Reader.", (Throwable)ioex);
            return null;
        }
    }

    @Override
    public Bindings createBindings() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ScriptEngineFactory getFactory() {
        return this.factory;
    }

    public static List<String> extractTemplateExpressions(String source) {
        LinkedList<String> expressions = new LinkedList<String>();
        int length = source.length();
        boolean inSingleQuotes = false;
        boolean inDoubleQuotes = false;
        boolean inTemplate = false;
        boolean hasDollar = false;
        int start = 0;
        int end = 0;
        block7: for (int i = 0; i < length; ++i) {
            char c = source.charAt(i);
            switch (c) {
                case '\'': {
                    if (inTemplate) {
                        inSingleQuotes = !inSingleQuotes;
                    }
                    hasDollar = false;
                    continue block7;
                }
                case '\"': {
                    if (inTemplate) {
                        inDoubleQuotes = !inDoubleQuotes;
                    }
                    hasDollar = false;
                    continue block7;
                }
                case '$': {
                    hasDollar = true;
                    continue block7;
                }
                case '{': {
                    if (!inTemplate && hasDollar) {
                        inTemplate = true;
                        start = i - 1;
                    }
                    hasDollar = false;
                    continue block7;
                }
                case '}': {
                    if (!inSingleQuotes && !inDoubleQuotes && inTemplate) {
                        inTemplate = false;
                        end = i + 1;
                        expressions.add(source.substring(start, end));
                    }
                    hasDollar = true;
                    continue block7;
                }
                default: {
                    hasDollar = false;
                }
            }
        }
        return expressions;
    }
}

