/*
 * Decompiled with CFR 0.152.
 */
package org.structr.core.script;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import jdk.nashorn.api.scripting.ScriptUtils;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunctionCall;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeJavaMethod;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.TopLevel;
import org.mozilla.javascript.Wrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.CaseHelper;
import org.structr.common.error.FrameworkException;
import org.structr.core.Export;
import org.structr.core.GraphObject;
import org.structr.core.app.StructrApp;
import org.structr.core.converter.PropertyConverter;
import org.structr.core.function.Functions;
import org.structr.core.function.GrantFunction;
import org.structr.core.property.EnumProperty;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.PropertyMap;
import org.structr.core.script.BatchFunctionCall;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class StructrScriptable
extends ScriptableObject {
    private static final Logger logger = LoggerFactory.getLogger((String)StructrScriptable.class.getName());
    private static final Object[] IDs = new Object[]{"id", "type"};
    private ActionContext actionContext = null;
    private FrameworkException exception = null;
    private GraphObject entity = null;
    private Context scriptingContext = null;

    public StructrScriptable(ActionContext actionContext, GraphObject entity, Context scriptingContext) {
        this.actionContext = actionContext;
        this.entity = entity;
        this.scriptingContext = scriptingContext;
    }

    public String getClassName() {
        return "Structr";
    }

    public Object get(final String name, Scriptable start) {
        if ("get".equals(name)) {
            return new IdFunctionObject(new IdFunctionCall(){

                public Object execIdCall(IdFunctionObject info, Context context, Scriptable scope, Scriptable thisObject, Object[] parameters) {
                    if (parameters.length == 1 && parameters[0] != null) {
                        try {
                            return StructrScriptable.this.wrap(context, thisObject, null, StructrScriptable.this.actionContext.evaluate(StructrScriptable.this.entity, parameters[0].toString(), null, null, 0));
                        }
                        catch (FrameworkException ex) {
                            StructrScriptable.this.exception = ex;
                        }
                    } else if (parameters.length > 1) {
                        Function<Object, Object> function = Functions.get("get");
                        try {
                            Object[] unwrappedParameters = new Object[parameters.length];
                            int i = 0;
                            for (Object param : parameters) {
                                unwrappedParameters[i++] = StructrScriptable.this.unwrap(param);
                            }
                            return StructrScriptable.this.wrap(context, scope, null, function.apply(StructrScriptable.this.actionContext, StructrScriptable.this.entity, (Object[])unwrappedParameters));
                        }
                        catch (FrameworkException fex) {
                            StructrScriptable.this.exception = fex;
                            return null;
                        }
                    }
                    return null;
                }
            }, null, 0, 0);
        }
        if ("clear".equals(name)) {
            return new IdFunctionObject(new IdFunctionCall(){

                public Object execIdCall(IdFunctionObject info, Context context, Scriptable scope, Scriptable thisObject, Object[] parameters) {
                    StructrScriptable.this.actionContext.clear();
                    return null;
                }
            }, null, 0, 0);
        }
        if ("this".equals(name)) {
            return this.wrap(this.scriptingContext, start, null, this.entity);
        }
        if ("me".equals(name)) {
            return this.wrap(this.scriptingContext, start, null, this.actionContext.getSecurityContext().getUser(false));
        }
        if ("vars".equals(name)) {
            NativeObject nobj = new NativeObject();
            for (Map.Entry<String, Object> entry : this.actionContext.getAllVariables().entrySet()) {
                nobj.defineProperty(entry.getKey(), entry.getValue(), 1);
            }
            return nobj;
        }
        if ("include".equals(name) || "render".equals(name)) {
            return new IdFunctionObject(new IdFunctionCall(){

                public Object execIdCall(IdFunctionObject info, Context context, Scriptable scope, Scriptable thisObject, Object[] parameters) {
                    if (parameters.length > 0 && parameters[0] != null) {
                        try {
                            Function<Object, Object> func = Functions.get(name);
                            if (func != null) {
                                StructrScriptable.this.actionContext.print(func.apply(StructrScriptable.this.actionContext, StructrScriptable.this.entity, (Object[])parameters));
                            }
                            return null;
                        }
                        catch (FrameworkException ex) {
                            StructrScriptable.this.exception = ex;
                        }
                    }
                    return null;
                }
            }, null, 0, 0);
        }
        if ("includeJs".equals(name)) {
            return new IdFunctionObject(new IdFunctionCall(){

                public Object execIdCall(IdFunctionObject info, Context context, Scriptable scope, Scriptable thisObject, Object[] parameters) {
                    if (parameters.length == 1) {
                        String fileName = parameters[0].toString();
                        context.evaluateString(scope, StructrScriptable.this.actionContext.getJavascriptLibraryCode(fileName), fileName, 1, null);
                    } else {
                        logger.warn("Incorrect usage of includeJs function. Takes exactly one parameter: The filename of the javascript file!");
                    }
                    return null;
                }
            }, null, 0, 0);
        }
        if ("batch".equals(name)) {
            return new IdFunctionObject((IdFunctionCall)new BatchFunctionCall(this.actionContext, this), null, 0, 0);
        }
        Function<Object, Object> function = Functions.get(CaseHelper.toUnderscore(name, false));
        if (function != null) {
            return new IdFunctionObject((IdFunctionCall)new FunctionWrapper(function), null, 0, 0);
        }
        return null;
    }

    public boolean hasException() {
        return this.exception != null;
    }

    public FrameworkException getException() {
        return this.exception;
    }

    private Object wrap(Context context, Scriptable scope, String key, Object value) {
        if (value instanceof Collection) {
            return new StructrArray(scope, key, this.wrapCollection(context, scope, key, (Collection)value));
        }
        if (value instanceof Object[]) {
            return new StructrArray(scope, key, (Object[])value);
        }
        if (value instanceof GraphObject) {
            return new GraphObjectWrapper(context, scope, (GraphObject)value);
        }
        if (value instanceof HttpServletRequest) {
            return new HttpServletRequestWrapper((HttpServletRequest)value);
        }
        if (value != null && value.getClass().isEnum()) {
            return ((Enum)value).name();
        }
        if (value instanceof Map && !(value instanceof PropertyMap)) {
            return new MapWrapper((Map)value);
        }
        if (value instanceof Date) {
            return context.newObject(scope, "Date", new Object[]{((Date)value).getTime()});
        }
        return value;
    }

    private Object[] wrapCollection(Context context, Scriptable scope, String key, Collection collection) {
        int size = collection.size();
        Object[] array = new Object[size];
        int i = 0;
        for (Object obj : collection) {
            array[i++] = this.wrap(context, scope, key, obj);
        }
        return array;
    }

    public Object unwrap(Object source) {
        if (source != null) {
            if (source instanceof Wrapper) {
                return this.unwrap(((Wrapper)source).unwrap());
            }
            if (source.getClass().isArray()) {
                ArrayList<Object> list = new ArrayList<Object>();
                for (Object obj : (Object[])source) {
                    list.add(this.unwrap(obj));
                }
                return list;
            }
            if (source instanceof StructrArray) {
                ArrayList<Object> list = new ArrayList<Object>();
                for (Object obj : ((StructrArray)((Object)source)).toArray()) {
                    list.add(this.unwrap(obj));
                }
                return list;
            }
            if (source.getClass().getName().equals("org.mozilla.javascript.NativeDate")) {
                Double value = ScriptRuntime.toNumber((Object)source);
                return new Date(value.longValue());
            }
            return ScriptUtils.unwrap((Object)source);
        }
        return source;
    }

    public static interface JsDateWrap {
        public long getTime();

        public int getTimezoneOffset();
    }

    public class MapWrapper
    extends ScriptableObject
    implements Map {
        private Map<String, Object> map = null;

        public MapWrapper(Map<String, Object> map) {
            this.map = map;
        }

        public String toString() {
            return this.map.toString();
        }

        public String getClassName() {
            return "Map";
        }

        public Object get(String name, Scriptable start) {
            return this.map.get(name);
        }

        public Object[] getIds() {
            return this.map.keySet().toArray();
        }

        public Object getDefaultValue(Class<?> hint) {
            return this.map.toString();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.map.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.map.containsValue(value);
        }

        public Object put(Object key, Object value) {
            return this.map.put(null, value);
        }

        public Object remove(Object key) {
            return this.map.remove(key);
        }

        public void putAll(Map m) {
            this.map.putAll(m);
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        public Set keySet() {
            return this.map.keySet();
        }

        public Collection values() {
            return this.map.values();
        }

        public Set entrySet() {
            return this.map.entrySet();
        }
    }

    public class HttpServletRequestWrapper
    extends ScriptableObject {
        private HttpServletRequest request = null;

        public HttpServletRequestWrapper(HttpServletRequest request) {
            this.request = request;
        }

        public String getClassName() {
            return "HttpServletRequest";
        }

        public Object get(String name, Scriptable start) {
            return this.request.getParameter(name);
        }

        public Object[] getIds() {
            return this.request.getParameterMap().values().toArray();
        }

        public Object getDefaultValue(Class<?> hint) {
            logger.warn("getDefaultValue() of HttpServletRequestWrapper called, don't know what to return here.. Please report to team@structr.com what you were trying to do with this object when you encountered this error message.");
            return null;
        }
    }

    public class GraphObjectWrapper
    implements Scriptable,
    Wrapper {
        private Context context = null;
        private Scriptable prototype = null;
        private Scriptable scope = null;
        private GraphObject obj = null;

        public GraphObjectWrapper(Context context, Scriptable scope, GraphObject obj) {
            this.context = context;
            this.scope = scope;
            this.obj = obj;
        }

        public String toString() {
            return this.getClassName();
        }

        public String getClassName() {
            return this.obj.getType();
        }

        public Object get(String name, Scriptable s) {
            PropertyKey key = this.getKey(name);
            if (key != null) {
                return StructrScriptable.this.wrap(this.context, this, name, this.obj.getProperty(key));
            }
            Object value = StructrScriptable.this.wrap(this.context, this, null, this.checkEntityMethods(name));
            if (value != null) {
                return value;
            }
            Method method = StructrApp.getConfiguration().getAnnotatedMethods(this.obj.getClass(), Export.class).get(name);
            if (method != null) {
                return new NativeJavaMethod(method, name);
            }
            try {
                return StructrScriptable.this.wrap(this.context, this, null, this.obj.evaluate(StructrScriptable.this.actionContext, name, null));
            }
            catch (FrameworkException fex) {
                StructrScriptable.this.exception = fex;
                return null;
            }
        }

        public Object get(int i, Scriptable s) {
            return null;
        }

        public boolean has(String string, Scriptable s) {
            return this.get(string, s) != null;
        }

        public boolean has(int i, Scriptable s) {
            return false;
        }

        public void put(String string, Scriptable s, Object o) {
            PropertyKey key = this.getKey(string);
            if (key != null) {
                try {
                    Object value = StructrScriptable.this.unwrap(o);
                    if (key instanceof EnumProperty) {
                        PropertyConverter inputConverter = key.inputConverter(StructrScriptable.this.actionContext.getSecurityContext());
                        if (inputConverter != null) {
                            value = inputConverter.convert(value);
                        }
                    } else {
                        Class valueType = key.valueType();
                        Class relatedType = key.relatedType();
                        if (valueType != null && relatedType == null) {
                            value = Context.jsToJava((Object)value, (Class)valueType);
                        }
                    }
                    this.obj.setProperty(key, value);
                }
                catch (FrameworkException fex) {
                    StructrScriptable.this.exception = fex;
                }
            }
        }

        public void put(int i, Scriptable s, Object o) {
        }

        public void delete(String string) {
            PropertyKey key = this.getKey(string);
            if (key != null) {
                try {
                    this.obj.setProperty(key, null);
                }
                catch (FrameworkException fex) {
                    StructrScriptable.this.exception = fex;
                }
            }
        }

        public void delete(int i) {
        }

        public Scriptable getPrototype() {
            return this.prototype;
        }

        public void setPrototype(Scriptable s) {
            this.prototype = s;
        }

        public Scriptable getParentScope() {
            return this.scope;
        }

        public void setParentScope(Scriptable s) {
            this.scope = s;
        }

        public Object[] getIds() {
            return IDs;
        }

        public Object getDefaultValue(Class<?> hint) {
            if (hint == null) {
                return this.unwrap();
            }
            if (String.class.equals(hint)) {
                return this.toString();
            }
            return null;
        }

        public boolean hasInstance(Scriptable s) {
            return false;
        }

        public Object unwrap() {
            return this.obj;
        }

        private PropertyKey getKey(String name) {
            return StructrApp.getConfiguration().getPropertyKeyForJSONName(this.obj.getClass(), name, false);
        }

        private Object checkEntityMethods(String name) {
            if ("grant".equals(name)) {
                return new IdFunctionObject(new IdFunctionCall(){

                    public Object execIdCall(IdFunctionObject info, Context context, Scriptable scope, Scriptable thisObject, Object[] parameters) {
                        if (parameters.length > 0 && parameters[0] != null) {
                            try {
                                if (parameters.length >= 2 && parameters[0] != null && parameters[1] != null) {
                                    Object principal = StructrScriptable.this.unwrap(parameters[0]);
                                    String permissions = parameters[1].toString();
                                    if (parameters.length > 2) {
                                        for (int i = 2; i < parameters.length; ++i) {
                                            if (parameters[i] == null) continue;
                                            permissions = permissions + "," + parameters[i].toString();
                                        }
                                    }
                                    new GrantFunction().apply(StructrScriptable.this.actionContext, (Object)null, new Object[]{principal, GraphObjectWrapper.this.obj, permissions});
                                }
                                return null;
                            }
                            catch (FrameworkException ex) {
                                StructrScriptable.this.exception = ex;
                            }
                        }
                        return null;
                    }
                }, null, 0, 0);
            }
            return null;
        }
    }

    public class StructrArray
    extends NativeArray {
        private Scriptable rootScriptable;
        private String key;

        public StructrArray(Scriptable rootScriptable, String key, Object[] array) {
            super(array);
            this.rootScriptable = null;
            this.key = null;
            ScriptRuntime.setBuiltinProtoAndParent((ScriptableObject)this, (Scriptable)rootScriptable, (TopLevel.Builtins)TopLevel.Builtins.Array);
            this.rootScriptable = rootScriptable;
            this.key = key;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            boolean first = true;
            buf.append("[");
            for (Object obj : this.toArray()) {
                if (!first) {
                    buf.append(",");
                }
                buf.append(obj.toString());
                first = false;
            }
            buf.append("]");
            return buf.toString();
        }

        public Object get(String name, Scriptable s) {
            Object pushFunction;
            Scriptable prototype;
            Object obj = super.get(name, s);
            if (this.key != null && obj != null && "push".equals(name) && (prototype = this.getPrototype()) != null && (pushFunction = prototype.get(name, s)) != null && pushFunction instanceof IdFunctionObject) {
                final IdFunctionObject push = (IdFunctionObject)pushFunction;
                return new IdFunctionObject(new IdFunctionCall(){

                    public Object execIdCall(IdFunctionObject f, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
                        Object result = push.call(cx, scope, thisObj, args);
                        StructrArray.this.rootScriptable.put(StructrArray.this.key, StructrArray.this.rootScriptable, (Object)StructrArray.this);
                        return result;
                    }
                }, (Object)"Array", push.methodId(), push.getArity());
            }
            return obj;
        }

        public Object getDefaultValue(Class<?> hint) {
            if (String.class.equals(hint)) {
                return this.toString();
            }
            return "[object Array]";
        }
    }

    public class FunctionWrapper
    implements IdFunctionCall {
        private Function<Object, Object> function = null;

        public FunctionWrapper(Function<Object, Object> function) {
            this.function = function;
        }

        public Object execIdCall(IdFunctionObject info, Context context, Scriptable scope, Scriptable thisObject, Object[] parameters) {
            try {
                Object[] unwrappedParameters = new Object[parameters.length];
                int i = 0;
                for (Object param : parameters) {
                    unwrappedParameters[i++] = StructrScriptable.this.unwrap(param);
                }
                return StructrScriptable.this.wrap(context, scope, null, this.function.apply(StructrScriptable.this.actionContext, StructrScriptable.this.entity, (Object[])unwrappedParameters));
            }
            catch (FrameworkException fex) {
                StructrScriptable.this.exception = fex;
                return null;
            }
        }
    }
}

