/*
 * Decompiled with CFR 0.152.
 */
package org.structr.cron;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.cron.CronField;
import org.structr.cron.CronService;

public class CronEntry
implements Delayed {
    private static final Logger logger = LoggerFactory.getLogger((String)CronService.class.getName());
    private CronField days = null;
    private CronField dow = null;
    private CronField hours = null;
    private CronField minutes = null;
    private CronField months = null;
    private CronField seconds = null;
    private String name = null;

    private CronEntry(String name) {
        this.name = name;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.seconds.toString());
        buf.append(" ");
        buf.append(this.minutes.toString());
        buf.append(" ");
        buf.append(this.hours.toString());
        buf.append(" ");
        buf.append(this.days.toString());
        buf.append(" ");
        buf.append(this.months.toString());
        buf.append(" ");
        buf.append(this.dow.toString());
        buf.append(" ");
        return buf.toString();
    }

    public static CronEntry parse(String task, String expression) {
        String[] fields = expression.split("[ \\t]+");
        if (fields.length == 6) {
            CronEntry cronEntry = new CronEntry(task);
            String secondsField = fields[0];
            String minutesField = fields[1];
            String hoursField = fields[2];
            String daysField = fields[3];
            String monthsField = fields[4];
            String weeksField = fields[5];
            try {
                CronField seconds = CronEntry.parseField(secondsField, 0, 59);
                cronEntry.setSeconds(seconds);
            }
            catch (Throwable t) {
                logger.warn("Invalid cron expression for task {}, field 'seconds': {}", new Object[]{task, t.getMessage()});
            }
            try {
                CronField minutes = CronEntry.parseField(minutesField, 0, 59);
                cronEntry.setMinutes(minutes);
            }
            catch (Throwable t) {
                logger.warn("Invalid cron expression for task {}, field 'minutes': {}", new Object[]{task, t.getMessage()});
            }
            try {
                CronField hours = CronEntry.parseField(hoursField, 0, 23);
                cronEntry.setHours(hours);
            }
            catch (Throwable t) {
                logger.warn("Invalid cron expression for task {}, field 'hours': {}", new Object[]{task, t.getMessage()});
            }
            try {
                CronField days = CronEntry.parseField(daysField, 1, 31);
                cronEntry.setDays(days);
            }
            catch (Throwable t) {
                logger.warn("Invalid cron expression for task {}, field 'days': {}", new Object[]{task, t.getMessage()});
            }
            try {
                CronField weeks = CronEntry.parseField(weeksField, 0, 6);
                cronEntry.setWeeks(weeks);
            }
            catch (Throwable t) {
                logger.warn("Invalid cron expression for task {}, field 'weeks': {}", new Object[]{task, t.getMessage()});
            }
            try {
                CronField months = CronEntry.parseField(monthsField, 1, 12);
                cronEntry.setMonths(months);
            }
            catch (Throwable t) {
                logger.warn("Invalid cron expression for task {}, field 'months': {}", new Object[]{task, t.getMessage()});
            }
            return cronEntry;
        }
        logger.warn("Invalid cron expression for task {}: invalid number of fields (must be {}).", new Object[]{task, 6});
        return null;
    }

    private static CronField parseField(String field, int minValue, int maxValue) {
        if ("*".equals(field)) {
            return new CronField(minValue, maxValue, 1, true);
        }
        if (field.startsWith("*/")) {
            int step = Integer.parseInt(field.substring(2));
            if (step > 0 & step <= maxValue) {
                return new CronField(minValue, maxValue, step);
            }
            throw new IllegalArgumentException("Illegal step: '" + step + "'");
        }
        if (field.matches("[0-9]{1,2}")) {
            int value = Integer.parseInt(field);
            if (value >= minValue && value <= maxValue) {
                return new CronField(value, value, 1);
            }
            throw new IllegalArgumentException("Parameter not within range: '" + field + "'");
        }
        if (field.matches("[0-9]{1,2}-[0-9]{1,2}")) {
            String[] rangeValues = field.split("[-]+");
            if (rangeValues.length == 2) {
                int start = Integer.parseInt(rangeValues[0]);
                int end = Integer.parseInt(rangeValues[1]);
                if (start >= minValue && start <= maxValue && end >= minValue && end <= maxValue) {
                    return new CronField(start, end, 1);
                }
                throw new IllegalArgumentException("Parameters not within range: '" + field + "'");
            }
            throw new IllegalArgumentException("Invalid range: '" + field + "'");
        }
        if (field.contains(",")) {
            String[] listValues = field.split("[,]+");
            LinkedList<Integer> values = new LinkedList<Integer>();
            for (String value : listValues) {
                try {
                    values.add(Integer.parseInt(value));
                }
                catch (Throwable t) {
                    throw new IllegalArgumentException("Invalid list value: '" + value + "'");
                }
            }
            return new CronField(values);
        }
        if (field.matches("[0-9]{1,2}-[0-9]{1,2}/[0-9]{1,2}")) {
            throw new UnsupportedOperationException("Steps are not supported yet.");
        }
        throw new IllegalArgumentException("Invalid field: '" + field + "'");
    }

    @Override
    public int compareTo(Delayed o) {
        Long myDelay = this.getDelay(TimeUnit.MILLISECONDS);
        Long oDelay = o.getDelay(TimeUnit.MILLISECONDS);
        return myDelay.compareTo(oDelay);
    }

    public long getDelayToNextExecutionInMillis() {
        Calendar now = GregorianCalendar.getInstance();
        int nowSeconds = now.get(13);
        int nowMinutes = now.get(12);
        int nowHours = now.get(11);
        int nowDays = now.get(5);
        int nowDow = now.get(7) - 1;
        int nowMonths = now.get(2) + 1;
        boolean modified = true;
        int maxTries = 10000;
        int numTries = 0;
        while (modified && numTries++ < maxTries) {
            modified = false;
            if (!modified && !this.seconds.isInside(nowSeconds)) {
                now.add(13, 1);
                modified = true;
            }
            if (!modified && !this.minutes.isInside(nowMinutes)) {
                now.add(12, 1);
                modified = true;
            }
            if (!modified && !this.hours.isInside(nowHours)) {
                now.add(11, 1);
                modified = true;
            }
            if (!this.dow.isIsWildcard() && !this.days.isIsWildcard()) {
                if (!(modified || this.dow.isInside(nowDow) || this.days.isInside(nowDays))) {
                    now.add(5, 1);
                    modified = true;
                }
            } else if (!this.dow.isIsWildcard()) {
                if (!modified && !this.dow.isInside(nowDow)) {
                    now.add(5, 1);
                    modified = true;
                }
            } else if (!(this.days.isIsWildcard() || modified || this.days.isInside(nowDays))) {
                now.add(5, 1);
                modified = true;
            }
            if (!modified && !this.months.isInside(nowMonths)) {
                now.add(2, 1);
                modified = true;
            }
            nowSeconds = now.get(13);
            nowMinutes = now.get(12);
            nowHours = now.get(11);
            nowDays = now.get(5);
            nowDow = now.get(7) - 1;
            nowMonths = now.get(2) + 1;
        }
        if (numTries == maxTries) {
            throw new IllegalArgumentException("Unable to determine next cron date for task " + this.name + ", aborting.");
        }
        return now.getTimeInMillis() - System.currentTimeMillis();
    }

    public CronField getSeconds() {
        return this.seconds;
    }

    public CronField getMinutes() {
        return this.minutes;
    }

    public CronField getHours() {
        return this.hours;
    }

    public CronField getDays() {
        return this.days;
    }

    public CronField getWeeks() {
        return this.dow;
    }

    public CronField getMonths() {
        return this.months;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public long getDelay(TimeUnit unit) {
        long next = TimeUnit.MILLISECONDS.convert(this.getDelayToNextExecutionInMillis(), unit);
        logger.info("{} ms until start of task {}", new Object[]{next, this.name});
        return next;
    }

    public void setSeconds(CronField seconds) {
        this.seconds = seconds;
    }

    public void setMinutes(CronField minutes) {
        this.minutes = minutes;
    }

    public void setHours(CronField hours) {
        this.hours = hours;
    }

    public void setDays(CronField days) {
        this.days = days;
    }

    public void setWeeks(CronField weeks) {
        this.dow = weeks;
    }

    public void setMonths(CronField months) {
        this.months = months;
    }

    public void setName(String name) {
        this.name = name;
    }
}

