/*
 * Decompiled with CFR 0.152.
 */
package org.structr.cron;

import java.util.Iterator;
import java.util.List;

public class CronField {
    private boolean isWildcard = false;
    private List<Integer> list = null;
    private int start = 0;
    private int step = 0;
    private int end = 0;

    public CronField(int start, int end, int step) {
        this(start, end, step, false);
    }

    public CronField(int start, int end, int step, boolean isWildcard) {
        this.isWildcard = isWildcard;
        this.start = start;
        this.step = step;
        this.end = end;
    }

    public CronField(List<Integer> values) {
        this.list = values;
    }

    public boolean isInside(int value) {
        if (this.isWildcard) {
            return true;
        }
        if (this.list != null) {
            return this.list.contains(value);
        }
        return value >= this.start && value <= this.end && (value + this.start) % this.step == 0;
    }

    public int getStartValue() {
        return this.start;
    }

    public int getEndValue() {
        return this.end;
    }

    public int getStep() {
        return this.step;
    }

    public List<Integer> getList() {
        return this.list;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (this.list != null) {
            Iterator<Integer> it = this.list.iterator();
            while (it.hasNext()) {
                buf.append(it.next());
                if (!it.hasNext()) continue;
                buf.append(",");
            }
        } else if (this.start == this.end) {
            buf.append(this.start);
        } else if (this.step == 1) {
            buf.append(this.start);
            buf.append("-");
            buf.append(this.end);
        } else {
            buf.append(this.start);
            buf.append("-");
            buf.append(this.end);
            buf.append("/");
            buf.append(this.step);
        }
        return buf.toString();
    }

    public boolean isIsWildcard() {
        return this.isWildcard;
    }

    public void setIsWildcard(boolean isWildcard) {
        this.isWildcard = isWildcard;
    }
}

