/*
 * Decompiled with CFR 0.152.
 */
package org.structr.schema;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javatools.parsers.PlingStemmer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.NotFoundException;
import org.structr.api.graph.PropertyContainer;
import org.structr.common.CaseHelper;
import org.structr.common.GraphObjectComparator;
import org.structr.common.PermissionPropagation;
import org.structr.common.PropertyView;
import org.structr.common.SecurityContext;
import org.structr.common.ValidationHelper;
import org.structr.common.View;
import org.structr.common.error.ErrorBuffer;
import org.structr.common.error.FrameworkException;
import org.structr.common.error.InvalidPropertySchemaToken;
import org.structr.core.Export;
import org.structr.core.GraphObject;
import org.structr.core.GraphObjectMap;
import org.structr.core.Services;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.converter.PropertyConverter;
import org.structr.core.entity.AbstractNode;
import org.structr.core.entity.AbstractRelationship;
import org.structr.core.entity.AbstractSchemaNode;
import org.structr.core.entity.DynamicResourceAccess;
import org.structr.core.entity.Relation;
import org.structr.core.entity.ResourceAccess;
import org.structr.core.entity.SchemaMethod;
import org.structr.core.entity.SchemaNode;
import org.structr.core.entity.SchemaProperty;
import org.structr.core.entity.SchemaRelationshipNode;
import org.structr.core.entity.SchemaView;
import org.structr.core.graph.ModificationQueue;
import org.structr.core.graph.NodeAttribute;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.RelationshipInterface;
import org.structr.core.property.BooleanProperty;
import org.structr.core.property.GenericProperty;
import org.structr.core.property.LongProperty;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.RelationProperty;
import org.structr.core.property.StringProperty;
import org.structr.module.StructrModule;
import org.structr.schema.ConfigurationProvider;
import org.structr.schema.Schema;
import org.structr.schema.SchemaService;
import org.structr.schema.action.ActionEntry;
import org.structr.schema.action.Actions;
import org.structr.schema.parser.BooleanArrayPropertyParser;
import org.structr.schema.parser.BooleanPropertyParser;
import org.structr.schema.parser.CountPropertyParser;
import org.structr.schema.parser.CypherPropertyParser;
import org.structr.schema.parser.DatePropertyParser;
import org.structr.schema.parser.DoubleArrayPropertyParser;
import org.structr.schema.parser.DoublePropertyParser;
import org.structr.schema.parser.EnumPropertyParser;
import org.structr.schema.parser.FunctionPropertyParser;
import org.structr.schema.parser.IntPropertyParser;
import org.structr.schema.parser.IntegerArrayPropertyParser;
import org.structr.schema.parser.JoinPropertyParser;
import org.structr.schema.parser.LongArrayPropertyParser;
import org.structr.schema.parser.LongPropertyParser;
import org.structr.schema.parser.NotionPropertyParser;
import org.structr.schema.parser.PropertyDefinition;
import org.structr.schema.parser.PropertySourceGenerator;
import org.structr.schema.parser.StringArrayPropertyParser;
import org.structr.schema.parser.StringBasedPropertyDefinition;
import org.structr.schema.parser.StringPropertySourceGenerator;
import org.structr.schema.parser.Validator;

public class SchemaHelper {
    private static final Logger logger = LoggerFactory.getLogger((String)SchemaHelper.class.getName());
    private static final String WORD_SEPARATOR = "_";
    public static final Map<Type, Class<? extends PropertySourceGenerator>> parserMap = new TreeMap<Type, Class<? extends PropertySourceGenerator>>(new ReverseTypeComparator());
    private static final Map<String, String> normalizedEntityNameCache = new LinkedHashMap<String, String>();

    public static String normalizeEntityName(String possibleEntityString) {
        if (possibleEntityString == null) {
            return null;
        }
        if ("/".equals(possibleEntityString)) {
            return "/";
        }
        StringBuilder result = new StringBuilder();
        if (possibleEntityString.contains("/")) {
            String[] names;
            for (String possibleEntityName : names = StringUtils.split((String)possibleEntityString, (String)"/")) {
                String normalizedType = normalizedEntityNameCache.get(possibleEntityName);
                if (normalizedType == null) {
                    normalizedType = StringUtils.capitalize((String)CaseHelper.toUpperCamelCase(SchemaHelper.stem(possibleEntityName)));
                }
                result.append(normalizedType).append("/");
            }
            return StringUtils.removeEnd((String)result.toString(), (String)"/");
        }
        String normalizedType = normalizedEntityNameCache.get(possibleEntityString);
        if (normalizedType == null) {
            normalizedType = StringUtils.capitalize((String)CaseHelper.toUpperCamelCase(SchemaHelper.stem(possibleEntityString)));
        }
        return normalizedType;
    }

    private static String stem(String term) {
        String lastWord;
        String begin = "";
        if (StringUtils.contains((CharSequence)term, (CharSequence)WORD_SEPARATOR)) {
            lastWord = StringUtils.substringAfterLast((String)term, (String)WORD_SEPARATOR);
            begin = StringUtils.substringBeforeLast((String)term, (String)WORD_SEPARATOR);
        } else {
            lastWord = term;
        }
        lastWord = PlingStemmer.stem(lastWord);
        return begin.concat(WORD_SEPARATOR).concat(lastWord);
    }

    public static Class getEntityClassForRawType(String rawType) {
        Class type = SchemaHelper.getEntityClassForRawType(rawType, false);
        if (type == null) {
            type = SchemaHelper.getEntityClassForRawType(rawType, true);
        }
        return type;
    }

    private static Class getEntityClassForRawType(String rawType, boolean normalize) {
        String normalizedEntityName = normalize ? SchemaHelper.normalizeEntityName(rawType) : rawType;
        ConfigurationProvider configuration = StructrApp.getConfiguration();
        Class<? extends NodeInterface> type = configuration.getNodeEntities().get(normalizedEntityName);
        if (type == null) {
            type = configuration.getRelationshipEntities().get(normalizedEntityName);
        }
        if (type == null) {
            type = configuration.getInterfaces().get(normalizedEntityName);
        }
        if (type != null) {
            normalizedEntityNameCache.put(rawType, type.getSimpleName());
        }
        if (type == null) {
            if (AbstractNode.class.getSimpleName().equals(rawType)) {
                return AbstractNode.class;
            }
            if (NodeInterface.class.getSimpleName().equals(rawType)) {
                return NodeInterface.class;
            }
            if (AbstractRelationship.class.getSimpleName().equals(rawType)) {
                return AbstractRelationship.class;
            }
            if (RelationshipInterface.class.getSimpleName().equals(rawType)) {
                return RelationshipInterface.class;
            }
        }
        return type;
    }

    public static boolean reloadSchema(ErrorBuffer errorBuffer, String initiatedBySessionId) {
        try {
            App app = StructrApp.getInstance();
            List<SchemaNode> existingSchemaNodes = app.nodeQuery(SchemaNode.class).getAsList();
            SchemaHelper.cleanUnusedDynamicGrants(existingSchemaNodes);
            for (SchemaNode schemaNode : existingSchemaNodes) {
                SchemaHelper.createDynamicGrants(schemaNode.getResourceSignature());
            }
            for (SchemaRelationshipNode schemaRelationship : StructrApp.getInstance().nodeQuery(SchemaRelationshipNode.class).getAsList()) {
                SchemaHelper.createDynamicGrants(schemaRelationship.getResourceSignature());
                SchemaHelper.createDynamicGrants(schemaRelationship.getInverseResourceSignature());
            }
        }
        catch (Throwable t) {
            logger.warn("", t);
        }
        return SchemaService.reloadSchema(errorBuffer, initiatedBySessionId);
    }

    public static void cleanUnusedDynamicGrants(List<SchemaNode> existingSchemaNodes) {
        try {
            List<DynamicResourceAccess> existingDynamicGrants = StructrApp.getInstance().nodeQuery(DynamicResourceAccess.class).getAsList();
            HashSet<String> existingSchemaNodeNames = new HashSet<String>();
            for (SchemaNode schemaNode : existingSchemaNodes) {
                existingSchemaNodeNames.add(schemaNode.getResourceSignature());
            }
            for (DynamicResourceAccess grant : existingDynamicGrants) {
                String sig;
                boolean foundAllParts = true;
                try {
                    sig = grant.getResourceSignature();
                }
                catch (NotFoundException nfe) {
                    logger.debug("Unable to get signature from grant");
                    continue;
                }
                String[] parts = StringUtils.split((String)sig, (String)"/");
                if (parts != null) {
                    for (String sigPart : parts) {
                        if ("/".equals(sigPart) || sigPart.startsWith(WORD_SEPARATOR)) continue;
                        foundAllParts &= existingSchemaNodeNames.contains(sigPart);
                    }
                }
                if (foundAllParts) continue;
                logger.info("Did not find all parts of signature, will be removed: {}, ", new Object[]{sig});
                SchemaHelper.removeDynamicGrants(sig);
            }
        }
        catch (Throwable t) {
            logger.warn("", t);
        }
    }

    public static List<DynamicResourceAccess> createDynamicGrants(String signature) {
        LinkedList<DynamicResourceAccess> grants = new LinkedList<DynamicResourceAccess>();
        long initialFlagsValue = 0L;
        App app = StructrApp.getInstance();
        try {
            ResourceAccess grant = app.nodeQuery(ResourceAccess.class).and(ResourceAccess.signature, signature).getFirst();
            if (grant == null) {
                grants.add(app.create(DynamicResourceAccess.class, new NodeAttribute<String>(DynamicResourceAccess.signature, signature), new NodeAttribute<Long>(DynamicResourceAccess.flags, 0L)));
                logger.info("New signature created: {}", new Object[]{signature});
            }
            String schemaSig = SchemaHelper.schemaResourceSignature(signature);
            ResourceAccess schemaGrant = app.nodeQuery(ResourceAccess.class).and(ResourceAccess.signature, schemaSig).getFirst();
            if (schemaGrant == null) {
                grants.add(app.create(DynamicResourceAccess.class, new NodeAttribute<String>(DynamicResourceAccess.signature, schemaSig), new NodeAttribute<Long>(DynamicResourceAccess.flags, 0L)));
                logger.info("New signature created: {}", new Object[]{schemaSig});
            }
            String uiSig = SchemaHelper.uiViewResourceSignature(signature);
            ResourceAccess uiViewGrant = app.nodeQuery(ResourceAccess.class).and(ResourceAccess.signature, uiSig).getFirst();
            if (uiViewGrant == null) {
                grants.add(app.create(DynamicResourceAccess.class, new NodeAttribute<String>(DynamicResourceAccess.signature, uiSig), new NodeAttribute<Long>(DynamicResourceAccess.flags, 0L)));
                logger.info("New signature created: {}", new Object[]{uiSig});
            }
        }
        catch (Throwable t) {
            logger.warn("", t);
        }
        return grants;
    }

    public static void removeAllDynamicGrants() {
        App app = StructrApp.getInstance();
        try {
            for (DynamicResourceAccess grant : app.nodeQuery(DynamicResourceAccess.class).getAsList()) {
                app.delete(grant);
            }
        }
        catch (Throwable t) {
            logger.warn("", t);
        }
    }

    public static void removeDynamicGrants(String signature) {
        App app = StructrApp.getInstance();
        try {
            DynamicResourceAccess viewGrant;
            DynamicResourceAccess schemaGrant;
            DynamicResourceAccess grant = app.nodeQuery(DynamicResourceAccess.class).and(DynamicResourceAccess.signature, signature).getFirst();
            if (grant != null) {
                app.delete(grant);
            }
            if ((schemaGrant = app.nodeQuery(DynamicResourceAccess.class).and(DynamicResourceAccess.signature, "_schema/" + signature).getFirst()) != null) {
                app.delete(schemaGrant);
            }
            if ((viewGrant = app.nodeQuery(DynamicResourceAccess.class).and(DynamicResourceAccess.signature, signature + "/_Ui").getFirst()) != null) {
                app.delete(viewGrant);
            }
        }
        catch (Throwable t) {
            logger.warn("", t);
        }
    }

    public static String extractProperties(Schema entity, Set<String> propertyNames, Set<Validator> validators, Set<String> compoundIndexKeys, Set<String> enums, Map<String, Set<String>> views, ErrorBuffer errorBuffer) throws FrameworkException {
        PropertySourceGenerator parser;
        PropertyContainer propertyContainer = entity.getPropertyContainer();
        StringBuilder src = new StringBuilder();
        for (String propertyName : SchemaHelper.getProperties(propertyContainer)) {
            if (propertyName.startsWith("__") || !propertyContainer.hasProperty(propertyName)) continue;
            String rawType = propertyContainer.getProperty(propertyName).toString();
            parser = SchemaHelper.getSourceGenerator(errorBuffer, entity.getClassName(), new StringBasedPropertyDefinition(propertyName, rawType));
            if (parser == null || !(entity instanceof AbstractSchemaNode)) continue;
            parser.createSchemaPropertyNode((AbstractSchemaNode)entity, propertyName);
        }
        List<SchemaProperty> schemaProperties = entity.getSchemaProperties();
        if (schemaProperties != null) {
            for (SchemaProperty schemaProperty : schemaProperties) {
                String format;
                if (schemaProperty.getProperty(SchemaProperty.isBuiltinProperty).booleanValue()) continue;
                if (Type.Function.equals((Object)schemaProperty.getPropertyType()) && (format = schemaProperty.getFormat()) != null) {
                    try {
                        schemaProperty.setProperty(SchemaProperty.readFunction, format);
                        schemaProperty.setProperty(SchemaProperty.format, null);
                    }
                    catch (FrameworkException ex) {
                        logger.warn("", (Throwable)ex);
                    }
                }
                if ((parser = SchemaHelper.getSourceGenerator(errorBuffer, entity.getClassName(), schemaProperty)) == null) continue;
                String propertyName = schemaProperty.getPropertyName();
                propertyNames.add(propertyName);
                parser.getPropertySource(src, entity);
                validators.addAll(parser.getGlobalValidators());
                compoundIndexKeys.addAll(parser.getCompoundIndexKeys());
                enums.addAll(parser.getEnumDefinitions());
                SchemaHelper.addPropertyToView("ui", propertyName, views);
            }
        }
        return src.toString();
    }

    public static void extractViews(Schema entity, Map<String, Set<String>> views, ErrorBuffer errorBuffer) throws FrameworkException {
        String[] properties;
        String viewName;
        PropertyContainer propertyContainer = entity.getPropertyContainer();
        ConfigurationProvider config = StructrApp.getConfiguration();
        Class superClass = config.getNodeEntityClass(entity.getSuperclassName());
        if (superClass == null) {
            superClass = config.getRelationshipEntityClass(entity.getSuperclassName());
        }
        if (superClass == null) {
            superClass = AbstractNode.class;
        }
        for (String rawViewName : SchemaHelper.getViews(propertyContainer)) {
            if (rawViewName.startsWith("___") || !propertyContainer.hasProperty(rawViewName)) continue;
            String value = propertyContainer.getProperty(rawViewName).toString();
            String[] parts = value.split("[,\\s]+");
            viewName = rawViewName.substring(2);
            if (!(entity instanceof AbstractSchemaNode)) continue;
            LinkedList<String> nonGraphProperties = new LinkedList<String>();
            properties = new LinkedList();
            AbstractSchemaNode schemaNode = (AbstractSchemaNode)entity;
            App app = StructrApp.getInstance();
            if (app.nodeQuery(SchemaView.class).and(SchemaView.schemaNode, schemaNode).and(AbstractNode.name, viewName).getFirst() != null) continue;
            for (int i = 0; i < parts.length; ++i) {
                SchemaProperty propertyNode;
                String propertyName = parts[i].trim();
                while (propertyName.startsWith(WORD_SEPARATOR)) {
                    propertyName = propertyName.substring(1);
                }
                if (propertyName.endsWith("Property")) {
                    propertyName = propertyName.substring(0, propertyName.length() - "Property".length());
                }
                if ((propertyNode = app.nodeQuery(SchemaProperty.class).and(SchemaProperty.schemaNode, schemaNode).andName(propertyName).getFirst()) != null) {
                    properties.add(propertyNode);
                    continue;
                }
                nonGraphProperties.add(propertyName);
            }
            app.create(SchemaView.class, new NodeAttribute<AbstractSchemaNode>(SchemaView.schemaNode, schemaNode), new NodeAttribute<String[]>(SchemaView.schemaProperties, properties), new NodeAttribute<String>(SchemaView.name, viewName), new NodeAttribute<String>(SchemaView.nonGraphProperties, StringUtils.join(nonGraphProperties, (String)",")));
            schemaNode.removeProperty(new StringProperty(rawViewName));
        }
        List<SchemaView> schemaViews = entity.getSchemaViews();
        if (schemaViews != null) {
            for (SchemaView schemaView : schemaViews) {
                String order;
                String nonGraphProperties = schemaView.getProperty(SchemaView.nonGraphProperties);
                viewName = schemaView.getName();
                Set<String> view = views.get(viewName);
                if (view == null) {
                    view = new LinkedHashSet<String>();
                    views.put(viewName, view);
                }
                for (SchemaProperty property : schemaView.getProperty(SchemaView.schemaProperties)) {
                    if (property.getProperty(SchemaProperty.isBuiltinProperty).booleanValue() && !property.getProperty(SchemaProperty.isDynamic).booleanValue()) {
                        view.add(property.getPropertyName());
                        continue;
                    }
                    view.add(property.getPropertyName() + "Property");
                }
                if (StringUtils.isNotBlank((CharSequence)nonGraphProperties)) {
                    properties = nonGraphProperties.split("[, ]+");
                    int n = properties.length;
                    for (int i = 0; i < n; ++i) {
                        String propertyName;
                        String extendedPropertyName = propertyName = properties[i];
                        if (superClass != null) {
                            PropertyKey property = config.getPropertyKeyForJSONName(superClass, propertyName, false);
                            if (property != null) {
                                if (property.isDynamic()) {
                                    extendedPropertyName = extendedPropertyName + "Property";
                                }
                            } else {
                                extendedPropertyName = extendedPropertyName + "Property";
                            }
                        } else {
                            extendedPropertyName = extendedPropertyName + "Property";
                        }
                        view.add(extendedPropertyName);
                    }
                }
                if ((order = schemaView.getProperty(SchemaView.sortOrder)) == null) continue;
                SchemaHelper.applySortOrder(view, order, viewName, entity.getClassName());
            }
        }
    }

    public static void extractMethods(Schema entity, Map<Actions.Type, List<ActionEntry>> actions) throws FrameworkException {
        PropertyContainer propertyContainer = entity.getPropertyContainer();
        for (String rawActionName : SchemaHelper.getActions(propertyContainer)) {
            if (!propertyContainer.hasProperty(rawActionName)) continue;
            String value = propertyContainer.getProperty(rawActionName).toString();
            if (!(entity instanceof AbstractSchemaNode)) continue;
            AbstractSchemaNode schemaNode = (AbstractSchemaNode)entity;
            App app = StructrApp.getInstance();
            String methodName = rawActionName.substring(3);
            if (app.nodeQuery(SchemaMethod.class).and(SchemaMethod.schemaNode, schemaNode).and(AbstractNode.name, methodName).getFirst() != null) continue;
            app.create(SchemaMethod.class, new NodeAttribute<AbstractSchemaNode>(SchemaMethod.schemaNode, schemaNode), new NodeAttribute<String>(SchemaMethod.name, methodName), new NodeAttribute<String>(SchemaMethod.source, value));
            schemaNode.removeProperty(new StringProperty(rawActionName));
        }
        List<SchemaMethod> schemaMethods = entity.getSchemaMethods();
        if (schemaMethods != null) {
            for (SchemaMethod schemaMethod : schemaMethods) {
                ActionEntry entry = schemaMethod.getActionEntry();
                List<ActionEntry> actionList = actions.get((Object)entry.getType());
                if (actionList == null) {
                    actionList = new LinkedList<ActionEntry>();
                    actions.put(entry.getType(), actionList);
                }
                actionList.add(entry);
                Collections.sort(actionList);
            }
        }
    }

    public static void addPropertyToView(String viewName, String propertyName, Map<String, Set<String>> views) {
        Set<String> view = views.get(viewName);
        if (view == null) {
            view = new LinkedHashSet<String>();
            views.put(viewName, view);
        }
        view.add(SchemaHelper.cleanPropertyName(propertyName) + "Property");
    }

    public static Iterable<String> getProperties(PropertyContainer propertyContainer) {
        LinkedList<String> keys = new LinkedList<String>();
        for (String key : propertyContainer.getPropertyKeys()) {
            if (!propertyContainer.hasProperty(key) || !key.startsWith(WORD_SEPARATOR)) continue;
            keys.add(key);
        }
        return keys;
    }

    public static Iterable<String> getViews(PropertyContainer propertyContainer) {
        LinkedList<String> keys = new LinkedList<String>();
        for (String key : propertyContainer.getPropertyKeys()) {
            if (!propertyContainer.hasProperty(key) || !key.startsWith("__")) continue;
            keys.add(key);
        }
        return keys;
    }

    public static Iterable<String> getActions(PropertyContainer propertyContainer) {
        LinkedList<String> keys = new LinkedList<String>();
        for (String key : propertyContainer.getPropertyKeys()) {
            if (!propertyContainer.hasProperty(key) || !key.startsWith("___")) continue;
            keys.add(key);
        }
        return keys;
    }

    public static void formatView(StringBuilder src, String _className, String viewName, String view, Set<String> viewProperties) {
        src.append("\n\tpublic static final View ").append(viewName).append("View = new View(").append(_className).append(".class, \"").append(view).append("\",\n");
        src.append("\t\t");
        Iterator<String> it = viewProperties.iterator();
        while (it.hasNext()) {
            String propertyName = it.next();
            if (propertyName.startsWith(WORD_SEPARATOR)) {
                propertyName = propertyName.substring(1) + "Property";
            }
            src.append(propertyName);
            if (!it.hasNext()) continue;
            src.append(", ");
        }
        src.append("\n\t);\n");
    }

    public static void formatImportStatements(AbstractSchemaNode schemaNode, StringBuilder src, Class baseType) {
        src.append("import ").append(baseType.getName()).append(";\n");
        src.append("import ").append(ConfigurationProvider.class.getName()).append(";\n");
        src.append("import ").append(GraphObjectComparator.class.getName()).append(";\n");
        src.append("import ").append(PermissionPropagation.class.getName()).append(";\n");
        src.append("import ").append(FrameworkException.class.getName()).append(";\n");
        src.append("import ").append(DatePropertyParser.class.getName()).append(";\n");
        src.append("import ").append(ModificationQueue.class.getName()).append(";\n");
        src.append("import ").append(PropertyConverter.class.getName()).append(";\n");
        src.append("import ").append(ValidationHelper.class.getName()).append(";\n");
        src.append("import ").append(SecurityContext.class.getName()).append(";\n");
        src.append("import ").append(LinkedHashSet.class.getName()).append(";\n");
        src.append("import ").append(PropertyView.class.getName()).append(";\n");
        src.append("import ").append(GraphObject.class.getName()).append(";\n");
        src.append("import ").append(ErrorBuffer.class.getName()).append(";\n");
        src.append("import ").append(StringUtils.class.getName()).append(";\n");
        src.append("import ").append(Collections.class.getName()).append(";\n");
        src.append("import ").append(StructrApp.class.getName()).append(";\n");
        src.append("import ").append(LinkedList.class.getName()).append(";\n");
        src.append("import ").append(Collection.class.getName()).append(";\n");
        src.append("import ").append(Services.class.getName()).append(";\n");
        src.append("import ").append(Actions.class.getName()).append(";\n");
        src.append("import ").append(HashMap.class.getName()).append(";\n");
        src.append("import ").append(Export.class.getName()).append(";\n");
        src.append("import ").append(View.class.getName()).append(";\n");
        src.append("import ").append(List.class.getName()).append(";\n");
        src.append("import ").append(Map.class.getName()).append(";\n");
        src.append("import ").append(Set.class.getName()).append(";\n");
        if (SchemaHelper.hasRestClasses()) {
            src.append("import org.structr.rest.RestMethodResult;\n");
        }
        src.append("import org.structr.core.property.*;\n");
        if (SchemaHelper.hasUiClasses()) {
            src.append("import org.structr.web.property.*;\n");
        }
        for (StructrModule module : StructrApp.getConfiguration().getModules().values()) {
            module.insertImportStatements(schemaNode, src);
        }
        src.append("import org.structr.core.notion.*;\n");
        src.append("import org.structr.core.entity.*;\n\n");
    }

    public static void formatInterfacesFromModules(StringBuilder src, SchemaNode schemaNode) {
        LinkedHashSet<String> interfaces = new LinkedHashSet<String>();
        boolean firstInterface = true;
        for (StructrModule module : StructrApp.getConfiguration().getModules().values()) {
            Set<String> moduleInterfacesForType = module.getInterfacesForType(schemaNode);
            if (moduleInterfacesForType == null) continue;
            interfaces.addAll(moduleInterfacesForType);
        }
        for (String iface : interfaces) {
            src.append(firstInterface ? " implements " : ", ");
            src.append(iface);
            firstInterface = false;
        }
    }

    public static String cleanPropertyName(String propertyName) {
        return propertyName.replaceAll("[^\\w]+", "");
    }

    public static void formatValidators(StringBuilder src, Set<Validator> validators, Set<String> compoundIndexKeys) {
        if (!validators.isEmpty() || !compoundIndexKeys.isEmpty()) {
            src.append("\n\t@Override\n");
            src.append("\tpublic boolean isValid(final ErrorBuffer errorBuffer) {\n\n");
            src.append("\t\tboolean valid = super.isValid(errorBuffer);\n\n");
            for (Validator validator : validators) {
                src.append("\t\tvalid &= ").append(validator.getSource("this", true)).append(";\n");
            }
            if (!compoundIndexKeys.isEmpty()) {
                src.append("\t\tvalid &= ValidationHelper.areValidCompoundUniqueProperties(this, errorBuffer, ").append(StringUtils.join(compoundIndexKeys, (String)", ")).append(");\n");
            }
            src.append("\n\t\treturn valid;\n");
            src.append("\t}\n");
        }
    }

    public static void formatDynamicValidators(StringBuilder src, Set<Validator> validators, Set<String> compoundIndexKeys) {
        if (!validators.isEmpty() || !compoundIndexKeys.isEmpty()) {
            src.append("\tpublic static boolean isValid(final AbstractNode obj, final ErrorBuffer errorBuffer) {\n\n");
            src.append("\t\tboolean valid = true;\n\n");
            for (Validator validator : validators) {
                src.append("\t\tvalid &= ").append(validator.getSource("obj", false)).append(";\n");
            }
            if (!compoundIndexKeys.isEmpty()) {
                src.append("\t\tvalid &= ValidationHelper.areValidCompoundUniqueProperties(obj, errorBuffer, ").append(StringUtils.join((Object[])new Set[]{compoundIndexKeys})).append(");\n");
            }
            src.append("\n\t\treturn valid;\n");
            src.append("\t}\n\n");
        }
    }

    public static void formatSaveActions(AbstractSchemaNode schemaNode, StringBuilder src, Map<Actions.Type, List<ActionEntry>> saveActions) {
        block3: for (Map.Entry<Actions.Type, List<ActionEntry>> entry : saveActions.entrySet()) {
            List<ActionEntry> actionList = entry.getValue();
            Actions.Type type = entry.getKey();
            switch (type) {
                case Custom: {
                    SchemaHelper.formatActiveActions(src, actionList);
                    continue block3;
                }
            }
            SchemaHelper.formatPassiveSaveActions(schemaNode, src, type, actionList);
        }
    }

    public static void formatDynamicSaveActions(StringBuilder src, Map<Actions.Type, List<ActionEntry>> saveActions) {
        block3: for (Map.Entry<Actions.Type, List<ActionEntry>> entry : saveActions.entrySet()) {
            List<ActionEntry> actionList = entry.getValue();
            Actions.Type type = entry.getKey();
            if (actionList.isEmpty()) continue;
            switch (type) {
                case Custom: {
                    continue block3;
                }
            }
            SchemaHelper.formatDynamicPassiveSaveActions(src, type, actionList);
        }
    }

    public static void formatActiveActions(StringBuilder src, List<ActionEntry> actionList) {
        for (ActionEntry action : actionList) {
            src.append("\n\t@Export\n");
            src.append("\tpublic Object ");
            src.append(action.getName());
            src.append("(final Map<String, Object> parameters) throws FrameworkException {\n\n");
            src.append("\t\treturn ");
            src.append(action.getSource("this", true));
            src.append(";\n\n");
            src.append("\t}\n");
        }
    }

    public static void formatDynamicActiveActions(StringBuilder src, List<ActionEntry> actionList) {
        for (ActionEntry action : actionList) {
            src.append("\tpublic static Object ");
            src.append(action.getName());
            src.append("(final AbstractNode obj) throws FrameworkException {\n\n");
            src.append("\t\treturn ");
            src.append(action.getSource("obj"));
            src.append(";\n\n");
            src.append("\t}\n");
        }
    }

    public static void formatPassiveSaveActions(AbstractSchemaNode schemaNode, StringBuilder src, Actions.Type type, List<ActionEntry> actionList) {
        src.append("\n\t@Override\n");
        src.append("\tpublic boolean ");
        src.append(type.getMethod());
        src.append("(");
        src.append(type.getSignature());
        src.append(") throws FrameworkException {\n\n");
        src.append("\t\tboolean valid = super.");
        src.append(type.getMethod());
        src.append("(");
        src.append(type.getParameters());
        src.append(");\n\n");
        for (StructrModule module : StructrApp.getConfiguration().getModules().values()) {
            module.insertSaveAction(schemaNode, src, type);
        }
        for (ActionEntry action : actionList) {
            src.append("\t\t").append(action.getSource("this")).append(";\n");
        }
        src.append("\n\t\treturn valid;\n");
        src.append("\t}\n");
    }

    public static void formatDynamicPassiveSaveActions(StringBuilder src, Actions.Type type, List<ActionEntry> actionList) {
        src.append("\tpublic static boolean ");
        src.append(type.getMethod());
        src.append("(final AbstractNode obj, final SecurityContext securityContext, final ErrorBuffer errorBuffer) throws FrameworkException {\n\n");
        src.append("\t\tboolean valid = obj.isValid(errorBuffer);\n\n");
        for (ActionEntry action : actionList) {
            src.append("\t\t").append(action.getSource("obj")).append(";\n");
        }
        src.append("\n\t\treturn valid;\n");
        src.append("\t}\n\n");
    }

    private static Map<String, Object> getPropertiesForView(SecurityContext securityContext, Class type, String propertyView) throws FrameworkException {
        LinkedHashSet<PropertyKey> properties = new LinkedHashSet<PropertyKey>(StructrApp.getConfiguration().getPropertySet(type, propertyView));
        LinkedHashMap<String, Object> propertyConverterMap = new LinkedHashMap<String, Object>();
        for (PropertyKey property : properties) {
            propertyConverterMap.put(property.jsonName(), SchemaHelper.getPropertyInfo(securityContext, property));
        }
        return propertyConverterMap;
    }

    public static List<GraphObjectMap> getSchemaTypeInfo(SecurityContext securityContext, String rawType, Class type, String propertyView) throws FrameworkException {
        LinkedList<GraphObjectMap> resultList;
        block5: {
            resultList = new LinkedList<GraphObjectMap>();
            if (type == null) break block5;
            if (propertyView != null) {
                for (Map.Entry<String, Object> entry : SchemaHelper.getPropertiesForView(securityContext, type, propertyView).entrySet()) {
                    GraphObjectMap property = new GraphObjectMap();
                    for (Map.Entry prop : ((Map)entry.getValue()).entrySet()) {
                        property.setProperty((PropertyKey)new GenericProperty((String)prop.getKey()), prop.getValue());
                    }
                    resultList.add(property);
                }
            } else {
                GraphObjectMap schema = new GraphObjectMap();
                resultList.add(schema);
                String url = "/".concat(rawType);
                schema.setProperty((PropertyKey)new StringProperty("url"), url);
                schema.setProperty((PropertyKey)new StringProperty("type"), type.getSimpleName());
                schema.setProperty((PropertyKey)new StringProperty("className"), type.getName());
                schema.setProperty((PropertyKey)new StringProperty("extendsClass"), type.getSuperclass().getName());
                schema.setProperty((PropertyKey)new BooleanProperty("isRel"), (Object)AbstractRelationship.class.isAssignableFrom(type));
                schema.setProperty((PropertyKey)new LongProperty("flags"), (Object)SecurityContext.getResourceFlags(rawType));
                LinkedHashSet<String> propertyViews = new LinkedHashSet<String>(StructrApp.getConfiguration().getPropertyViewsForType(type));
                TreeMap<String, Map<String, Object>> views = new TreeMap<String, Map<String, Object>>();
                schema.setProperty((PropertyKey)new GenericProperty("views"), views);
                for (String view : propertyViews) {
                    if ("_graph".equals(view)) continue;
                    views.put(view, SchemaHelper.getPropertiesForView(securityContext, type, view));
                }
            }
        }
        return resultList;
    }

    public static Map<String, Object> getPropertyInfo(SecurityContext securityContext, PropertyKey property) {
        Relation relation;
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("dbName", property.dbName());
        map.put("jsonName", property.jsonName());
        map.put("className", property.getClass().getName());
        Class declaringClass = property.getDeclaringClass();
        if (declaringClass != null) {
            map.put("declaringClass", declaringClass.getSimpleName());
        }
        map.put("defaultValue", property.defaultValue());
        if (property instanceof StringProperty) {
            map.put("contentType", ((StringProperty)property).contentType());
        }
        map.put("format", property.format());
        map.put("readOnly", property.isReadOnly());
        map.put("system", property.isSystemInternal());
        map.put("indexed", property.isIndexed());
        map.put("indexedWhenEmpty", property.isIndexedWhenEmpty());
        map.put("compound", property.isCompound());
        map.put("unique", property.isUnique());
        map.put("notNull", property.isNotNull());
        map.put("dynamic", property.isDynamic());
        Class relatedType = property.relatedType();
        if (relatedType != null) {
            map.put("relatedType", relatedType.getName());
            map.put("type", relatedType.getSimpleName());
            map.put("uiType", relatedType.getSimpleName() + (property.isCollection() ? "[]" : ""));
        } else {
            map.put("type", property.typeName());
            map.put("uiType", property.typeName() + (property.isCollection() ? "[]" : ""));
        }
        map.put("isCollection", property.isCollection());
        PropertyConverter databaseConverter = property.databaseConverter(securityContext, null);
        PropertyConverter inputConverter = property.inputConverter(securityContext);
        if (databaseConverter != null) {
            map.put("databaseConverter", databaseConverter.getClass().getName());
        }
        if (inputConverter != null) {
            map.put("inputConverter", inputConverter.getClass().getName());
        }
        if (declaringClass != null && property instanceof RelationProperty && (relation = ((RelationProperty)((Object)property)).getRelation()) != null) {
            map.put("relationshipType", relation.name());
        }
        return map;
    }

    private static PropertySourceGenerator getSourceGenerator(ErrorBuffer errorBuffer, String className, PropertyDefinition propertyDefinition) throws FrameworkException {
        String propertyName = propertyDefinition.getPropertyName();
        Type propertyType = propertyDefinition.getPropertyType();
        Class<? extends PropertySourceGenerator> parserClass = parserMap.get((Object)propertyType);
        try {
            return parserClass.getConstructor(ErrorBuffer.class, String.class, PropertyDefinition.class).newInstance(errorBuffer, className, propertyDefinition);
        }
        catch (Throwable t) {
            logger.warn("", t);
            errorBuffer.add(new InvalidPropertySchemaToken(SchemaProperty.class.getSimpleName(), propertyName, "invalid_property_definition", "Unknow value type " + SchemaMethod.source + ", options are " + Arrays.asList(Type.values()) + "."));
            throw new FrameworkException(422, "Invalid property definition for property " + propertyDefinition.getPropertyName(), errorBuffer);
        }
    }

    private static boolean hasRestClasses() {
        try {
            Class.forName("org.structr.rest.RestMethodResult");
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static boolean hasUiClasses() {
        try {
            Class.forName("org.structr.web.property.ThumbnailProperty");
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static boolean hasPeerToPeerService() {
        try {
            Class.forName("org.structr.net.SharedNodeInterface");
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static String schemaResourceSignature(String signature) {
        return "_schema/" + signature;
    }

    private static String uiViewResourceSignature(String signature) {
        return signature + "/_Ui";
    }

    private static void applySortOrder(Set<String> view, String orderString, String viewName, String typeName) {
        LinkedList<String> list = new LinkedList<String>();
        if ("alphabetic".equals(orderString)) {
            list.addAll(view);
            Collections.sort(list);
        } else {
            String[] order;
            for (String property : order = orderString.split("[, ]+")) {
                if (!StringUtils.isNotEmpty((CharSequence)property.trim())) continue;
                String suffixedProperty = property + "Property";
                if (view.contains(property)) {
                    list.add(property);
                    view.remove(property);
                    continue;
                }
                if (!view.contains(suffixedProperty)) continue;
                list.add(suffixedProperty);
                view.remove(suffixedProperty);
            }
            list.addAll(view);
        }
        view.clear();
        view.addAll(list);
    }

    static {
        parserMap.put(Type.BooleanArray, BooleanArrayPropertyParser.class);
        parserMap.put(Type.IntegerArray, IntegerArrayPropertyParser.class);
        parserMap.put(Type.DoubleArray, DoubleArrayPropertyParser.class);
        parserMap.put(Type.StringArray, StringArrayPropertyParser.class);
        parserMap.put(Type.LongArray, LongArrayPropertyParser.class);
        parserMap.put(Type.Function, FunctionPropertyParser.class);
        parserMap.put(Type.Boolean, BooleanPropertyParser.class);
        parserMap.put(Type.Integer, IntPropertyParser.class);
        parserMap.put(Type.String, StringPropertySourceGenerator.class);
        parserMap.put(Type.Double, DoublePropertyParser.class);
        parserMap.put(Type.Notion, NotionPropertyParser.class);
        parserMap.put(Type.Cypher, CypherPropertyParser.class);
        parserMap.put(Type.Long, LongPropertyParser.class);
        parserMap.put(Type.Enum, EnumPropertyParser.class);
        parserMap.put(Type.Date, DatePropertyParser.class);
        parserMap.put(Type.Count, CountPropertyParser.class);
        parserMap.put(Type.Join, JoinPropertyParser.class);
    }

    private static class ReverseTypeComparator
    implements Comparator<Type> {
        private ReverseTypeComparator() {
        }

        @Override
        public int compare(Type o1, Type o2) {
            return o2.name().compareTo(o1.name());
        }
    }

    public static enum Type {
        String,
        StringArray,
        LongArray,
        DoubleArray,
        IntegerArray,
        BooleanArray,
        Integer,
        Long,
        Double,
        Boolean,
        Enum,
        Date,
        Count,
        Function,
        Notion,
        Cypher,
        Join,
        Thumbnail;

    }
}

