/*
 * Decompiled with CFR 0.152.
 */
package org.structr.schema.action;

import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.Predicate;
import org.structr.api.config.Settings;
import org.structr.common.SecurityContext;
import org.structr.common.error.ErrorBuffer;
import org.structr.common.error.ErrorToken;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.graph.Tx;
import org.structr.core.script.Scripting;
import org.structr.schema.action.Function;
import org.structr.schema.action.JavaScriptSource;
import org.structr.schema.parser.DatePropertyParser;

public class ActionContext {
    private static final Logger logger = LoggerFactory.getLogger((String)ActionContext.class.getName());
    protected SecurityContext securityContext = null;
    protected Predicate predicate = null;
    protected Map<String, String> headers = new HashMap<String, String>();
    protected Map<String, Object> constants = new HashMap<String, Object>();
    protected Map<String, Object> tmpStore = new HashMap<String, Object>();
    protected Map<String, Date> timerStore = new HashMap<String, Date>();
    protected Map<Integer, Integer> counters = new HashMap<Integer, Integer>();
    protected ErrorBuffer errorBuffer = new ErrorBuffer();
    protected StringBuilder outputBuffer = new StringBuilder();
    protected Locale locale = Locale.getDefault();
    private boolean javaScriptContext = false;

    public ActionContext(SecurityContext securityContext) {
        this(securityContext, null);
    }

    public ActionContext(SecurityContext securityContext, Map<String, Object> parameters) {
        if (parameters != null) {
            this.tmpStore.putAll(parameters);
        }
        this.securityContext = securityContext;
        if (securityContext != null) {
            this.locale = securityContext.getEffectiveLocale();
        }
    }

    public ActionContext(ActionContext other) {
        this.tmpStore = other.tmpStore;
        this.timerStore = other.timerStore;
        this.counters = other.counters;
        this.errorBuffer = other.errorBuffer;
        this.constants = other.constants;
        this.securityContext = other.securityContext;
        this.locale = other.locale;
    }

    public SecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public void setSecurityContext(SecurityContext securityContext) {
        this.securityContext = securityContext;
    }

    public boolean returnRawValue() {
        return false;
    }

    public Object getConstant(String name) {
        return this.constants.get(name);
    }

    public void setConstant(String name, Object data) {
        this.constants.put(name, data);
    }

    public Object getReferencedProperty(GraphObject entity, String refKey, Object initialData, int depth) throws FrameworkException {
        String DEFAULT_VALUE_SEP = "!";
        String[] parts = refKey.split("[\\.]+");
        Object _data = initialData;
        for (int i = 0; i < parts.length; ++i) {
            String key = parts[i];
            String defaultValue = null;
            if (StringUtils.contains((CharSequence)key, (CharSequence)"!")) {
                String[] ref = StringUtils.split((String)key, (String)"!");
                key = ref[0];
                if (ref.length > 1) {
                    defaultValue = ref[1];
                }
            }
            _data = this.evaluate(entity, key, _data, defaultValue, i + depth);
        }
        return _data;
    }

    public void raiseError(int code, ErrorToken errorToken) {
        this.errorBuffer.add(errorToken);
        this.errorBuffer.setStatus(code);
    }

    public ErrorBuffer getErrorBuffer() {
        return this.errorBuffer;
    }

    public boolean hasError() {
        return this.errorBuffer.hasError();
    }

    public void incrementCounter(int level) {
        Integer value = this.counters.get(level);
        if (value == null) {
            value = 0;
        }
        this.counters.put(level, value + 1);
    }

    public int getCounter(int level) {
        Integer value = this.counters.get(level);
        if (value == null) {
            return 0;
        }
        return value;
    }

    public void resetCounter(int level) {
        this.counters.put(level, 0);
    }

    public void store(String key, Object value) {
        this.tmpStore.put(key, value);
    }

    public Object retrieve(String key) {
        return this.tmpStore.get(key);
    }

    public Map<String, Object> getAllVariables() {
        return this.tmpStore;
    }

    public void addTimer(String key) {
        this.timerStore.put(key, new Date());
    }

    public Date getTimer(String key) {
        return this.timerStore.get(key);
    }

    public void addHeader(String key, String value) {
        this.headers.put(key, value);
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public Object evaluate(GraphObject entity, String key, Object data, String defaultValue, int depth) throws FrameworkException {
        Object value = this.constants.get(key);
        if (value == null) {
            if (data instanceof HttpServletRequest) {
                value = ((HttpServletRequest)data).getParameter(key);
            }
            if (data instanceof Map) {
                value = ((Map)data).get(key);
            }
            if (data != null) {
                if (data instanceof GraphObject) {
                    value = ((GraphObject)data).evaluate(this, key, defaultValue);
                } else {
                    switch (key) {
                        case "size": {
                            if (data instanceof Collection) {
                                return ((Collection)data).size();
                            }
                            if (!data.getClass().isArray()) break;
                            return ((Object[])data).length;
                        }
                    }
                }
            } else {
                if (this.securityContext != null) {
                    switch (key) {
                        case "request": {
                            return this.securityContext.getRequest();
                        }
                        case "host": {
                            return this.securityContext.getRequest().getServerName();
                        }
                        case "port": {
                            return this.securityContext.getRequest().getServerPort();
                        }
                        case "pathInfo": 
                        case "path_info": {
                            return this.securityContext.getRequest().getPathInfo();
                        }
                        case "parameterMap": 
                        case "parameter_map": {
                            return this.securityContext.getRequest().getParameterMap();
                        }
                        case "remoteAddress": 
                        case "remote_address": {
                            String remoteAddress = this.securityContext.getRequest().getHeader("X-FORWARDED-FOR");
                            if (remoteAddress == null) {
                                return this.securityContext.getRequest().getRemoteAddr();
                            }
                            return remoteAddress;
                        }
                        case "response": {
                            HttpServletResponse response = this.securityContext.getResponse();
                            if (response != null) {
                                try {
                                    return response.getOutputStream();
                                }
                                catch (IOException ioex) {
                                    logger.warn("", (Throwable)ioex);
                                }
                            }
                            return null;
                        }
                        case "me": {
                            return this.securityContext.getUser(false);
                        }
                        case "depth": {
                            return this.securityContext.getSerializationDepth() - 1;
                        }
                    }
                }
                switch (key) {
                    case "now": {
                        return this.isJavaScriptContext() ? new Date() : DatePropertyParser.format(new Date(), (String)Settings.DefaultDateFormat.getValue());
                    }
                    case "element": {
                        logger.warn("The \"element\" keyword is deprecated! Please use \"this\" instead. Used in {}", (Object)entity.getProperty(GraphObject.id));
                    }
                    case "this": {
                        return entity;
                    }
                    case "locale": {
                        return this.locale != null ? this.locale.toString() : null;
                    }
                }
            }
        }
        if (value == null && defaultValue != null) {
            return Function.numberOrString(defaultValue);
        }
        return value;
    }

    public void print(Object ... objects) {
        for (Object obj : objects) {
            if (obj == null) continue;
            this.outputBuffer.append(Scripting.formatToDefaultDateOrString(obj));
        }
    }

    public void clear() {
        this.outputBuffer.setLength(0);
    }

    public String getOutput() {
        String out = this.outputBuffer.toString();
        this.clear();
        return out;
    }

    public boolean isJavaScriptContext() {
        return this.javaScriptContext;
    }

    public void setJavaScriptContext(boolean javaScriptContext) {
        this.javaScriptContext = javaScriptContext;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public String getJavascriptLibraryCode(String fileName) {
        StringBuilder buf = new StringBuilder();
        App app = StructrApp.getInstance();
        try (Tx tx = app.tx();){
            List<JavaScriptSource> jsFiles = app.nodeQuery(JavaScriptSource.class).and(JavaScriptSource.name, fileName).and(JavaScriptSource.useAsJavascriptLibrary, true).getAsList();
            if (jsFiles.isEmpty()) {
                logger.warn("No JavaScript library found with fileName: {}", (Object)fileName);
            }
            for (JavaScriptSource jsLibraryFile : jsFiles) {
                String contentType = jsLibraryFile.getContentType();
                if (contentType != null) {
                    String lowerCaseContentType = contentType.toLowerCase();
                    if ("text/javascript".equals(lowerCaseContentType) || "application/javascript".equals(lowerCaseContentType)) {
                        buf.append(jsLibraryFile.getJavascriptLibraryCode());
                        continue;
                    }
                    logger.info("Ignoring file {} for use as a Javascript library, content type {} not allowed. Use text/javascript or application/javascript.", new Object[]{jsLibraryFile.getName(), contentType});
                    continue;
                }
                logger.info("Ignoring file {} for use as a Javascript library, content type not set. Use text/javascript or application/javascript.", new Object[]{jsLibraryFile.getName(), contentType});
            }
            tx.success();
        }
        catch (FrameworkException fex) {
            logger.warn("", (Throwable)fex);
        }
        return buf.toString();
    }

    public void setPredicate(Predicate predicate) {
        this.predicate = predicate;
    }

    public Predicate getPredicate() {
        return this.predicate;
    }
}

