/*
 * Decompiled with CFR 0.152.
 */
package org.structr.schema.action;

import org.apache.commons.lang3.StringEscapeUtils;
import org.structr.schema.action.Actions;

public class ActionEntry
implements Comparable<ActionEntry> {
    private Actions.Type type = null;
    private String call = null;
    private String name = null;
    private int position = 0;

    public ActionEntry(String sourceName, String value) {
        int positionOffset = 0;
        if (sourceName.startsWith("___onSave")) {
            this.type = Actions.Type.Save;
            positionOffset = 9;
        } else if (sourceName.startsWith("___onCreate")) {
            this.type = Actions.Type.Create;
            positionOffset = 11;
        } else if (sourceName.startsWith("___onDelete")) {
            this.type = Actions.Type.Delete;
            positionOffset = 11;
        } else {
            this.type = Actions.Type.Custom;
            positionOffset = 3;
        }
        if (this.type.equals((Object)Actions.Type.Custom)) {
            this.name = sourceName.substring(positionOffset);
        } else {
            String positionString = sourceName.substring(positionOffset);
            if (!positionString.isEmpty()) {
                try {
                    this.position = Integer.parseInt(positionString);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        this.call = value.trim();
    }

    public String getSource(String objVariable) {
        return this.getSource(objVariable, false);
    }

    public String getSource(String objVariable, boolean includeParameters) {
        StringBuilder buf = new StringBuilder();
        buf.append(Actions.class.getSimpleName());
        buf.append(".execute(securityContext, ").append(objVariable).append(", \"${");
        buf.append(StringEscapeUtils.escapeJava((String)this.call));
        buf.append("}\"");
        if (includeParameters) {
            buf.append(", parameters");
        }
        buf.append(", \"");
        if (this.type.equals((Object)Actions.Type.Custom)) {
            buf.append(this.name);
        } else {
            buf.append(this.type.getLogName());
        }
        buf.append("\")");
        return buf.toString();
    }

    @Override
    public int compareTo(ActionEntry o) {
        return this.getPosition().compareTo(o.getPosition());
    }

    public Actions.Type getType() {
        return this.type;
    }

    public String getCall() {
        return this.call;
    }

    public Integer getPosition() {
        return this.position;
    }

    public String getName() {
        return this.name;
    }

    private String replaceQuotes(String source) {
        String result = source;
        result = result.replaceAll("\"", "\\\\\"");
        result = result.replaceAll("'", "\\\\'");
        result = result.replaceAll("\n", "\\\\n");
        return result;
    }
}

