/*
 * Decompiled with CFR 0.152.
 */
package org.structr.schema.export;

import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.App;
import org.structr.core.entity.AbstractSchemaNode;
import org.structr.core.entity.SchemaProperty;
import org.structr.schema.SchemaHelper;
import org.structr.schema.export.StructrReferenceProperty;
import org.structr.schema.json.JsonType;

class NotionReferenceProperty
extends StructrReferenceProperty {
    private String referenceName = null;
    private String reference = null;
    private String type = null;

    NotionReferenceProperty(JsonType parent, String name, String reference, String type, String referenceName) {
        super(parent, name);
        this.referenceName = referenceName;
        this.reference = reference;
        this.type = type;
    }

    @Override
    public URI getId() {
        return null;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    SchemaProperty createDatabaseSchema(App app, AbstractSchemaNode schemaNode) throws FrameworkException {
        SchemaProperty property = super.createDatabaseSchema(app, schemaNode);
        property.setProperty(SchemaProperty.format, this.referenceName + ", " + StringUtils.join((Iterable)this.properties, (String)", "));
        property.setProperty(SchemaProperty.propertyType, SchemaHelper.Type.Notion.name());
        return property;
    }

    @Override
    void deserialize(Map<String, Object> source) {
        Object itemsValue;
        String type;
        super.deserialize(source);
        Object propertiesValue = source.get("properties");
        if (propertiesValue != null && propertiesValue instanceof List) {
            this.properties.addAll((List)propertiesValue);
        }
        if ("object".equals(type = (String)source.get("type"))) {
            this.reference = (String)source.get("$ref");
        } else if ("array".equals(type) && (itemsValue = source.get("items")) != null && itemsValue instanceof Map) {
            Map items = (Map)itemsValue;
            this.reference = (String)items.get("$ref");
        }
    }

    @Override
    void deserialize(SchemaProperty schemaProperty) {
        super.deserialize(schemaProperty);
    }

    @Override
    Map<String, Object> serialize() {
        Map<String, Object> map = super.serialize();
        if ("object".equals(this.getType())) {
            map.put("$ref", this.reference);
        } else if ("array".equals(this.getType())) {
            TreeMap<String, String> items = new TreeMap<String, String>();
            map.put("items", items);
            items.put("$ref", this.reference);
        }
        map.put("properties", this.properties);
        return map;
    }
}

