/*
 * Decompiled with CFR 0.152.
 */
package org.structr.schema.export;

import java.util.Map;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.App;
import org.structr.core.entity.AbstractSchemaNode;
import org.structr.core.entity.SchemaProperty;
import org.structr.schema.SchemaHelper;
import org.structr.schema.export.StructrStringProperty;
import org.structr.schema.export.StructrTypeDefinition;
import org.structr.schema.json.JsonDateProperty;

public class StructrDateProperty
extends StructrStringProperty
implements JsonDateProperty {
    private String datePattern = null;

    public StructrDateProperty(StructrTypeDefinition parent, String name) {
        super(parent, name);
        this.setFormat("date-time");
    }

    @Override
    public JsonDateProperty setDatePattern(String datePattern) {
        this.datePattern = datePattern;
        return this;
    }

    @Override
    public String getDatePattern() {
        return this.datePattern;
    }

    @Override
    Map<String, Object> serialize() {
        Map<String, Object> map = super.serialize();
        if (this.datePattern != null) {
            map.put("datePattern", this.datePattern);
        }
        return map;
    }

    @Override
    void deserialize(Map<String, Object> source) {
        super.deserialize(source);
        if (source.containsKey("datePattern")) {
            this.datePattern = (String)source.get("datePattern");
        }
    }

    @Override
    void deserialize(SchemaProperty property) {
        super.deserialize(property);
        this.datePattern = property.getProperty(SchemaProperty.format);
    }

    @Override
    SchemaProperty createDatabaseSchema(App app, AbstractSchemaNode schemaNode) throws FrameworkException {
        SchemaProperty property = super.createDatabaseSchema(app, schemaNode);
        property.setProperty(SchemaProperty.propertyType, SchemaHelper.Type.Date.name());
        property.setProperty(SchemaProperty.format, this.datePattern);
        return property;
    }
}

