/*
 * Decompiled with CFR 0.152.
 */
package org.structr.schema.export;

import java.util.Map;
import java.util.TreeMap;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.App;
import org.structr.core.entity.AbstractSchemaNode;
import org.structr.core.entity.SchemaProperty;
import org.structr.schema.SchemaHelper;
import org.structr.schema.export.StructrPropertyDefinition;
import org.structr.schema.export.StructrTypeDefinition;
import org.structr.schema.json.JsonLongArrayProperty;
import org.structr.schema.parser.LongArrayPropertyParser;

public class StructrLongArrayProperty
extends StructrPropertyDefinition
implements JsonLongArrayProperty {
    private boolean exclusiveMinimum = false;
    private boolean exclusiveMaximum = false;
    private Long minimum = null;
    private Long maximum = null;

    public StructrLongArrayProperty(StructrTypeDefinition parent, String name) {
        super(parent, name);
    }

    @Override
    public boolean isExclusiveMinimum() {
        return this.exclusiveMinimum;
    }

    @Override
    public JsonLongArrayProperty setExclusiveMinimum(boolean exclusiveMinimum) {
        this.exclusiveMinimum = exclusiveMinimum;
        return this;
    }

    @Override
    public boolean isExclusiveMaximum() {
        return this.exclusiveMaximum;
    }

    @Override
    public JsonLongArrayProperty setExclusiveMaximum(boolean exclusiveMaximum) {
        this.exclusiveMaximum = exclusiveMaximum;
        return this;
    }

    @Override
    public Long getMinimum() {
        return this.minimum;
    }

    @Override
    public JsonLongArrayProperty setMinimum(long minimum) {
        return this.setMinimum(minimum, false);
    }

    @Override
    public JsonLongArrayProperty setMinimum(long minimum, boolean exclusive) {
        this.exclusiveMinimum = exclusive;
        this.minimum = minimum;
        return this;
    }

    @Override
    public Long getMaximum() {
        return this.maximum;
    }

    @Override
    public JsonLongArrayProperty setMaximum(long maximum) {
        return this.setMaximum(maximum, false);
    }

    @Override
    public JsonLongArrayProperty setMaximum(long maximum, boolean exclusive) {
        this.exclusiveMaximum = exclusive;
        this.maximum = maximum;
        return this;
    }

    @Override
    Map<String, Object> serialize() {
        Map<String, Object> map = super.serialize();
        TreeMap<String, Object> items = new TreeMap<String, Object>();
        map.put("items", items);
        items.put("type", "long");
        if (this.exclusiveMinimum) {
            items.put("exclusiveMinimum", true);
        }
        if (this.exclusiveMaximum) {
            items.put("exclusiveMaximum", true);
        }
        if (this.minimum != null) {
            items.put("minimum", this.minimum);
        }
        if (this.maximum != null) {
            items.put("maximum", this.maximum);
        }
        return map;
    }

    @Override
    void deserialize(Map<String, Object> source) {
        super.deserialize(source);
        Object _items = source.get("items");
        if (_items != null && _items instanceof Map) {
            Object _maximum;
            Object _minimum;
            Object _exclusiveMaximum;
            Map items = (Map)_items;
            Object _exclusiveMinimum = items.get("exclusiveMinimum");
            if (_exclusiveMinimum != null && Boolean.TRUE.equals(_exclusiveMinimum)) {
                this.exclusiveMinimum = true;
            }
            if ((_exclusiveMaximum = items.get("exclusiveMaximum")) != null && Boolean.TRUE.equals(_exclusiveMaximum)) {
                this.exclusiveMaximum = true;
            }
            if ((_minimum = items.get("minimum")) != null && _minimum instanceof Number) {
                this.minimum = ((Number)_minimum).longValue();
            }
            if ((_maximum = items.get("maximum")) != null && _maximum instanceof Number) {
                this.maximum = ((Number)_maximum).longValue();
            }
        }
    }

    @Override
    void deserialize(SchemaProperty property) {
        super.deserialize(property);
        LongArrayPropertyParser longPropertyParser = property.getLongArrayPropertyParser();
        if (longPropertyParser != null) {
            Number max;
            this.exclusiveMinimum = longPropertyParser.isLowerExclusive();
            this.exclusiveMaximum = longPropertyParser.isUpperExclusive();
            Number min = longPropertyParser.getLowerBound();
            if (min != null) {
                this.minimum = min.longValue();
            }
            if ((max = longPropertyParser.getUpperBound()) != null) {
                this.maximum = max.longValue();
            }
        }
    }

    @Override
    SchemaProperty createDatabaseSchema(App app, AbstractSchemaNode schemaNode) throws FrameworkException {
        SchemaProperty property = super.createDatabaseSchema(app, schemaNode);
        property.setProperty(SchemaProperty.propertyType, SchemaHelper.Type.LongArray.name());
        if (this.minimum != null && this.maximum != null) {
            StringBuilder range = new StringBuilder();
            if (this.exclusiveMinimum) {
                range.append("]");
            } else {
                range.append("[");
            }
            range.append(this.minimum);
            range.append(",");
            range.append(this.maximum);
            if (this.exclusiveMaximum) {
                range.append("[");
            } else {
                range.append("]");
            }
            property.setProperty(SchemaProperty.format, range.toString());
        }
        return property;
    }

    @Override
    public String getType() {
        return "array";
    }
}

