/*
 * Decompiled with CFR 0.152.
 */
package org.structr.schema.export;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.TreeMap;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.Relation;
import org.structr.core.entity.SchemaNode;
import org.structr.core.entity.SchemaRelationshipNode;
import org.structr.schema.export.StructrRelationshipTypeDefinition;
import org.structr.schema.export.StructrSchemaDefinition;
import org.structr.schema.export.StructrTypeDefinition;
import org.structr.schema.json.JsonObjectType;
import org.structr.schema.json.JsonReferenceType;

public class StructrNodeTypeDefinition
extends StructrTypeDefinition<SchemaNode>
implements JsonObjectType {
    StructrNodeTypeDefinition(StructrSchemaDefinition root, String name) {
        super(root, name);
    }

    @Override
    public JsonReferenceType relate(JsonObjectType type) throws URISyntaxException {
        return this.relate(type, SchemaRelationshipNode.getDefaultRelationshipType(this.getName(), type.getName()));
    }

    @Override
    public JsonReferenceType relate(URI externalTypeReference) throws URISyntaxException {
        Class type = StructrApp.resolveSchemaId(externalTypeReference);
        if (type != null) {
            return this.relate(externalTypeReference, SchemaRelationshipNode.getDefaultRelationshipType(this.getName(), type.getSimpleName()));
        }
        throw new IllegalStateException("External reference " + externalTypeReference + " not found.");
    }

    @Override
    public JsonReferenceType relate(JsonObjectType type, String relationship) throws URISyntaxException {
        return this.relate(type, relationship, Relation.Cardinality.ManyToMany);
    }

    @Override
    public JsonReferenceType relate(URI externalTypeReference, String relationship) throws URISyntaxException {
        return this.relate(externalTypeReference, relationship, Relation.Cardinality.ManyToMany);
    }

    @Override
    public JsonReferenceType relate(JsonObjectType type, String relationship, Relation.Cardinality cardinality) throws URISyntaxException {
        String sourcePropertyName = this.getPropertyName(type.getName(), false, relationship, cardinality);
        String targetPropertyName = this.getPropertyName(type.getName(), true, relationship, cardinality);
        return this.relate(type, relationship, cardinality, sourcePropertyName, targetPropertyName);
    }

    @Override
    public JsonReferenceType relate(URI externalTypeReference, String relationship, Relation.Cardinality cardinality) throws URISyntaxException {
        Class type = StructrApp.resolveSchemaId(externalTypeReference);
        if (type != null) {
            String sourcePropertyName = this.getPropertyName(type.getSimpleName(), false, relationship, cardinality);
            String targetPropertyName = this.getPropertyName(type.getSimpleName(), true, relationship, cardinality);
            return this.relate(externalTypeReference, relationship, cardinality, sourcePropertyName, targetPropertyName);
        }
        throw new IllegalStateException("External reference " + externalTypeReference + " not found.");
    }

    @Override
    public JsonReferenceType relate(JsonObjectType type, String relationship, Relation.Cardinality cardinality, String sourceAttributeName, String targetAttributeName) throws URISyntaxException {
        String relationshipTypeName = this.getName() + relationship + type.getName();
        StructrRelationshipTypeDefinition def = new StructrRelationshipTypeDefinition(this.root, relationshipTypeName);
        def.setSourcePropertyName(sourceAttributeName);
        def.setTargetPropertyName(targetAttributeName);
        def.setRelationship(relationship);
        def.setCardinality(cardinality);
        def.setSourceType(this.getId());
        def.setTargetType(type.getId());
        this.root.addType(def);
        return def;
    }

    @Override
    public JsonReferenceType relate(URI externalTypeReference, String relationship, Relation.Cardinality cardinality, String sourceAttributeName, String targetAttributeName) throws URISyntaxException {
        Class type = StructrApp.resolveSchemaId(externalTypeReference);
        if (type != null) {
            String relationshipTypeName = this.getName() + relationship + type.getSimpleName();
            StructrRelationshipTypeDefinition def = new StructrRelationshipTypeDefinition(this.root, relationshipTypeName);
            def.setSourcePropertyName(sourceAttributeName);
            def.setTargetPropertyName(targetAttributeName);
            def.setRelationship(relationship);
            def.setCardinality(cardinality);
            def.setSourceType(this.getId());
            def.setTargetType(externalTypeReference);
            this.root.addType(def);
            return def;
        }
        throw new IllegalStateException("External reference " + externalTypeReference + " not found.");
    }

    @Override
    Map<String, Object> serialize() {
        Map<String, Object> map = super.serialize();
        TreeMap<String, Map<String, Object>> serializedProperties = (TreeMap<String, Map<String, Object>>)map.get("properties");
        if (serializedProperties == null) {
            serializedProperties = new TreeMap<String, Map<String, Object>>();
            map.put("properties", serializedProperties);
        }
        for (StructrRelationshipTypeDefinition rel : this.root.getRelationships()) {
            Map<String, Object> property;
            if (this.getId().equals(rel.getSourceType()) && (property = rel.serializeRelationshipProperty(true)) != null) {
                serializedProperties.put(rel.getTargetPropertyName(), property);
            }
            if (!this.getId().equals(rel.getTargetType()) || (property = rel.serializeRelationshipProperty(false)) == null) continue;
            serializedProperties.put(rel.getSourcePropertyName(), property);
        }
        if (serializedProperties.isEmpty()) {
            map.remove("properties");
        }
        return map;
    }

    @Override
    void deserialize(Map<String, Object> source) {
        super.deserialize(source);
    }

    @Override
    SchemaNode createSchemaNode(App app) throws FrameworkException {
        SchemaNode existingNode = app.nodeQuery(SchemaNode.class).andName(this.getName()).getFirst();
        if (existingNode != null) {
            return existingNode;
        }
        return app.create(SchemaNode.class, this.getName());
    }

    private String getPropertyName(String targetTypeName, boolean outgoing, String relationshipTypeName, Relation.Cardinality cardinality) {
        String sourceTypeName = this.getName();
        String relatedClassName = outgoing ? targetTypeName : sourceTypeName;
        String _sourceMultiplicity = null;
        String _targetMultiplicity = null;
        switch (cardinality) {
            case OneToOne: {
                _sourceMultiplicity = "1";
                _targetMultiplicity = "1";
                break;
            }
            case OneToMany: {
                _sourceMultiplicity = "1";
                _targetMultiplicity = "*";
                break;
            }
            case ManyToOne: {
                _sourceMultiplicity = "*";
                _targetMultiplicity = "1";
                break;
            }
            case ManyToMany: {
                _sourceMultiplicity = "*";
                _targetMultiplicity = "*";
            }
        }
        return SchemaRelationshipNode.getPropertyName(relatedClassName, this.root.getExistingPropertyNames(), outgoing, relationshipTypeName, sourceTypeName, targetTypeName, null, _targetMultiplicity, null, _sourceMultiplicity);
    }
}

