/*
 * Decompiled with CFR 0.152.
 */
package org.structr.schema.export;

import java.util.Map;
import java.util.TreeMap;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.App;
import org.structr.core.entity.AbstractSchemaNode;
import org.structr.core.entity.SchemaProperty;
import org.structr.schema.SchemaHelper;
import org.structr.schema.export.StructrPropertyDefinition;
import org.structr.schema.export.StructrTypeDefinition;
import org.structr.schema.json.JsonNumberArrayProperty;
import org.structr.schema.parser.DoubleArrayPropertyParser;

public class StructrNumberArrayProperty
extends StructrPropertyDefinition
implements JsonNumberArrayProperty {
    private boolean exclusiveMinimum = false;
    private boolean exclusiveMaximum = false;
    private Double minimum = null;
    private Double maximum = null;

    public StructrNumberArrayProperty(StructrTypeDefinition parent, String name) {
        super(parent, name);
    }

    @Override
    public boolean isExclusiveMinimum() {
        return this.exclusiveMinimum;
    }

    @Override
    public JsonNumberArrayProperty setExclusiveMinimum(boolean exclusiveMinimum) {
        this.exclusiveMinimum = exclusiveMinimum;
        return this;
    }

    @Override
    public boolean isExclusiveMaximum() {
        return this.exclusiveMaximum;
    }

    @Override
    public JsonNumberArrayProperty setExclusiveMaximum(boolean exclusiveMaximum) {
        this.exclusiveMaximum = exclusiveMaximum;
        return this;
    }

    @Override
    public Double getMinimum() {
        return this.minimum;
    }

    @Override
    public JsonNumberArrayProperty setMinimum(double minimum) {
        return this.setMinimum(minimum, false);
    }

    @Override
    public JsonNumberArrayProperty setMinimum(double minimum, boolean exclusive) {
        this.exclusiveMinimum = exclusive;
        this.minimum = minimum;
        return this;
    }

    @Override
    public Double getMaximum() {
        return this.maximum;
    }

    @Override
    public JsonNumberArrayProperty setMaximum(double maximum) {
        return this.setMaximum(maximum, false);
    }

    @Override
    public JsonNumberArrayProperty setMaximum(double maximum, boolean exclusive) {
        this.exclusiveMaximum = exclusive;
        this.maximum = maximum;
        return this;
    }

    @Override
    Map<String, Object> serialize() {
        Map<String, Object> map = super.serialize();
        TreeMap<String, Object> items = new TreeMap<String, Object>();
        map.put("items", items);
        items.put("type", "number");
        if (this.exclusiveMinimum) {
            items.put("exclusiveMinimum", true);
        }
        if (this.exclusiveMaximum) {
            items.put("exclusiveMaximum", true);
        }
        if (this.minimum != null) {
            items.put("minimum", this.minimum);
        }
        if (this.maximum != null) {
            items.put("maximum", this.maximum);
        }
        return map;
    }

    @Override
    void deserialize(Map<String, Object> source) {
        super.deserialize(source);
        Object _items = source.get("items");
        if (_items != null && _items instanceof Map) {
            Object _maximum;
            Object _minimum;
            Object _exclusiveMaximum;
            Map items = (Map)_items;
            Object _exclusiveMinimum = items.get("exclusiveMinimum");
            if (_exclusiveMinimum != null && Boolean.TRUE.equals(_exclusiveMinimum)) {
                this.exclusiveMinimum = true;
            }
            if ((_exclusiveMaximum = items.get("exclusiveMaximum")) != null && Boolean.TRUE.equals(_exclusiveMaximum)) {
                this.exclusiveMaximum = true;
            }
            if ((_minimum = items.get("minimum")) != null && _minimum instanceof Number) {
                this.minimum = ((Number)_minimum).doubleValue();
            }
            if ((_maximum = items.get("maximum")) != null && _maximum instanceof Number) {
                this.maximum = ((Number)_maximum).doubleValue();
            }
        }
    }

    @Override
    void deserialize(SchemaProperty property) {
        super.deserialize(property);
        DoubleArrayPropertyParser doublePropertyParser = property.getDoubleArrayPropertyParser();
        if (doublePropertyParser != null) {
            Number max;
            this.exclusiveMinimum = doublePropertyParser.isLowerExclusive();
            this.exclusiveMaximum = doublePropertyParser.isUpperExclusive();
            Number min = doublePropertyParser.getLowerBound();
            if (min != null) {
                this.minimum = min.doubleValue();
            }
            if ((max = doublePropertyParser.getUpperBound()) != null) {
                this.maximum = max.doubleValue();
            }
        }
    }

    @Override
    SchemaProperty createDatabaseSchema(App app, AbstractSchemaNode schemaNode) throws FrameworkException {
        SchemaProperty property = super.createDatabaseSchema(app, schemaNode);
        property.setProperty(SchemaProperty.propertyType, SchemaHelper.Type.DoubleArray.name());
        if (this.minimum != null && this.maximum != null) {
            StringBuilder range = new StringBuilder();
            if (this.exclusiveMinimum) {
                range.append("]");
            } else {
                range.append("[");
            }
            range.append(this.minimum);
            range.append(",");
            range.append(this.maximum);
            if (this.exclusiveMaximum) {
                range.append("[");
            } else {
                range.append("]");
            }
            property.setProperty(SchemaProperty.format, range.toString());
        }
        return property;
    }

    @Override
    public String getType() {
        return "array";
    }
}

