/*
 * Decompiled with CFR 0.152.
 */
package org.structr.schema.export;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.App;
import org.structr.core.entity.AbstractSchemaNode;
import org.structr.core.entity.SchemaProperty;
import org.structr.core.graph.NodeAttribute;
import org.structr.schema.SchemaHelper;
import org.structr.schema.export.NotionReferenceProperty;
import org.structr.schema.export.StructrBooleanArrayProperty;
import org.structr.schema.export.StructrBooleanProperty;
import org.structr.schema.export.StructrCountProperty;
import org.structr.schema.export.StructrDateProperty;
import org.structr.schema.export.StructrDefinition;
import org.structr.schema.export.StructrEnumProperty;
import org.structr.schema.export.StructrFunctionProperty;
import org.structr.schema.export.StructrIntegerArrayProperty;
import org.structr.schema.export.StructrIntegerProperty;
import org.structr.schema.export.StructrLongArrayProperty;
import org.structr.schema.export.StructrLongProperty;
import org.structr.schema.export.StructrNumberArrayProperty;
import org.structr.schema.export.StructrNumberProperty;
import org.structr.schema.export.StructrScriptProperty;
import org.structr.schema.export.StructrStringArrayProperty;
import org.structr.schema.export.StructrStringProperty;
import org.structr.schema.export.StructrThumbnailProperty;
import org.structr.schema.export.StructrTypeDefinition;
import org.structr.schema.json.JsonProperty;
import org.structr.schema.json.JsonType;

public abstract class StructrPropertyDefinition
implements JsonProperty,
StructrDefinition {
    private static final Logger logger = LoggerFactory.getLogger((String)StructrPropertyDefinition.class.getName());
    protected JsonType parent = null;
    protected String format = null;
    protected String name = null;
    protected String defaultValue = null;
    protected boolean required = false;
    protected boolean compound = false;
    protected boolean unique = false;
    protected boolean indexed = false;

    StructrPropertyDefinition(JsonType parent, String name) {
        this.parent = parent;
        this.name = name;
    }

    @Override
    public URI getId() {
        URI parentId = this.parent.getId();
        if (parentId != null) {
            try {
                URI containerURI = new URI(parentId.toString() + "/");
                return containerURI.resolve("properties/" + this.getName());
            }
            catch (URISyntaxException urex) {
                logger.warn("", (Throwable)urex);
            }
        }
        return null;
    }

    @Override
    public JsonType getParent() {
        return this.parent;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getFormat() {
        return this.format;
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    @Override
    public boolean isCompoundUnique() {
        return this.compound;
    }

    @Override
    public boolean isUnique() {
        return this.unique;
    }

    @Override
    public boolean isIndexed() {
        return this.indexed;
    }

    @Override
    public JsonProperty setFormat(String format) {
        this.format = format;
        return this;
    }

    @Override
    public JsonProperty setName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public JsonProperty setRequired(boolean required) {
        this.required = required;
        return this;
    }

    @Override
    public JsonProperty setCompound(boolean compound) {
        this.compound = compound;
        return this;
    }

    @Override
    public JsonProperty setUnique(boolean unique) {
        this.unique = unique;
        return this;
    }

    @Override
    public JsonProperty setIndexed(boolean indexed) {
        this.indexed = indexed;
        return this;
    }

    @Override
    public JsonProperty setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    @Override
    public int compareTo(JsonProperty o) {
        return this.getName().compareTo(o.getName());
    }

    @Override
    public StructrDefinition resolveJsonPointerKey(String key) {
        return null;
    }

    SchemaProperty createDatabaseSchema(App app, AbstractSchemaNode schemaNode) throws FrameworkException {
        return app.create(SchemaProperty.class, new NodeAttribute<String>(SchemaProperty.name, this.getName()), new NodeAttribute<AbstractSchemaNode>(SchemaProperty.schemaNode, schemaNode), new NodeAttribute<Boolean>(SchemaProperty.compound, this.isCompoundUnique()), new NodeAttribute<Boolean>(SchemaProperty.unique, this.isUnique()), new NodeAttribute<Boolean>(SchemaProperty.indexed, this.isIndexed()), new NodeAttribute<Boolean>(SchemaProperty.notNull, this.isRequired()), new NodeAttribute<String>(SchemaProperty.defaultValue, this.defaultValue));
    }

    void deserialize(Map<String, Object> source) {
        Object _defaultValue;
        if (source.containsKey("compound")) {
            this.compound = (Boolean)source.get("compound");
        }
        if (source.containsKey("unique")) {
            this.unique = (Boolean)source.get("unique");
        }
        if (source.containsKey("indexed")) {
            this.indexed = (Boolean)source.get("indexed");
        }
        if ((_defaultValue = source.get("default")) != null) {
            this.defaultValue = _defaultValue.toString();
        }
    }

    void deserialize(SchemaProperty property) {
        this.setDefaultValue(property.getDefaultValue());
        this.setCompound(property.isCompound());
        this.setRequired(property.isRequired());
        this.setUnique(property.isUnique());
        this.setIndexed(property.isIndexed());
    }

    Map<String, Object> serialize() {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        map.put("type", this.getType());
        if (this.compound) {
            map.put("compound", true);
        }
        if (this.unique) {
            map.put("unique", true);
        }
        if (this.indexed) {
            map.put("indexed", true);
        }
        if (this.format != null) {
            map.put("format", this.format);
        }
        if (this.defaultValue != null) {
            map.put("default", this.defaultValue);
        }
        return map;
    }

    void initializeReferences() {
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static StructrPropertyDefinition deserialize(StructrTypeDefinition parent, String name, Map<String, Object> source) {
        void var4_25;
        String propertyType = (String)source.get("type");
        Object var4_4 = null;
        if (propertyType == null) throw new IllegalStateException("Property " + name + " has no type.");
        boolean isDate = source.containsKey("format") && "date-time".equals(source.get("format"));
        boolean isEnum = source.containsKey("enum");
        block13 : switch (propertyType) {
            case "string": {
                if (isDate) {
                    StructrDateProperty structrDateProperty = new StructrDateProperty(parent, name);
                    break;
                }
                if (isEnum) {
                    StructrEnumProperty structrEnumProperty = new StructrEnumProperty(parent, name);
                    break;
                }
                StructrStringProperty structrStringProperty = new StructrStringProperty(parent, name);
                break;
            }
            case "thumbnail": {
                StructrThumbnailProperty structrThumbnailProperty = new StructrThumbnailProperty(parent, name);
                break;
            }
            case "count": {
                StructrCountProperty structrCountProperty = new StructrCountProperty(parent, name);
                break;
            }
            case "script": {
                StructrScriptProperty structrScriptProperty = new StructrScriptProperty(parent, name);
                break;
            }
            case "function": {
                StructrFunctionProperty structrFunctionProperty = new StructrFunctionProperty(parent, name);
                break;
            }
            case "boolean": {
                StructrBooleanProperty structrBooleanProperty = new StructrBooleanProperty(parent, name);
                break;
            }
            case "number": {
                StructrNumberProperty structrNumberProperty = new StructrNumberProperty(parent, name);
                break;
            }
            case "integer": {
                StructrIntegerProperty structrIntegerProperty = new StructrIntegerProperty(parent, name);
                break;
            }
            case "long": {
                StructrLongProperty structrLongProperty = new StructrLongProperty(parent, name);
                break;
            }
            case "object": {
                if (!source.containsKey("$ref") || source.containsKey("$link")) break;
                Object reference = source.get("$ref");
                if (reference != null && reference instanceof String) {
                    String refName = StructrPropertyDefinition.getPropertyNameFromJsonPointer(reference.toString());
                    NotionReferenceProperty notionReferenceProperty = new NotionReferenceProperty(parent, name, (String)source.get("$ref"), "object", refName);
                }
                break;
            }
            case "array": {
                Object typeValue;
                Map items;
                if (source.containsKey("$link") || (items = (Map)source.get("items")) == null) break;
                if (items.containsKey("$ref")) {
                    Object reference = items.get("$ref");
                    if (reference != null && reference instanceof String) {
                        String refName = StructrPropertyDefinition.getPropertyNameFromJsonPointer(reference.toString());
                        NotionReferenceProperty notionReferenceProperty = new NotionReferenceProperty(parent, name, (String)source.get("$ref"), "array", refName);
                    }
                    break;
                }
                if (!items.containsKey("type") || (typeValue = items.get("type")) == null) break;
                switch (typeValue.toString()) {
                    case "string": {
                        StructrStringArrayProperty structrStringArrayProperty = new StructrStringArrayProperty(parent, name);
                        break block13;
                    }
                    case "integer": {
                        StructrIntegerArrayProperty structrIntegerArrayProperty = new StructrIntegerArrayProperty(parent, name);
                        break block13;
                    }
                    case "long": {
                        StructrLongArrayProperty structrLongArrayProperty = new StructrLongArrayProperty(parent, name);
                        break block13;
                    }
                    case "number": {
                        StructrNumberArrayProperty structrNumberArrayProperty = new StructrNumberArrayProperty(parent, name);
                        break block13;
                    }
                    case "boolean": {
                        StructrBooleanArrayProperty structrBooleanArrayProperty = new StructrBooleanArrayProperty(parent, name);
                    }
                }
            }
        }
        if (var4_25 == null) return var4_25;
        var4_25.deserialize(source);
        return var4_25;
    }

    static StructrPropertyDefinition deserialize(StructrTypeDefinition parent, SchemaProperty property) {
        String parentName = parent.getName();
        SchemaHelper.Type type = property.getPropertyType();
        String name = property.getName();
        switch (type) {
            case Function: {
                StructrFunctionProperty func = new StructrFunctionProperty(parent, name);
                func.deserialize(property);
                return func;
            }
            case Cypher: {
                StructrScriptProperty cypher = new StructrScriptProperty(parent, name);
                cypher.deserialize(property);
                cypher.setContentType("application/x-cypher");
                return cypher;
            }
            case Notion: {
                NotionReferenceProperty notionProperty;
                String referenceName = property.getNotionBaseProperty();
                String reference = "#/definitions/" + parentName + "/properties/" + referenceName;
                Set<String> notionProperties = property.getPropertiesForNotionProperty();
                if (property.getNotionMultiplicity().startsWith("*")) {
                    notionProperty = new NotionReferenceProperty(parent, name, reference, "array", referenceName);
                    notionProperty.setProperties(notionProperties.toArray(new String[0]));
                } else {
                    notionProperty = new NotionReferenceProperty(parent, name, reference, "object", referenceName);
                    notionProperty.setProperties(notionProperties.toArray(new String[0]));
                }
                notionProperty.deserialize(property);
                return notionProperty;
            }
            case String: {
                StructrStringProperty str = new StructrStringProperty(parent, name);
                str.deserialize(property);
                str.setDefaultValue(property.getDefaultValue());
                return str;
            }
            case StringArray: {
                StructrStringArrayProperty arr = new StructrStringArrayProperty(parent, name);
                arr.deserialize(property);
                arr.setDefaultValue(property.getDefaultValue());
                return arr;
            }
            case Boolean: {
                StructrBooleanProperty bool = new StructrBooleanProperty(parent, name);
                bool.deserialize(property);
                return bool;
            }
            case BooleanArray: {
                StructrBooleanArrayProperty booleanArrayProperty = new StructrBooleanArrayProperty(parent, name);
                booleanArrayProperty.deserialize(property);
                booleanArrayProperty.setDefaultValue(property.getDefaultValue());
                return booleanArrayProperty;
            }
            case Count: {
                StructrCountProperty count = new StructrCountProperty(parent, name);
                count.deserialize(property);
                return count;
            }
            case Integer: {
                StructrIntegerProperty intProperty = new StructrIntegerProperty(parent, name);
                intProperty.deserialize(property);
                intProperty.setDefaultValue(property.getDefaultValue());
                return intProperty;
            }
            case IntegerArray: {
                StructrIntegerArrayProperty intArrayProperty = new StructrIntegerArrayProperty(parent, name);
                intArrayProperty.deserialize(property);
                intArrayProperty.setDefaultValue(property.getDefaultValue());
                return intArrayProperty;
            }
            case Long: {
                StructrLongProperty longProperty = new StructrLongProperty(parent, name);
                longProperty.deserialize(property);
                longProperty.setDefaultValue(property.getDefaultValue());
                return longProperty;
            }
            case LongArray: {
                StructrLongArrayProperty longArrayProperty = new StructrLongArrayProperty(parent, name);
                longArrayProperty.deserialize(property);
                longArrayProperty.setDefaultValue(property.getDefaultValue());
                return longArrayProperty;
            }
            case Double: {
                StructrNumberProperty doubleProperty = new StructrNumberProperty(parent, name);
                doubleProperty.deserialize(property);
                doubleProperty.setDefaultValue(property.getDefaultValue());
                return doubleProperty;
            }
            case DoubleArray: {
                StructrNumberArrayProperty doubleArrayProperty = new StructrNumberArrayProperty(parent, name);
                doubleArrayProperty.deserialize(property);
                doubleArrayProperty.setDefaultValue(property.getDefaultValue());
                return doubleArrayProperty;
            }
            case Date: {
                StructrDateProperty date = new StructrDateProperty(parent, name);
                date.deserialize(property);
                date.setFormat("date-time");
                date.setDefaultValue(property.getDefaultValue());
                return date;
            }
            case Enum: {
                StructrEnumProperty enumProperty = new StructrEnumProperty(parent, name);
                enumProperty.deserialize(property);
                enumProperty.setDefaultValue(property.getDefaultValue());
                return enumProperty;
            }
            case Thumbnail: {
                StructrThumbnailProperty thumb = new StructrThumbnailProperty(parent, name);
                thumb.deserialize(property);
                thumb.setDefaultValue(property.getDefaultValue());
                return thumb;
            }
        }
        throw new IllegalStateException("Unknown type " + (Object)((Object)type));
    }

    private static String getPropertyNameFromJsonPointer(String pointer) {
        return pointer.substring(pointer.lastIndexOf("/") + 1);
    }
}

