/*
 * Decompiled with CFR 0.152.
 */
package org.structr.schema.export;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.structr.common.error.FrameworkException;
import org.structr.core.Services;
import org.structr.core.app.App;
import org.structr.core.entity.SchemaNode;
import org.structr.core.entity.SchemaProperty;
import org.structr.core.entity.SchemaRelationshipNode;
import org.structr.core.entity.SchemaView;
import org.structr.core.graph.Tx;
import org.structr.schema.export.StructrSchemaDefinition;
import org.structr.schema.json.InvalidSchemaException;
import org.structr.schema.json.JsonSchema;

public class StructrSchema {
    public static JsonSchema createFromDatabase(App app) throws FrameworkException, URISyntaxException {
        return StructrSchema.createFromDatabase(app, null);
    }

    public static JsonSchema createFromDatabase(App app, List<String> types) throws FrameworkException, URISyntaxException {
        try (Tx tx = app.tx();){
            JsonSchema schema = StructrSchemaDefinition.initializeFromDatabase(app, types);
            tx.success();
            JsonSchema jsonSchema = schema;
            return jsonSchema;
        }
    }

    public static JsonSchema createFromSource(String source) throws InvalidSchemaException, URISyntaxException {
        return StructrSchema.createFromSource(new StringReader(source));
    }

    public static JsonSchema createFromSource(Reader reader) throws InvalidSchemaException, URISyntaxException {
        Gson gson = new GsonBuilder().create();
        Map rawData = (Map)gson.fromJson(reader, Map.class);
        return StructrSchemaDefinition.initializeFromSource(rawData);
    }

    public static JsonSchema createEmptySchema() throws InvalidSchemaException, URISyntaxException {
        return StructrSchema.createFromSource("{\"definitions\":{}}");
    }

    public static JsonSchema newInstance(URI id) {
        return new StructrSchemaDefinition(id);
    }

    public static void replaceDatabaseSchema(App app, JsonSchema newSchema) throws FrameworkException, URISyntaxException {
        Services.getInstance().setOverridingSchemaTypesAllowed(true);
        try (Tx tx = app.tx();){
            for (SchemaRelationshipNode schemaRelationship : app.nodeQuery(SchemaRelationshipNode.class).getAsList()) {
                app.delete(schemaRelationship);
            }
            for (SchemaNode schemaNode : app.nodeQuery(SchemaNode.class).getAsList()) {
                app.delete(schemaNode);
            }
            for (SchemaProperty schemaProperty : app.nodeQuery(SchemaProperty.class).getAsList()) {
                app.delete(schemaProperty);
            }
            for (SchemaView schemaView : app.nodeQuery(SchemaView.class).getAsList()) {
                app.delete(schemaView);
            }
            newSchema.createDatabaseSchema(app);
            tx.success();
        }
    }

    public static void extendDatabaseSchema(App app, JsonSchema newSchema) throws FrameworkException, URISyntaxException {
        try (Tx tx = app.tx();){
            newSchema.createDatabaseSchema(app);
            tx.success();
        }
    }
}

