/*
 * Decompiled with CFR 0.152.
 */
package org.structr.schema.export;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.App;
import org.structr.schema.export.StructrDefinition;
import org.structr.schema.export.StructrRelationshipTypeDefinition;
import org.structr.schema.export.StructrTypeDefinition;
import org.structr.schema.export.StructrTypeDefinitions;
import org.structr.schema.json.JsonObjectType;
import org.structr.schema.json.JsonSchema;
import org.structr.schema.json.JsonType;

public class StructrSchemaDefinition
implements JsonSchema,
StructrDefinition {
    private static final Logger logger = LoggerFactory.getLogger((String)StructrSchemaDefinition.class.getName());
    protected final Set<String> existingPropertyNames = new TreeSet<String>();
    private StructrTypeDefinitions typeDefinitions = new StructrTypeDefinitions(this);
    private String description = null;
    private String title = null;
    private URI id = null;

    StructrSchemaDefinition(URI id) {
        this.id = id;
    }

    @Override
    public URI getId() {
        return this.id;
    }

    public Set<StructrTypeDefinition> getTypes() {
        return this.typeDefinitions.getTypes();
    }

    @Override
    public JsonType getType(String name) {
        return this.typeDefinitions.getType(name);
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public JsonObjectType addType(String name) throws URISyntaxException {
        return this.typeDefinitions.addType(name);
    }

    @Override
    public void removeType(String name) throws URISyntaxException {
        this.typeDefinitions.removeType(name);
    }

    public String toString() {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        Map<String, Object> serializedForm = this.serialize();
        return gson.toJson(serializedForm);
    }

    @Override
    public void createDatabaseSchema(App app) throws FrameworkException {
        this.typeDefinitions.createDatabaseSchema(app);
    }

    @Override
    public StructrDefinition resolveJsonPointerKey(String key) {
        if ("definitions".equals(key)) {
            return this.typeDefinitions;
        }
        return null;
    }

    @Override
    public Object resolveURI(URI uri) {
        URI rel;
        URI id = this.getId();
        if (id != null && !(rel = id.relativize(uri)).isAbsolute()) {
            String relString = "#/" + rel.toString();
            return this.resolveJsonPointer(relString);
        }
        return null;
    }

    @Override
    public String toJsonPointer(URI uri) {
        URI pointer = this.id.relativize(uri);
        if (!pointer.isAbsolute()) {
            String jsonPointer = pointer.toString();
            if (jsonPointer.startsWith("#/")) {
                return jsonPointer;
            }
            if (jsonPointer.startsWith("/")) {
                return "#" + jsonPointer;
            }
            return "#/" + jsonPointer;
        }
        return pointer.toString();
    }

    Map<String, Object> serialize() {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        map.put("definitions", this.typeDefinitions.serialize());
        map.put("id", this.getId());
        return map;
    }

    void deserialize(Map<String, Object> source) {
        Map definitions = (Map)source.get("definitions");
        if (definitions == null) {
            throw new IllegalStateException("Invalid JSON object for schema definitions, missing value for 'definitions'.");
        }
        this.typeDefinitions.deserialize(definitions);
        Object idValue = source.get("id");
        if (idValue != null) {
            this.id = URI.create(idValue.toString());
        }
    }

    void deserialize(App app) throws FrameworkException {
        this.typeDefinitions.deserialize(app);
    }

    StructrDefinition resolveJsonPointer(String reference) {
        if (reference.startsWith("#")) {
            String[] parts = reference.substring(1).split("[/]+");
            StructrDefinition current = this;
            for (int i = 0; i < parts.length; ++i) {
                String key = parts[i].trim();
                if (!StringUtils.isNotBlank((CharSequence)key)) continue;
                if (StringUtils.isNumeric((CharSequence)key)) {
                    int index = Integer.valueOf(key);
                    if (current instanceof List) {
                        current = ((List)((Object)current)).get(index);
                        continue;
                    }
                    throw new IllegalStateException("Invalid JSON pointer " + reference + ", expected array at position " + i + ".");
                }
                if ("#".equals(key)) {
                    current = this;
                    continue;
                }
                if (current instanceof StructrDefinition) {
                    current = ((StructrDefinition)current).resolveJsonPointerKey(key);
                    continue;
                }
                if (!(current instanceof Map)) continue;
                current = ((Map)((Object)current)).get(key);
            }
            if (current instanceof StructrDefinition) {
                return current;
            }
        }
        return null;
    }

    void addType(StructrTypeDefinition type) {
        this.typeDefinitions.addType(type);
    }

    void addType(StructrRelationshipTypeDefinition type) {
        this.typeDefinitions.getRelationships().add(type);
        this.typeDefinitions.addType(type);
    }

    Set<StructrRelationshipTypeDefinition> getRelationships() {
        return this.typeDefinitions.getRelationships();
    }

    Set<String> getExistingPropertyNames() {
        return this.existingPropertyNames;
    }

    static JsonSchema initializeFromSource(Map<String, Object> source) {
        Object idValue = source.get("id");
        URI id = null;
        if (idValue != null) {
            try {
                id = new URI(idValue.toString());
            }
            catch (URISyntaxException ex) {
                logger.warn("", (Throwable)ex);
            }
        }
        StructrSchemaDefinition schema = new StructrSchemaDefinition(id);
        schema.deserialize(source);
        return schema;
    }

    static JsonSchema initializeFromDatabase(App app) throws FrameworkException {
        return StructrSchemaDefinition.initializeFromDatabase(app, null);
    }

    static JsonSchema initializeFromDatabase(App app, List<String> types) throws FrameworkException {
        URI id = null;
        try {
            id = new URI("https://structr.org/schema/" + app.getInstanceId() + "/#");
        }
        catch (URISyntaxException ex) {
            logger.warn("", (Throwable)ex);
        }
        StructrSchemaDefinition sourceSchema = new StructrSchemaDefinition(id);
        sourceSchema.deserialize(app);
        StructrSchemaDefinition schema = new StructrSchemaDefinition(id);
        schema.deserialize(app);
        if (types != null && !types.isEmpty()) {
            for (StructrTypeDefinition t : sourceSchema.getTypes()) {
                String name = t.getName();
                if (types.contains(name)) continue;
                try {
                    schema.removeType(name);
                }
                catch (URISyntaxException ex) {
                    throw new FrameworkException(422, ex.getMessage());
                }
            }
        }
        return schema;
    }
}

