/*
 * Decompiled with CFR 0.152.
 */
package org.structr.schema.export;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.entity.AbstractSchemaNode;
import org.structr.core.entity.SchemaMethod;
import org.structr.core.entity.SchemaNode;
import org.structr.core.entity.SchemaProperty;
import org.structr.core.entity.SchemaRelationshipNode;
import org.structr.core.entity.SchemaView;
import org.structr.core.graph.NodeAttribute;
import org.structr.core.property.PropertyKey;
import org.structr.schema.export.NotionReferenceProperty;
import org.structr.schema.export.StructrBooleanArrayProperty;
import org.structr.schema.export.StructrBooleanProperty;
import org.structr.schema.export.StructrDateProperty;
import org.structr.schema.export.StructrDefinition;
import org.structr.schema.export.StructrEnumProperty;
import org.structr.schema.export.StructrFunctionProperty;
import org.structr.schema.export.StructrIntegerArrayProperty;
import org.structr.schema.export.StructrIntegerProperty;
import org.structr.schema.export.StructrLongArrayProperty;
import org.structr.schema.export.StructrLongProperty;
import org.structr.schema.export.StructrNodeTypeDefinition;
import org.structr.schema.export.StructrNumberArrayProperty;
import org.structr.schema.export.StructrNumberProperty;
import org.structr.schema.export.StructrPropertyDefinition;
import org.structr.schema.export.StructrRelationshipTypeDefinition;
import org.structr.schema.export.StructrSchemaDefinition;
import org.structr.schema.export.StructrScriptProperty;
import org.structr.schema.export.StructrStringArrayProperty;
import org.structr.schema.export.StructrStringProperty;
import org.structr.schema.json.JsonBooleanArrayProperty;
import org.structr.schema.json.JsonBooleanProperty;
import org.structr.schema.json.JsonDateProperty;
import org.structr.schema.json.JsonEnumProperty;
import org.structr.schema.json.JsonFunctionProperty;
import org.structr.schema.json.JsonIntegerArrayProperty;
import org.structr.schema.json.JsonIntegerProperty;
import org.structr.schema.json.JsonLongArrayProperty;
import org.structr.schema.json.JsonLongProperty;
import org.structr.schema.json.JsonNumberArrayProperty;
import org.structr.schema.json.JsonNumberProperty;
import org.structr.schema.json.JsonProperty;
import org.structr.schema.json.JsonReferenceProperty;
import org.structr.schema.json.JsonSchema;
import org.structr.schema.json.JsonScriptProperty;
import org.structr.schema.json.JsonStringArrayProperty;
import org.structr.schema.json.JsonStringProperty;
import org.structr.schema.json.JsonType;

public abstract class StructrTypeDefinition<T extends AbstractSchemaNode>
implements JsonType,
StructrDefinition {
    protected final Set<StructrPropertyDefinition> properties = new TreeSet<StructrPropertyDefinition>();
    protected final Map<String, Set<String>> views = new TreeMap<String, Set<String>>();
    protected final TreeMap<String, Map<String, String>> methods = new TreeMap();
    protected StructrSchemaDefinition root = null;
    protected URI baseTypeReference = null;
    protected String name = null;
    protected T schemaNode = null;

    StructrTypeDefinition(StructrSchemaDefinition root, String name) {
        this.root = root;
        this.name = name;
    }

    abstract T createSchemaNode(App var1) throws FrameworkException;

    @Override
    public URI getId() {
        URI id = this.root.getId();
        URI uri = URI.create("definitions/" + this.getName());
        return id.resolve(uri);
    }

    @Override
    public JsonSchema getSchema() {
        return this.root;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public JsonType setName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public JsonType addMethod(String name, String source, String comment) {
        TreeMap<String, String> methodDefinition = new TreeMap<String, String>();
        methodDefinition.put(SchemaMethod.source.jsonName(), source);
        methodDefinition.put(SchemaMethod.comment.jsonName(), comment);
        this.methods.put(name, methodDefinition);
        return this;
    }

    @Override
    public JsonType setExtends(JsonType superType) {
        this.baseTypeReference = superType.getId();
        return this;
    }

    @Override
    public JsonType setExtends(URI externalReference) {
        this.baseTypeReference = externalReference;
        return this;
    }

    @Override
    public URI getExtends() {
        return this.baseTypeReference;
    }

    @Override
    public Set<JsonProperty> getProperties() {
        return this.properties;
    }

    @Override
    public Map<String, Map<String, String>> getMethods() {
        return this.methods;
    }

    @Override
    public Set<String> getViewNames() {
        return this.views.keySet();
    }

    @Override
    public Set<String> getViewPropertyNames(String viewName) {
        return this.views.get(viewName);
    }

    @Override
    public JsonType addViewProperty(String viewName, String propertyName) {
        this.addPropertyNameToViews(propertyName, viewName);
        return this;
    }

    @Override
    public Set<String> getRequiredProperties() {
        TreeSet<String> requiredProperties = new TreeSet<String>();
        for (StructrPropertyDefinition property : this.properties) {
            if (!property.isRequired()) continue;
            requiredProperties.add(property.getName());
        }
        return requiredProperties;
    }

    @Override
    public JsonStringProperty addStringProperty(String name, String ... views) throws URISyntaxException {
        StructrStringProperty stringProperty = new StructrStringProperty(this, name);
        this.addPropertyNameToViews(name, views);
        this.properties.add(stringProperty);
        return stringProperty;
    }

    @Override
    public JsonStringArrayProperty addStringArrayProperty(String name, String ... views) throws URISyntaxException {
        StructrStringArrayProperty stringProperty = new StructrStringArrayProperty(this, name);
        this.addPropertyNameToViews(name, views);
        this.properties.add(stringProperty);
        return stringProperty;
    }

    @Override
    public JsonDateProperty addDateProperty(String name, String ... views) throws URISyntaxException {
        StructrDateProperty dateProperty = new StructrDateProperty(this, name);
        this.addPropertyNameToViews(name, views);
        this.properties.add(dateProperty);
        return dateProperty;
    }

    @Override
    public JsonIntegerProperty addIntegerProperty(String name, String ... views) throws URISyntaxException {
        StructrIntegerProperty numberProperty = new StructrIntegerProperty(this, name);
        this.addPropertyNameToViews(name, views);
        this.properties.add(numberProperty);
        return numberProperty;
    }

    @Override
    public JsonIntegerArrayProperty addIntegerArrayProperty(String name, String ... views) throws URISyntaxException {
        StructrIntegerArrayProperty numberProperty = new StructrIntegerArrayProperty(this, name);
        this.addPropertyNameToViews(name, views);
        this.properties.add(numberProperty);
        return numberProperty;
    }

    @Override
    public JsonLongProperty addLongProperty(String name, String ... views) throws URISyntaxException {
        StructrLongProperty numberProperty = new StructrLongProperty(this, name);
        this.addPropertyNameToViews(name, views);
        this.properties.add(numberProperty);
        return numberProperty;
    }

    @Override
    public JsonLongArrayProperty addLongArrayProperty(String name, String ... views) throws URISyntaxException {
        StructrLongArrayProperty numberProperty = new StructrLongArrayProperty(this, name);
        this.addPropertyNameToViews(name, views);
        this.properties.add(numberProperty);
        return numberProperty;
    }

    @Override
    public JsonNumberProperty addNumberProperty(String name, String ... views) throws URISyntaxException {
        StructrNumberProperty numberProperty = new StructrNumberProperty(this, name);
        this.addPropertyNameToViews(name, views);
        this.properties.add(numberProperty);
        return numberProperty;
    }

    @Override
    public JsonNumberArrayProperty addDoubleArrayProperty(String name, String ... views) throws URISyntaxException {
        StructrNumberArrayProperty numberArrayProperty = new StructrNumberArrayProperty(this, name);
        this.addPropertyNameToViews(name, views);
        this.properties.add(numberArrayProperty);
        return numberArrayProperty;
    }

    @Override
    public JsonBooleanProperty addBooleanProperty(String name, String ... views) throws URISyntaxException {
        StructrBooleanProperty booleanProperty = new StructrBooleanProperty(this, name);
        this.addPropertyNameToViews(name, views);
        this.properties.add(booleanProperty);
        return booleanProperty;
    }

    @Override
    public JsonBooleanArrayProperty addBooleanArrayProperty(String name, String ... views) throws URISyntaxException {
        StructrBooleanArrayProperty booleanArrayProperty = new StructrBooleanArrayProperty(this, name);
        this.addPropertyNameToViews(name, views);
        this.properties.add(booleanArrayProperty);
        return booleanArrayProperty;
    }

    @Override
    public JsonScriptProperty addScriptProperty(String name, String ... views) throws URISyntaxException {
        StructrScriptProperty scriptProperty = new StructrScriptProperty(this, name);
        this.addPropertyNameToViews(name, views);
        this.properties.add(scriptProperty);
        return scriptProperty;
    }

    @Override
    public JsonFunctionProperty addFunctionProperty(String name, String ... views) throws URISyntaxException {
        StructrFunctionProperty functionProperty = new StructrFunctionProperty(this, name);
        this.addPropertyNameToViews(name, views);
        this.properties.add(functionProperty);
        return functionProperty;
    }

    @Override
    public JsonEnumProperty addEnumProperty(String name, String ... views) throws URISyntaxException {
        StructrEnumProperty enumProperty = new StructrEnumProperty(this, name);
        this.addPropertyNameToViews(name, views);
        this.properties.add(enumProperty);
        return enumProperty;
    }

    @Override
    public JsonReferenceProperty addReferenceProperty(String name, JsonReferenceProperty referencedProperty, String ... views) {
        String reference = this.root.toJsonPointer(referencedProperty.getId());
        String refType = referencedProperty.getType();
        String refName = referencedProperty.getName();
        NotionReferenceProperty ref = new NotionReferenceProperty(this, name, reference, refType, refName);
        this.addPropertyNameToViews(name, views);
        this.properties.add(ref);
        return ref;
    }

    @Override
    public int compareTo(JsonType o) {
        return this.getName().compareTo(o.getName());
    }

    @Override
    public StructrDefinition resolveJsonPointerKey(String key) {
        switch (key) {
            case "properties": {
                return new StructrDefinition(){

                    @Override
                    public StructrDefinition resolveJsonPointerKey(String key) {
                        for (StructrPropertyDefinition property : StructrTypeDefinition.this.properties) {
                            if (!key.equals(property.getName())) continue;
                            return property;
                        }
                        return null;
                    }
                };
            }
            case "views": {
                return new StructrDefinition(){

                    @Override
                    public StructrDefinition resolveJsonPointerKey(String key) {
                        return null;
                    }
                };
            }
        }
        return null;
    }

    Map<String, Object> serialize() {
        URI ext;
        Set<String> requiredProperties;
        TreeMap<String, Object> serializedForm = new TreeMap<String, Object>();
        TreeMap<String, Map<String, Object>> serializedProperties = new TreeMap<String, Map<String, Object>>();
        for (StructrPropertyDefinition property : this.properties) {
            serializedProperties.put(property.getName(), property.serialize());
        }
        serializedForm.put("type", "object");
        if (!serializedProperties.isEmpty()) {
            serializedForm.put("properties", serializedProperties);
        }
        if (!(requiredProperties = this.getRequiredProperties()).isEmpty()) {
            serializedForm.put("required", requiredProperties);
        }
        if (!this.views.isEmpty()) {
            serializedForm.put("views", this.views);
        }
        if (!this.methods.isEmpty()) {
            serializedForm.put("methods", this.methods);
        }
        if ((ext = this.getExtends()) != null) {
            serializedForm.put("$extends", this.root.toJsonPointer(ext));
        }
        return serializedForm;
    }

    void deserialize(Map<String, Object> source) {
        if (source.containsKey("$extends")) {
            String jsonPointerFormat = (String)source.get("$extends");
            if (jsonPointerFormat.startsWith("#")) {
                jsonPointerFormat = jsonPointerFormat.substring(1);
            }
            this.baseTypeReference = this.root.getId().relativize(URI.create(jsonPointerFormat));
        }
    }

    void deserialize(T schemaNode) {
        for (SchemaProperty property : ((AbstractNode)((Object)schemaNode)).getProperty(AbstractSchemaNode.schemaProperties)) {
            StructrPropertyDefinition propertyDefinition = StructrPropertyDefinition.deserialize(this, property);
            if (propertyDefinition == null) continue;
            this.properties.add(propertyDefinition);
        }
        for (SchemaView view : ((AbstractNode)((Object)schemaNode)).getProperty(AbstractSchemaNode.schemaViews)) {
            if ("_graph".equals(view.getName())) continue;
            TreeSet<String> propertySet = new TreeSet<String>();
            for (SchemaProperty schemaProperty : view.getProperty(SchemaView.schemaProperties)) {
                propertySet.add(schemaProperty.getName());
            }
            String nonGraphProperties = view.getProperty(SchemaView.nonGraphProperties);
            if (nonGraphProperties != null) {
                for (String property : nonGraphProperties.split("[, ]+")) {
                    String trimmed = property.trim();
                    if (!StringUtils.isNotBlank((CharSequence)trimmed)) continue;
                    propertySet.add(trimmed);
                }
            }
            if (propertySet.isEmpty()) continue;
            this.views.put(view.getName(), propertySet);
        }
        for (SchemaMethod method : ((AbstractNode)((Object)schemaNode)).getProperty(AbstractSchemaNode.schemaMethods)) {
            String _name = method.getName();
            String _source = method.getProperty(SchemaMethod.source);
            String string = method.getProperty(SchemaMethod.comment);
            this.addMethod(_name, _source, string);
        }
        String extendsClass = ((AbstractNode)((Object)schemaNode)).getProperty(SchemaNode.extendsClass);
        if (extendsClass != null) {
            String typeName = extendsClass.substring(extendsClass.lastIndexOf(".") + 1);
            this.baseTypeReference = extendsClass.startsWith("org.structr.dynamic.") ? this.root.getId().resolve("definitions/" + typeName) : StructrApp.getSchemaBaseURI().resolve("definitions/" + typeName);
        }
    }

    AbstractSchemaNode createDatabaseSchema(App app) throws FrameworkException {
        TreeMap<String, SchemaProperty> schemaProperties = new TreeMap<String, SchemaProperty>();
        String schemaNode = this.createSchemaNode(app);
        for (StructrPropertyDefinition structrPropertyDefinition : this.properties) {
            SchemaProperty schemaProperty = structrPropertyDefinition.createDatabaseSchema(app, (AbstractSchemaNode)((Object)schemaNode));
            if (schemaProperty == null) continue;
            schemaProperties.put(schemaProperty.getName(), schemaProperty);
        }
        for (Map.Entry entry : this.views.entrySet()) {
            LinkedList<SchemaProperty> viewProperties = new LinkedList<SchemaProperty>();
            LinkedList<String> nonGraphProperties = new LinkedList<String>();
            for (String propertyName : (Set)entry.getValue()) {
                SchemaProperty property = (SchemaProperty)schemaProperties.get(propertyName);
                if (property != null) {
                    viewProperties.add(property);
                    continue;
                }
                nonGraphProperties.add(propertyName);
            }
            app.create(SchemaView.class, new NodeAttribute<AbstractSchemaNode>((PropertyKey<AbstractSchemaNode>)SchemaView.schemaNode, (AbstractSchemaNode)((Object)schemaNode)), new NodeAttribute(AbstractNode.name, entry.getKey()), new NodeAttribute(SchemaView.schemaProperties, viewProperties), new NodeAttribute<String>(SchemaView.nonGraphProperties, StringUtils.join(nonGraphProperties, (String)", ")));
        }
        for (Map.Entry entry : this.getMethods().entrySet()) {
            Map methodDefinition = (Map)entry.getValue();
            app.create(SchemaMethod.class, new NodeAttribute<AbstractSchemaNode>((PropertyKey<AbstractSchemaNode>)SchemaMethod.schemaNode, (AbstractSchemaNode)((Object)schemaNode)), new NodeAttribute(AbstractNode.name, entry.getKey()), new NodeAttribute<String>((PropertyKey<String>)SchemaMethod.source, (String)methodDefinition.get(SchemaMethod.source.jsonName())), new NodeAttribute<String>((PropertyKey<String>)SchemaMethod.comment, (String)methodDefinition.get(SchemaMethod.comment.jsonName())));
        }
        if (this.baseTypeReference != null) {
            Object def = this.root.resolveURI(this.baseTypeReference);
            if (def != null && def instanceof JsonType) {
                JsonType jsonType = (JsonType)def;
                String superclassName = "org.structr.dynamic." + jsonType.getName();
                ((AbstractNode)((Object)schemaNode)).setProperty(SchemaNode.extendsClass, (String)superclassName);
            } else {
                Class clazz = StructrApp.resolveSchemaId(this.baseTypeReference);
                if (clazz != null) {
                    ((AbstractNode)((Object)schemaNode)).setProperty(SchemaNode.extendsClass, (String)clazz.getName());
                }
            }
        }
        return schemaNode;
    }

    T getSchemaNode() {
        return this.schemaNode;
    }

    void setSchemaNode(T schemaNode) {
        this.schemaNode = schemaNode;
    }

    Map<String, Set<String>> getViews() {
        return this.views;
    }

    void initializeReferenceProperties() {
        for (StructrPropertyDefinition property : this.properties) {
            property.initializeReferences();
        }
    }

    static StructrTypeDefinition deserialize(StructrSchemaDefinition root, String name, Map<String, Object> source) {
        Object value;
        TreeMap<String, StructrPropertyDefinition> deserializedProperties = new TreeMap<String, StructrPropertyDefinition>();
        StructrTypeDefinition typeDefinition = StructrTypeDefinition.determineType(root, name, source);
        Map properties = (Map)source.get("properties");
        List requiredPropertyNames = (List)source.get("required");
        Map views = (Map)source.get("views");
        Map methods = (Map)source.get("methods");
        if (properties != null) {
            for (Map.Entry entry : properties.entrySet()) {
                String propertyName = (String)entry.getKey();
                value = entry.getValue();
                if (value instanceof Map) {
                    StructrPropertyDefinition property = StructrPropertyDefinition.deserialize(typeDefinition, propertyName, (Map)value);
                    if (property == null) continue;
                    deserializedProperties.put(property.getName(), property);
                    typeDefinition.getProperties().add(property);
                    continue;
                }
                throw new IllegalStateException("Invalid JSON property definition for property " + propertyName + ", expected object.");
            }
        }
        if (requiredPropertyNames != null) {
            for (String requiredPropertyName : requiredPropertyNames) {
                StructrPropertyDefinition property = (StructrPropertyDefinition)deserializedProperties.get(requiredPropertyName);
                if (property != null) {
                    property.setRequired(true);
                    continue;
                }
                throw new IllegalStateException("Required property " + requiredPropertyName + " not defined for type " + typeDefinition.getName() + ".");
            }
        }
        if (views != null) {
            for (Map.Entry entry : views.entrySet()) {
                String viewName = (String)entry.getKey();
                value = entry.getValue();
                if (value instanceof List) {
                    TreeSet viewProperties = new TreeSet((List)value);
                    typeDefinition.getViews().put(viewName, viewProperties);
                    continue;
                }
                throw new IllegalStateException("View definition " + viewName + " must be of type array.");
            }
        }
        if (methods != null) {
            for (Map.Entry entry : methods.entrySet()) {
                String methodName = (String)entry.getKey();
                value = entry.getValue();
                if (value instanceof String) {
                    TreeMap<String, String> methodDefinition = new TreeMap<String, String>();
                    methodDefinition.put(SchemaMethod.source.jsonName(), value.toString());
                    methodDefinition.put(SchemaMethod.comment.jsonName(), "");
                    typeDefinition.getMethods().put(methodName, methodDefinition);
                    continue;
                }
                if (value instanceof Map) {
                    typeDefinition.getMethods().put(methodName, (Map<String, String>)value);
                    continue;
                }
                throw new IllegalStateException("Method definition " + methodName + " must be of type string or map.");
            }
        }
        return typeDefinition;
    }

    static StructrTypeDefinition deserialize(StructrSchemaDefinition root, SchemaNode schemaNode) {
        StructrNodeTypeDefinition def = new StructrNodeTypeDefinition(root, schemaNode.getClassName());
        def.deserialize(schemaNode);
        return def;
    }

    static StructrTypeDefinition deserialize(StructrSchemaDefinition root, SchemaRelationshipNode schemaRelationship) {
        StructrRelationshipTypeDefinition def = new StructrRelationshipTypeDefinition(root, schemaRelationship.getClassName());
        def.deserialize(schemaRelationship);
        return def;
    }

    protected SchemaNode resolveSchemaNode(App app, URI uri) throws FrameworkException {
        Class type;
        Object source = this.root.resolveURI(uri);
        if (source != null && source instanceof StructrTypeDefinition) {
            return (SchemaNode)((StructrTypeDefinition)source).getSchemaNode();
        }
        if (uri.isAbsolute() && (type = StructrApp.resolveSchemaId(uri)) != null) {
            return app.nodeQuery(SchemaNode.class).andName(type.getSimpleName()).getFirst();
        }
        return null;
    }

    private static StructrTypeDefinition determineType(StructrSchemaDefinition root, String name, Map<String, Object> source) {
        if (source.containsKey("rel")) {
            StructrRelationshipTypeDefinition def = new StructrRelationshipTypeDefinition(root, name);
            def.deserialize(source);
            return def;
        }
        StructrNodeTypeDefinition def = new StructrNodeTypeDefinition(root, name);
        def.deserialize(source);
        return def;
    }

    private void addPropertyNameToViews(String name, String ... views) {
        for (String viewName : views) {
            Set<String> view = this.views.get(viewName);
            if (view == null) {
                view = new TreeSet<String>();
                this.views.put(viewName, view);
            }
            view.add(name);
        }
    }
}

