/*
 * Decompiled with CFR 0.152.
 */
package org.structr.schema.importer;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.error.FrameworkException;
import org.structr.core.graph.MaintenanceCommand;
import org.structr.schema.importer.SchemaImporter;

public class GraphGistImporter
extends SchemaImporter
implements MaintenanceCommand {
    private static final Logger logger = LoggerFactory.getLogger((String)GraphGistImporter.class.getName());

    @Override
    public void execute(Map<String, Object> attributes) throws FrameworkException {
        block44: {
            String fileName = (String)attributes.get("file");
            String source = (String)attributes.get("source");
            String url = (String)attributes.get("url");
            if (fileName == null && source == null && url == null) {
                throw new FrameworkException(422, "Please supply file, url or source parameter.");
            }
            if (fileName != null && source != null) {
                throw new FrameworkException(422, "Please supply only one of file, url or source.");
            }
            if (fileName != null && url != null) {
                throw new FrameworkException(422, "Please supply only one of file, url or source.");
            }
            if (url != null && source != null) {
                throw new FrameworkException(422, "Please supply only one of file, url or source.");
            }
            try {
                if (fileName != null) {
                    try (FileInputStream fis = new FileInputStream(fileName);){
                        this.importCypher(this.extractSources(fis));
                        break block44;
                    }
                }
                if (url != null) {
                    try (InputStream is = new URL(url).openStream();){
                        this.importCypher(this.extractSources(is));
                        break block44;
                    }
                }
                if (source == null) break block44;
                try (ByteArrayInputStream bis = new ByteArrayInputStream(source.getBytes());){
                    this.importCypher(this.extractSources(bis));
                }
            }
            catch (IOException ioex) {
                logger.debug("Filename: " + fileName + ", URL: " + url + ", source: " + source, (Throwable)ioex);
            }
        }
        this.analyzeSchema();
    }

    @Override
    public boolean requiresEnclosingTransaction() {
        return false;
    }

    @Override
    public boolean requiresFlushingOfCaches() {
        return false;
    }
}

