/*
 * Decompiled with CFR 0.152.
 */
package org.structr.schema.importer;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.core.graph.SyncCommand;

public class LazyFileBasedLongCollection
implements Collection<Long>,
Closeable {
    private static final Logger logger = LoggerFactory.getLogger((String)LazyFileBasedLongCollection.class.getName());
    private DataOutputStream dos = null;
    private File file = null;

    public LazyFileBasedLongCollection(String path) {
        this(path, true);
    }

    public LazyFileBasedLongCollection(String path, boolean clearOnOpen) {
        this.file = new File(path);
        this.file.getParentFile().mkdirs();
        if (clearOnOpen && this.file.exists()) {
            this.file.delete();
        }
        this.open(true);
    }

    @Override
    public int hashCode() {
        return this.file.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof LazyFileBasedLongCollection && o.hashCode() == this.hashCode();
    }

    @Override
    public int size() {
        int count = 0;
        if (this.file.exists()) {
            Iterator<Long> it = this.iterator();
            while (it.hasNext()) {
                ++count;
                it.next();
            }
        }
        return count;
    }

    @Override
    public boolean isEmpty() {
        return !this.iterator().hasNext();
    }

    @Override
    public boolean contains(Object o) {
        for (Long val : this) {
            if (!val.equals(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<Long> iterator() {
        return new FileIterator(this.file);
    }

    @Override
    public Object[] toArray() {
        ArrayList<Long> list = new ArrayList<Long>();
        for (Long val : this) {
            list.add(val);
        }
        return list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        ArrayList<Long> list = new ArrayList<Long>();
        for (Long val : this) {
            list.add(val);
        }
        return list.toArray(a);
    }

    @Override
    public boolean add(Long e) {
        try {
            SyncCommand.serialize(this.dos, e);
        }
        catch (IOException ex) {
            logger.error("", (Throwable)ex);
        }
        return true;
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public boolean addAll(Collection<? extends Long> toAdd) {
        if (toAdd.hashCode() == this.hashCode()) {
            return true;
        }
        try {
            for (Long l : toAdd) {
                SyncCommand.serialize(this.dos, l);
            }
        }
        catch (IOException ex) {
            logger.error("", (Throwable)ex);
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public void clear() {
        this.open(false);
    }

    @Override
    public void close() throws IOException {
        this.dos.flush();
        this.dos.close();
    }

    private void open(boolean append) {
        try {
            if (this.dos != null) {
                this.dos.close();
            }
        }
        catch (IOException ioex) {
            logger.warn("", (Throwable)ioex);
        }
        try {
            this.dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.file, append)));
        }
        catch (IOException ioex) {
            logger.warn("", (Throwable)ioex);
        }
    }

    private static class FileIterator
    implements Iterator<Long> {
        private DataInputStream dis = null;
        private Long currentObject = null;

        public FileIterator(File file) {
            try {
                this.dis = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
            }
            catch (IOException ioex) {
                logger.warn("", (Throwable)ioex);
            }
        }

        @Override
        public boolean hasNext() {
            try {
                this.currentObject = (Long)SyncCommand.deserialize(this.dis);
                if (this.currentObject != null) {
                    return true;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.close();
            return false;
        }

        @Override
        public Long next() {
            return this.currentObject;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported.");
        }

        private void close() {
            try {
                this.dis.close();
            }
            catch (IOException ioex) {
                logger.warn("", (Throwable)ioex);
            }
        }
    }
}

