/*
 * Decompiled with CFR 0.152.
 */
package org.structr.schema.importer;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.CaseHelper;
import org.structr.common.error.FrameworkException;
import org.structr.core.graph.MaintenanceCommand;
import org.structr.schema.importer.SchemaImporter;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class RDFImporter
extends SchemaImporter
implements MaintenanceCommand {
    private static final Logger logger = LoggerFactory.getLogger((String)RDFImporter.class.getName());
    private static String separator = null;

    @Override
    public void execute(Map<String, Object> attributes) throws FrameworkException {
        block45: {
            String fileName = (String)attributes.get("file");
            String source = (String)attributes.get("source");
            String url = (String)attributes.get("url");
            separator = (String)attributes.get("separator");
            if (StringUtils.isBlank((CharSequence)separator)) {
                separator = "#";
            }
            if (fileName == null && source == null && url == null) {
                throw new FrameworkException(422, "Please supply file, url or source parameter.");
            }
            if (fileName != null && source != null) {
                throw new FrameworkException(422, "Please supply only one of file, url or source.");
            }
            if (fileName != null && url != null) {
                throw new FrameworkException(422, "Please supply only one of file, url or source.");
            }
            if (url != null && source != null) {
                throw new FrameworkException(422, "Please supply only one of file, url or source.");
            }
            try {
                if (fileName != null) {
                    try (FileInputStream fis = new FileInputStream(fileName);){
                        this.importCypher(this.importRDF(fis));
                        break block45;
                    }
                }
                if (url != null) {
                    try (InputStream is = new URL(url).openStream();){
                        this.importCypher(this.importRDF(is));
                        break block45;
                    }
                }
                if (source == null) break block45;
                try (ByteArrayInputStream bis = new ByteArrayInputStream(source.getBytes());){
                    this.importCypher(this.importRDF(bis));
                }
            }
            catch (Throwable t) {
                logger.warn("", t);
            }
        }
        this.analyzeSchema();
    }

    @Override
    public boolean requiresEnclosingTransaction() {
        return true;
    }

    @Override
    public boolean requiresFlushingOfCaches() {
        return false;
    }

    public List<String> importRDF(InputStream is) throws IOException, ParserConfigurationException, SAXException, XPathExpressionException {
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(is);
        LinkedHashSet<HasSubclassRelationship> subclasses = new LinkedHashSet<HasSubclassRelationship>();
        LinkedHashMap<String, RdfProperty> properties = new LinkedHashMap<String, RdfProperty>();
        LinkedHashMap<String, RdfClass> classes = new LinkedHashMap<String, RdfClass>();
        LinkedHashSet<Triple> triples = new LinkedHashSet<Triple>();
        StringBuilder cypher = new StringBuilder();
        LinkedList<String> cypherStatements = new LinkedList<String>();
        for (Node node = doc.getElementsByTagName("rdfs:Class").item(0); node != null; node = node.getNextSibling()) {
            String type = node.getNodeName();
            if ("rdfs:Class".equals(type)) {
                RDFImporter.handleClass(classes, subclasses, node);
            }
            if (!"rdf:Property".equals(type)) continue;
            RDFImporter.handleProperty(properties, triples, node);
        }
        for (Map.Entry entry : classes.entrySet()) {
            LinkedHashSet<String> superclasses = new LinkedHashSet<String>();
            String id = (String)entry.getKey();
            RdfClass rdfClass = (RdfClass)entry.getValue();
            superclasses.add(rdfClass.name);
            for (HasSubclassRelationship rel : subclasses) {
                if (!rel.child.equals(id)) continue;
                superclasses.add(((RdfClass)classes.get((Object)rel.parent)).id);
            }
            cypher.append("CREATE (").append(rdfClass.id.replaceAll("[\\W_]+", ""));
            for (String cl : superclasses) {
                cypher.append(":").append(rdfClass.type);
            }
            cypher.append(" { ");
            cypher.append("name: '").append(rdfClass.name).append("' ");
            if (StringUtils.isNotBlank((CharSequence)rdfClass.comment)) {
                cypher.append(", comment: '").append(rdfClass.comment).append("' ");
            }
            cypher.append("})\n");
        }
        for (Triple triple : triples) {
            if (triple.relationship.endsWith("i") || triple.target.startsWith("http")) continue;
            cypher.append("CREATE (").append(triple.source).append("-[:");
            String relType = ((RdfProperty)properties.get((Object)triple.relationship)).id;
            cypher.append(CaseHelper.toLowerCamelCase(relType).replaceAll("[\\W_]+", ""));
            cypher.append("]->");
            cypher.append(triple.target);
            cypher.append(")\n");
        }
        logger.info(cypher.toString());
        cypherStatements.add(cypher.toString());
        return cypherStatements;
    }

    private static void handleClass(Map<String, RdfClass> classes, Set<HasSubclassRelationship> subclasses, Node classNode) {
        NamedNodeMap attributes = classNode.getAttributes();
        String comment = RDFImporter.getChildString(classNode, "rdfs:comment");
        String rawName = RDFImporter.getString(attributes, "rdf:ID") != null ? RDFImporter.getString(attributes, "rdf:ID") : RDFImporter.getString(attributes, "rdf:about");
        classes.put(rawName, new RdfClass(rawName, comment));
        for (Node node = classNode.getChildNodes().item(0); node != null; node = node.getNextSibling()) {
            String type = node.getNodeName();
            if (!"rdfs:subClassOf".equals(type)) continue;
            String parent = RDFImporter.handleSubclass(classes, node);
            subclasses.add(new HasSubclassRelationship(parent, rawName));
        }
    }

    private static String handleSubclass(Map<String, RdfClass> classes, Node classNode) {
        NamedNodeMap attributes = classNode.getAttributes();
        String comment = RDFImporter.getChildString(classNode, "rdfs:comment");
        String rawName = RDFImporter.getString(attributes, "rdf:resource");
        classes.put(rawName, new RdfClass(rawName, comment));
        return rawName;
    }

    private static void handleProperty(Map<String, RdfProperty> properties, Set<Triple> triples, Node propertyNode) {
        NamedNodeMap attributes = propertyNode.getAttributes();
        String comment = RDFImporter.getChildString(propertyNode, "rdfs:comment");
        String rawName = RDFImporter.getString(attributes, "rdf:ID") != null ? RDFImporter.getString(attributes, "rdf:ID") : RDFImporter.getString(attributes, "rdf:about");
        properties.put(rawName, new RdfProperty(rawName, comment));
        String domain = null;
        String range = null;
        for (Node node = propertyNode.getChildNodes().item(0); node != null; node = node.getNextSibling()) {
            String type = node.getNodeName();
            if ("rdfs:domain".equals(type)) {
                domain = RDFImporter.handleDomain(node);
            }
            if (!"rdfs:range".equals(type)) continue;
            range = RDFImporter.handleRange(node);
        }
        triples.add(new Triple(domain, rawName, range));
    }

    private static String handleDomain(Node propertyNode) {
        NamedNodeMap attributes = propertyNode.getAttributes();
        String rawName = RDFImporter.getString(attributes, "rdf:resource");
        int position = rawName.lastIndexOf(separator);
        if (position >= 0) {
            String id = rawName.substring(0, position);
            return id;
        }
        return rawName;
    }

    private static String handleRange(Node propertyNode) {
        NamedNodeMap attributes = propertyNode.getAttributes();
        String rawName = RDFImporter.getString(attributes, "rdf:resource");
        int position = rawName.lastIndexOf(separator);
        if (position >= 0) {
            String id = rawName.substring(0, position);
            return id;
        }
        return rawName;
    }

    private static String getString(NamedNodeMap attributes, String key) {
        Node node = attributes.getNamedItem(key);
        return node != null ? attributes.getNamedItem(key).getNodeValue() : null;
    }

    private static String getChildString(Node parent, String key) {
        for (Node child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!key.equals(child.getNodeName())) continue;
            return child.getTextContent();
        }
        return null;
    }

    private static class Triple {
        public String relationship = null;
        public String source = null;
        public String target = null;

        public Triple(String source, String property, String target) {
            this.relationship = property;
            this.source = source;
            this.target = target;
        }

        public String toString() {
            return this.source + "-[" + this.relationship + "]->" + this.target;
        }
    }

    private static class RdfProperty {
        public String comment = null;
        public String name = null;
        public String id = null;
        public String type = null;

        public RdfProperty(String rawAttribueValue, String comment) {
            int position = rawAttribueValue.lastIndexOf(separator);
            this.name = rawAttribueValue;
            this.id = rawAttribueValue.replaceAll("[\\W_]+", "");
            this.type = rawAttribueValue.substring(position + 1).replaceAll("[\\W_]+", "");
            this.comment = comment;
        }
    }

    private static class RdfClass {
        public String comment = null;
        public String name = null;
        public String id = null;
        public String type = null;

        public RdfClass(String rawAttribueValue, String comment) {
            int position = rawAttribueValue.lastIndexOf(separator);
            this.name = rawAttribueValue;
            this.id = rawAttribueValue.replaceAll("[\\W_]+", "");
            this.type = rawAttribueValue.substring(position + 1).replaceAll("[\\W_]+", "");
            this.comment = comment;
        }
    }

    private static class HasSubclassRelationship {
        public String parent = null;
        public String child = null;

        public HasSubclassRelationship(String parent, String child) {
            this.parent = parent;
            this.child = child;
        }

        public String toString() {
            return this.parent + "->" + this.child;
        }
    }
}

