/*
 * Decompiled with CFR 0.152.
 */
package org.structr.schema.importer;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.DatabaseService;
import org.structr.api.config.Settings;
import org.structr.api.graph.Node;
import org.structr.api.graph.Relationship;
import org.structr.api.util.Iterables;
import org.structr.common.SecurityContext;
import org.structr.common.StructrAndSpatialPredicate;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.Services;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.entity.SchemaNode;
import org.structr.core.entity.SchemaRelationshipNode;
import org.structr.core.graph.BulkGraphOperation;
import org.structr.core.graph.BulkRebuildIndexCommand;
import org.structr.core.graph.NodeServiceCommand;
import org.structr.core.graph.Tx;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.PropertyMap;
import org.structr.core.property.StringProperty;
import org.structr.schema.ConfigurationProvider;
import org.structr.schema.importer.FileBasedHashLongMap;
import org.structr.schema.importer.NodeInfo;
import org.structr.schema.importer.RelationshipInfo;
import org.structr.schema.importer.TypeInfo;

public abstract class SchemaImporter
extends NodeServiceCommand {
    private static final String userHome = System.getProperty("user.home");
    private static final Logger logger = LoggerFactory.getLogger((String)SchemaImporter.class.getName());

    public List<String> extractSources(InputStream source) {
        LinkedList<String> sources = new LinkedList<String>();
        StringBuilder buf = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(source));){
            String line = reader.readLine();
            boolean beforeCypher = false;
            boolean inCypher = false;
            while (line != null) {
                String trimmedLine = line.trim().replaceAll("[\\s]+", "");
                if (inCypher && "----".equals(trimmedLine)) {
                    inCypher = false;
                    beforeCypher = false;
                    String result = buf.toString().toUpperCase();
                    if (result.contains("CREATE") || result.contains("LOAD CSV")) {
                        sources.add(buf.toString());
                        buf.setLength(0);
                    }
                }
                if (inCypher) {
                    buf.append(line);
                    buf.append("\n");
                    if (trimmedLine.endsWith(";")) {
                        sources.add(buf.toString());
                        buf.setLength(0);
                    }
                }
                if ("[source,cypher]".equals(trimmedLine)) {
                    beforeCypher = true;
                }
                if (beforeCypher && "----".equals(trimmedLine)) {
                    inCypher = true;
                    beforeCypher = false;
                }
                line = reader.readLine();
            }
        }
        catch (IOException ioex) {
            logger.warn("", (Throwable)ioex);
        }
        return sources;
    }

    public void analyzeSchema() {
        Object object;
        Tx tx;
        final App app = StructrApp.getInstance();
        final FileBasedHashLongMap<NodeInfo> nodeIdMap = new FileBasedHashLongMap<NodeInfo>(userHome + File.separator + ".structrSchemaAnalyzer");
        final DatabaseService graphDb = app.getDatabaseService();
        final ConfigurationProvider configuration = Services.getInstance().getConfigurationProvider();
        final LinkedHashSet<NodeInfo> nodeTypes = new LinkedHashSet<NodeInfo>();
        final LinkedHashSet relationships = new LinkedHashSet();
        final LinkedHashMap schemaNodes = new LinkedHashMap();
        LinkedHashMap<String, List<TypeInfo>> typeInfoTypeMap = new LinkedHashMap<String, List<TypeInfo>>();
        LinkedList<TypeInfo> reducedTypeInfos = new LinkedList<TypeInfo>();
        LinkedList<TypeInfo> typeInfos = new LinkedList<TypeInfo>();
        Iterator relIterator = null;
        Iterator nodeIterator = null;
        this.info("Fetching all nodes iterator..", new Object[0]);
        try {
            tx = app.tx();
            object = null;
            try {
                nodeIterator = Iterables.filter(new StructrAndSpatialPredicate(false, false, true), (Iterable)graphDb.getAllNodes()).iterator();
                tx.success();
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (tx != null) {
                    if (object != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
        }
        catch (FrameworkException fex) {
            logger.warn("", (Throwable)fex);
        }
        this.info("Starting to analyze nodes..", new Object[0]);
        this.bulkGraphOperation(SecurityContext.getSuperUserInstance(), nodeIterator, 100000L, "Analyzing nodes", new BulkGraphOperation<Node>(){

            @Override
            public void handleGraphObject(SecurityContext securityContext, Node node) throws FrameworkException {
                NodeInfo nodeInfo = new NodeInfo(node);
                nodeTypes.add(nodeInfo);
                nodeIdMap.add(nodeInfo, node.getId());
            }
        });
        this.info("Identifying common base classes..", new Object[0]);
        try {
            tx = app.tx(true, false, false);
            object = null;
            try {
                SchemaImporter.identifyCommonBaseClasses(app, nodeTypes, nodeIdMap, typeInfos);
                tx.success();
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (tx != null) {
                    if (object != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
        }
        catch (FrameworkException fex) {
            logger.warn("", (Throwable)fex);
        }
        this.info("Collecting type information..", new Object[0]);
        try {
            tx = app.tx(true, false, false);
            object = null;
            try {
                SchemaImporter.collectTypeInfos(typeInfos, typeInfoTypeMap);
                tx.success();
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (tx != null) {
                    if (object != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
        }
        catch (FrameworkException fex) {
            logger.warn("", (Throwable)fex);
        }
        this.info("Aggregating type information..", new Object[0]);
        try {
            tx = app.tx(true, false, false);
            object = null;
            try {
                SchemaImporter.reduceTypeInfos(typeInfoTypeMap, reducedTypeInfos);
                tx.success();
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (tx != null) {
                    if (object != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
        }
        catch (FrameworkException fex) {
            logger.warn("", (Throwable)fex);
        }
        this.info("Identifying property sets..", new Object[0]);
        try {
            tx = app.tx(true, false, false);
            object = null;
            try {
                SchemaImporter.intersectPropertySets(reducedTypeInfos);
                tx.success();
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (tx != null) {
                    if (object != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
        }
        catch (FrameworkException fex) {
            logger.warn("", (Throwable)fex);
        }
        this.info("Sorting result..", new Object[0]);
        try {
            tx = app.tx(true, false, false);
            object = null;
            try {
                Collections.sort(reducedTypeInfos, new HierarchyComparator(false));
                tx.success();
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (tx != null) {
                    if (object != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
        }
        catch (FrameworkException fex) {
            logger.warn("", (Throwable)fex);
        }
        final LinkedHashMap<String, TypeInfo> reducedTypeInfoMap = new LinkedHashMap<String, TypeInfo>();
        for (TypeInfo typeInfo : reducedTypeInfos) {
            final String type = typeInfo.getPrimaryType();
            reducedTypeInfoMap.put(type, typeInfo);
            this.info("Starting with setting of type and ID for type {}", type);
            this.bulkGraphOperation(SecurityContext.getSuperUserInstance(), typeInfo.getNodeIds().iterator(), 10000L, "Setting type and ID", new BulkGraphOperation<Long>(){

                @Override
                public void handleGraphObject(SecurityContext securityContext, Long nodeId) throws FrameworkException {
                    Node node = graphDb.getNodeById(nodeId.longValue());
                    node.setProperty(GraphObject.id.dbName(), (Object)NodeServiceCommand.getNextUuid());
                    node.setProperty(GraphObject.type.dbName(), (Object)type);
                }
            });
        }
        this.info("Fetching all relationships iterator..", new Object[0]);
        try {
            Throwable throwable = null;
            try (Tx tx2 = app.tx(true, false, false);){
                relIterator = Iterables.filter(new StructrAndSpatialPredicate(false, false, true), (Iterable)graphDb.getAllRelationships()).iterator();
                tx2.success();
            }
            catch (Throwable type) {
                Throwable throwable2 = type;
                throw type;
            }
        }
        catch (FrameworkException fex) {
            logger.warn("", (Throwable)fex);
        }
        this.info("Starting with analyzing relationships..", new Object[0]);
        this.bulkGraphOperation(SecurityContext.getSuperUserInstance(), relIterator, 10000L, "Analyzing relationships", new BulkGraphOperation<Relationship>(){

            @Override
            public void handleGraphObject(SecurityContext securityContext, Relationship rel) throws FrameworkException {
                Node startNode = rel.getStartNode();
                Node endNode = rel.getEndNode();
                if (startNode.hasProperty("type") && endNode.hasProperty("type")) {
                    String relationshipType = rel.getType().name();
                    String startNodeType = (String)startNode.getProperty("type");
                    String endNodeType = (String)endNode.getProperty("type");
                    relationships.add(new RelationshipInfo(startNodeType, endNodeType, relationshipType));
                    if (startNodeType != null && endNodeType != null) {
                        String combinedType = SchemaImporter.getCombinedType(startNodeType, relationshipType, endNodeType);
                        logger.debug("Combined relationship type {} found for rel type {}, start node type {}, end node type {}", new Object[]{combinedType, relationshipType, startNodeType, endNodeType});
                        rel.setProperty(GraphObject.type.dbName(), (Object)combinedType);
                    }
                    rel.setProperty(GraphObject.id.dbName(), (Object)NodeServiceCommand.getNextUuid());
                }
            }
        });
        this.info("Grouping relationships..", new Object[0]);
        LinkedHashMap<String, LinkedList<RelationshipInfo>> relTypeInfoMap = new LinkedHashMap<String, LinkedList<RelationshipInfo>>();
        for (RelationshipInfo relInfo : relationships) {
            String combinedType = SchemaImporter.getCombinedType(relInfo.getStartNodeType(), relInfo.getRelType(), relInfo.getEndNodeType());
            LinkedList<RelationshipInfo> infos = (LinkedList<RelationshipInfo>)relTypeInfoMap.get(combinedType);
            if (infos == null) {
                infos = new LinkedList<RelationshipInfo>();
                relTypeInfoMap.put(combinedType, infos);
            }
            infos.add(relInfo);
        }
        this.info("Aggregating relationship information..", new Object[0]);
        ArrayList<RelationshipInfo> arrayList = new ArrayList<RelationshipInfo>();
        if (((Boolean)Settings.InheritanceDetection.getValue()).booleanValue()) {
            for (List infos : relTypeInfoMap.values()) {
                arrayList.addAll(SchemaImporter.reduceNodeTypes(infos, reducedTypeInfoMap));
            }
        } else {
            arrayList.addAll(relationships);
        }
        this.info("Starting with schema node creation..", new Object[0]);
        this.bulkGraphOperation(SecurityContext.getSuperUserInstance(), reducedTypeInfos.iterator(), 100000L, "Creating schema nodes", new BulkGraphOperation<TypeInfo>(){

            @Override
            public void handleGraphObject(SecurityContext securityContext, TypeInfo typeInfo) throws FrameworkException {
                String type = typeInfo.getPrimaryType();
                if (!"ReferenceNode".equals(type)) {
                    Map<String, Class> props = typeInfo.getPropertySet();
                    PropertyMap propertyMap = new PropertyMap();
                    for (Map.Entry<String, Class> propertyEntry : props.entrySet()) {
                        String propertyName = propertyEntry.getKey();
                        Class propertyType = propertyEntry.getValue();
                        String propertyTypeName = propertyType.getSimpleName();
                        if (propertyType.isArray()) {
                            propertyTypeName = propertyTypeName.substring(0, propertyTypeName.length() - 2).concat("Array");
                        }
                        propertyMap.put(new StringProperty("_".concat(propertyName)), propertyTypeName);
                    }
                    propertyMap.put(AbstractNode.name, type);
                    Class existingType = configuration.getNodeEntityClass(type);
                    if (existingType != null) {
                        propertyMap.put(SchemaNode.extendsClass, existingType.getName());
                    } else if (!typeInfo.getOtherTypes().isEmpty()) {
                        propertyMap.put(SchemaNode.extendsClass, typeInfo.getSuperclass(reducedTypeInfoMap));
                    }
                    SchemaNode existingNode = app.nodeQuery(SchemaNode.class).andName(type).getFirst();
                    if (existingNode != null) {
                        for (Map.Entry<PropertyKey, Object> entry : propertyMap.entrySet()) {
                            existingNode.setProperty(entry.getKey(), entry.getValue());
                        }
                        schemaNodes.put(type, existingNode);
                    } else {
                        schemaNodes.put(type, app.create(SchemaNode.class, propertyMap));
                    }
                }
            }
        });
        this.info("Starting with schema relationship creation..", new Object[0]);
        this.bulkGraphOperation(SecurityContext.getSuperUserInstance(), arrayList.iterator(), 100000L, "Creating schema relationships", new BulkGraphOperation<RelationshipInfo>(){

            @Override
            public void handleGraphObject(SecurityContext securityContext, RelationshipInfo template) throws FrameworkException {
                String startNodeType = template.getStartNodeType();
                String endNodeType = template.getEndNodeType();
                if (startNodeType != null && endNodeType != null) {
                    SchemaNode startNode = (SchemaNode)schemaNodes.get(startNodeType);
                    SchemaNode endNode = (SchemaNode)schemaNodes.get(endNodeType);
                    if (startNode != null && endNode != null) {
                        String relationshipType = template.getRelType();
                        PropertyMap propertyMap = new PropertyMap();
                        propertyMap.put(SchemaRelationshipNode.sourceId, startNode.getUuid());
                        propertyMap.put(SchemaRelationshipNode.targetId, endNode.getUuid());
                        propertyMap.put(SchemaRelationshipNode.relationshipType, relationshipType);
                        app.create(SchemaRelationshipNode.class, propertyMap);
                    } else {
                        SchemaImporter.this.info("Unable to create schema relationship node for {} -> {}, no schema nodes found", new Object[]{startNodeType, endNodeType});
                    }
                }
            }
        });
        this.info("Starting with index rebuild..", new Object[0]);
        app.command(BulkRebuildIndexCommand.class).execute(Collections.EMPTY_MAP);
    }

    public void importCypher(List<String> sources) {
        App app = StructrApp.getInstance();
        if (sources.isEmpty()) {
            return;
        }
        try (Tx tx = app.tx(true, false, false);){
            for (String source : sources) {
                app.cypher(source, Collections.emptyMap());
            }
            tx.success();
        }
        catch (FrameworkException frameworkException) {
            // empty catch block
        }
    }

    private static String getCombinedType(String startNodeType, String relationshipType, String endNodeType) {
        return startNodeType.concat(relationshipType).concat(endNodeType);
    }

    private static void identifyCommonBaseClasses(App app, Set<NodeInfo> nodeTypes, FileBasedHashLongMap<NodeInfo> nodeIds, List<TypeInfo> typeInfos) {
        for (NodeInfo nodeInfo : nodeTypes) {
            Set<String> allTypes = nodeInfo.getTypes();
            for (String type : allTypes) {
                TypeInfo typeInfo = new TypeInfo(type, allTypes, nodeIds.get(nodeInfo));
                typeInfos.add(typeInfo);
                typeInfo.registerPropertySet(nodeInfo.getProperties());
            }
        }
    }

    private static void collectTypeInfos(List<TypeInfo> typeInfos, Map<String, List<TypeInfo>> typeInfoTypeMap) {
        for (TypeInfo info : typeInfos) {
            String type = info.getPrimaryType();
            List<TypeInfo> typeInfo = typeInfoTypeMap.get(type);
            if (typeInfo == null) {
                typeInfo = new LinkedList<TypeInfo>();
                typeInfoTypeMap.put(type, typeInfo);
            }
            typeInfo.add(info);
        }
    }

    private static void reduceTypeInfos(Map<String, List<TypeInfo>> typeInfoTypeMap, List<TypeInfo> reducedTypeInfos) {
        for (Map.Entry<String, List<TypeInfo>> entry : typeInfoTypeMap.entrySet()) {
            List<TypeInfo> listOfTypeInfosWithSamePrimaryType = entry.getValue();
            TypeInfo firstTypeInfo = null;
            for (TypeInfo typeInfo : listOfTypeInfosWithSamePrimaryType) {
                if (firstTypeInfo == null) {
                    firstTypeInfo = typeInfo;
                    continue;
                }
                firstTypeInfo.combinePropertySets(typeInfo.getPropertySet());
                firstTypeInfo.getNodeIds().addAll(typeInfo.getNodeIds());
            }
            if (firstTypeInfo == null) continue;
            reducedTypeInfos.add(firstTypeInfo);
            firstTypeInfo.setHierarchyLevel(listOfTypeInfosWithSamePrimaryType.size());
        }
    }

    private static void intersectPropertySets(List<TypeInfo> reducedTypeInfos) {
        for (TypeInfo info : reducedTypeInfos) {
            if (info.getHierarchyLevel() <= 1) continue;
            Set<String> supertypeKeySet = info.getPropertySet().keySet();
            for (TypeInfo subType : reducedTypeInfos) {
                Set<String> subtypeKeySet = subType.getPropertySet().keySet();
                if (subType.getHierarchyLevel() >= info.getHierarchyLevel() || !subType.hasSuperclass(info.getPrimaryType())) continue;
                subtypeKeySet.removeAll(supertypeKeySet);
            }
        }
    }

    private static List<RelationshipInfo> reduceNodeTypes(List<RelationshipInfo> sourceList, Map<String, TypeInfo> typeInfos) {
        ArrayList<RelationshipInfo> reducedList = new ArrayList<RelationshipInfo>();
        LinkedHashSet<String> startNodeTypes = new LinkedHashSet<String>();
        LinkedHashSet<String> endNodeTypes = new LinkedHashSet<String>();
        String relType = null;
        for (RelationshipInfo info : sourceList) {
            startNodeTypes.add(info.getStartNodeType());
            endNodeTypes.add(info.getEndNodeType());
            if (relType != null) continue;
            relType = info.getRelType();
        }
        int startTypeCount = startNodeTypes.size();
        int endTypeCount = endNodeTypes.size();
        String commonStartType = null;
        String commonEndType = null;
        commonStartType = startTypeCount == 1 ? (String)startNodeTypes.iterator().next() : SchemaImporter.reduceTypeToCommonSupertype(startNodeTypes, typeInfos);
        commonEndType = endTypeCount == 1 ? (String)endNodeTypes.iterator().next() : SchemaImporter.reduceTypeToCommonSupertype(endNodeTypes, typeInfos);
        if (commonStartType != null && commonEndType != null) {
            reducedList.add(new RelationshipInfo(commonStartType, commonEndType, relType));
        }
        return reducedList;
    }

    /*
     * WARNING - void declaration
     */
    private static String reduceTypeToCommonSupertype(Set<String> types, Map<String, TypeInfo> typeInfos) {
        ArrayList<Object> listOfSetsOfTypes = new ArrayList<Object>();
        for (String type : types) {
            void var6_7;
            LinkedHashSet listOfTypes = new LinkedHashSet();
            String string = type;
            listOfSetsOfTypes.add(listOfTypes);
            while (var6_7 != null) {
                TypeInfo typeInfo = typeInfos.get(var6_7);
                if (typeInfo != null) {
                    listOfTypes.add(typeInfo);
                    String string2 = typeInfo.getSuperclass(typeInfos);
                    continue;
                }
                Object var6_10 = null;
            }
        }
        LinkedHashSet intersection = new LinkedHashSet();
        boolean first = true;
        for (Set set : listOfSetsOfTypes) {
            if (first) {
                first = false;
                intersection.addAll(set);
                continue;
            }
            intersection.retainAll(set);
        }
        if (!intersection.isEmpty()) {
            ArrayList typeInfoList = new ArrayList(intersection);
            Collections.sort(typeInfoList, new HierarchyComparator(false));
            return ((TypeInfo)typeInfoList.get(0)).getPrimaryType();
        }
        return null;
    }

    static class HierarchyComparator
    implements Comparator<TypeInfo> {
        private boolean reverse = false;

        public HierarchyComparator(boolean reverse) {
            this.reverse = reverse;
        }

        @Override
        public int compare(TypeInfo o1, TypeInfo o2) {
            if (this.reverse) {
                return Integer.valueOf(o1.getHierarchyLevel()).compareTo(o2.getHierarchyLevel());
            }
            return Integer.valueOf(o2.getHierarchyLevel()).compareTo(o1.getHierarchyLevel());
        }
    }
}

