/*
 * Decompiled with CFR 0.152.
 */
package org.structr.schema.importer;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import org.apache.chemistry.opencmis.commons.impl.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.graph.MaintenanceCommand;
import org.structr.core.graph.Tx;
import org.structr.schema.export.StructrSchema;
import org.structr.schema.importer.SchemaImporter;
import org.structr.schema.json.InvalidSchemaException;
import org.structr.schema.json.JsonSchema;

public class SchemaJsonImporter
extends SchemaImporter
implements MaintenanceCommand {
    private static final Logger logger = LoggerFactory.getLogger((String)SchemaJsonImporter.class.getName());

    @Override
    public void execute(Map<String, Object> attributes) throws FrameworkException {
        block33: {
            String fileName = (String)attributes.get("file");
            String source = (String)attributes.get("source");
            String url = (String)attributes.get("url");
            if (fileName == null && source == null && url == null) {
                throw new FrameworkException(422, "Please supply file, url or source parameter.");
            }
            if (fileName != null && source != null) {
                throw new FrameworkException(422, "Please supply only one of file, url or source.");
            }
            if (fileName != null && url != null) {
                throw new FrameworkException(422, "Please supply only one of file, url or source.");
            }
            if (url != null && source != null) {
                throw new FrameworkException(422, "Please supply only one of file, url or source.");
            }
            try {
                if (fileName != null) {
                    try (FileInputStream is = new FileInputStream(fileName);){
                        SchemaJsonImporter.importSchemaJson(IOUtils.readAllLines((InputStream)is));
                        break block33;
                    }
                }
                if (url != null) {
                    try (InputStream is = new URL(url).openStream();){
                        SchemaJsonImporter.importSchemaJson(IOUtils.readAllLines((InputStream)is));
                        break block33;
                    }
                }
                if (source != null) {
                    SchemaJsonImporter.importSchemaJson(source);
                }
            }
            catch (IOException ioex) {
                logger.debug("Filename: " + fileName + ", URL: " + url + ", source: " + source, (Throwable)ioex);
            }
        }
    }

    public static void importSchemaJson(String source) throws FrameworkException {
        if (StringUtils.isBlank((CharSequence)source)) {
            return;
        }
        App app = StructrApp.getInstance();
        try (Tx tx = app.tx();){
            JsonSchema schema;
            try {
                schema = StructrSchema.createFromSource(source);
            }
            catch (URISyntaxException | InvalidSchemaException ex) {
                throw new FrameworkException(422, ex.getMessage());
            }
            try {
                StructrSchema.extendDatabaseSchema(app, schema);
            }
            catch (URISyntaxException ex) {
                throw new FrameworkException(422, ex.getMessage());
            }
            tx.success();
        }
    }

    @Override
    public boolean requiresEnclosingTransaction() {
        return false;
    }

    @Override
    public boolean requiresFlushingOfCaches() {
        return false;
    }
}

