/*
 * Decompiled with CFR 0.152.
 */
package org.structr.schema.importer;

import java.io.File;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.structr.schema.importer.LazyFileBasedLongCollection;

public class TypeInfo {
    private static final String userHome = System.getProperty("user.home");
    private final Map<String, Class> propertySet = new LinkedHashMap<String, Class>();
    private final Set<String> otherTypes = new LinkedHashSet<String>();
    private Collection<Long> nodeIds = null;
    private String primaryType = null;
    private int hierarchyLevel = 0;

    public TypeInfo(String primaryType, Set<String> otherTypes, Collection<Long> nodeIds) {
        this.nodeIds = new LazyFileBasedLongCollection(userHome + File.separator + ".structrSchemaAnalyzer" + File.separator + primaryType + ".lfc");
        this.primaryType = primaryType;
        this.otherTypes.addAll(otherTypes);
        this.otherTypes.remove(primaryType);
        this.nodeIds.addAll(nodeIds);
    }

    public int hashCode() {
        return this.primaryType.hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof TypeInfo) {
            return ((TypeInfo)other).hashCode() == this.hashCode();
        }
        return false;
    }

    public String toString() {
        return this.primaryType + "(" + this.hierarchyLevel + ") " + this.propertySet.keySet();
    }

    public void registerPropertySet(Map<String, Class> properties) {
        this.propertySet.putAll(properties);
    }

    public void combinePropertySets(Map<String, Class> otherProperties) {
        this.propertySet.putAll(otherProperties);
    }

    public Map<String, Class> getPropertySet() {
        return this.propertySet;
    }

    public String getSuperclass(Map<String, TypeInfo> typeInfos) {
        LinkedHashMap<Integer, TypeInfo> hierarchyMap = new LinkedHashMap<Integer, TypeInfo>();
        for (TypeInfo info : typeInfos.values()) {
            String type = info.getPrimaryType();
            if (!this.otherTypes.contains(type)) continue;
            hierarchyMap.put(info.getHierarchyLevel(), info);
        }
        int level = this.getHierarchyLevel() + 1;
        TypeInfo superType = (TypeInfo)hierarchyMap.get(level);
        while (superType == null && level < 100) {
            superType = (TypeInfo)hierarchyMap.get(++level);
        }
        if (superType != null) {
            return superType.getPrimaryType();
        }
        return null;
    }

    public boolean hasSuperclass(String type) {
        return this.otherTypes.contains(type);
    }

    public String getPrimaryType() {
        return this.primaryType;
    }

    public Set<String> getOtherTypes() {
        return this.otherTypes;
    }

    public Collection<Long> getNodeIds() {
        return this.nodeIds;
    }

    public int getHierarchyLevel() {
        return this.hierarchyLevel;
    }

    public void setHierarchyLevel(int level) {
        this.hierarchyLevel = level;
    }
}

