/*
 * Decompiled with CFR 0.152.
 */
package org.structr.schema.parser;

import org.structr.common.error.ErrorBuffer;
import org.structr.common.error.FrameworkException;
import org.structr.common.error.InvalidPropertySchemaToken;
import org.structr.core.entity.SchemaNode;
import org.structr.core.property.ElementCounter;
import org.structr.schema.Schema;
import org.structr.schema.SchemaHelper;
import org.structr.schema.parser.PropertyDefinition;
import org.structr.schema.parser.PropertySourceGenerator;

public class CountPropertyParser
extends PropertySourceGenerator {
    private String auxType = "";

    public CountPropertyParser(ErrorBuffer errorBuffer, String className, PropertyDefinition params) {
        super(errorBuffer, className, params);
    }

    @Override
    public String getPropertyType() {
        return ElementCounter.class.getSimpleName();
    }

    @Override
    public String getValueType() {
        return Integer.class.getName();
    }

    @Override
    public String getUnqualifiedValueType() {
        return "Integer";
    }

    @Override
    public String getPropertyParameters() {
        return this.auxType;
    }

    @Override
    public SchemaHelper.Type getKey() {
        return SchemaHelper.Type.Count;
    }

    @Override
    public void parseFormatString(Schema entity, String expression) throws FrameworkException {
        if (expression == null || expression.isEmpty()) {
            throw new FrameworkException(422, "Invalid count property expression.", new InvalidPropertySchemaToken(SchemaNode.class.getSimpleName(), expression, "invalid_property_reference", "Empty property reference."));
        }
        this.auxType = ", " + expression + "Property";
    }
}

