/*
 * Decompiled with CFR 0.152.
 */
package org.structr.schema.parser;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.structr.common.error.ErrorBuffer;
import org.structr.common.error.FrameworkException;
import org.structr.core.property.DateProperty;
import org.structr.schema.Schema;
import org.structr.schema.SchemaHelper;
import org.structr.schema.parser.PropertyDefinition;
import org.structr.schema.parser.PropertySourceGenerator;

public class DatePropertyParser
extends PropertySourceGenerator {
    private String pattern = null;

    public DatePropertyParser(ErrorBuffer errorBuffer, String className, PropertyDefinition params) {
        super(errorBuffer, className, params);
    }

    @Override
    public String getPropertyType() {
        return DateProperty.class.getSimpleName();
    }

    @Override
    public String getValueType() {
        return Date.class.getName();
    }

    @Override
    public String getUnqualifiedValueType() {
        return "Date";
    }

    @Override
    public String getPropertyParameters() {
        return "";
    }

    @Override
    public SchemaHelper.Type getKey() {
        return SchemaHelper.Type.Date;
    }

    @Override
    public void parseFormatString(Schema entity, String expression) throws FrameworkException {
        if (expression != null && !expression.isEmpty()) {
            this.pattern = expression;
        }
    }

    @Override
    public String getDefaultValue() {
        return "DatePropertyParser.parse(\"" + this.getSourceDefaultValue() + "\", " + (this.pattern != null ? "\"" + this.pattern + "\"" : "null") + ")";
    }

    public static Date parse(String source, String pattern) {
        if (StringUtils.isBlank((CharSequence)pattern)) {
            return DatePropertyParser.parseISO8601DateString(source);
        }
        try {
            if (StringUtils.contains((CharSequence)source, (CharSequence)"Z")) {
                source = StringUtils.replace((String)source, (String)"Z", (String)"+0000");
            }
            return new SimpleDateFormat(pattern).parse(source);
        }
        catch (ParseException parseException) {
            return DatePropertyParser.parseISO8601DateString(source);
        }
    }

    public static Date parseISO8601DateString(String source) {
        String[] supportedFormats = new String[]{"yyyy-MM-dd'T'HH:mm:ss.SSSXXX", "yyyy-MM-dd'T'HH:mm:ssXXX", "yyyy-MM-dd'T'HH:mm:ssZ", "yyyy-MM-dd'T'HH:mm:ss.SSSZ"};
        if (StringUtils.contains((CharSequence)source, (CharSequence)"Z")) {
            source = StringUtils.replace((String)source, (String)"Z", (String)"+0000");
        }
        Date parsedDate = null;
        for (String format : supportedFormats) {
            try {
                parsedDate = new SimpleDateFormat(format).parse(source);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            if (parsedDate == null) continue;
            return parsedDate;
        }
        return null;
    }

    public static String format(Date date, String format) {
        if (date != null) {
            if (StringUtils.isBlank((CharSequence)format)) {
                format = DateProperty.getDefaultFormat();
            }
            return new SimpleDateFormat(format).format(date);
        }
        return null;
    }
}

