/*
 * Decompiled with CFR 0.152.
 */
package org.structr.schema.parser;

import org.apache.commons.lang3.StringUtils;
import org.structr.common.error.ErrorBuffer;
import org.structr.common.error.InvalidPropertySchemaToken;
import org.structr.core.entity.SchemaNode;
import org.structr.core.property.IntProperty;
import org.structr.schema.SchemaHelper;
import org.structr.schema.parser.NumericalPropertyParser;
import org.structr.schema.parser.PropertyDefinition;

public class IntPropertyParser
extends NumericalPropertyParser {
    public IntPropertyParser(ErrorBuffer errorBuffer, String className, PropertyDefinition params) {
        super(errorBuffer, className, params);
    }

    @Override
    public String getPropertyType() {
        return IntProperty.class.getSimpleName();
    }

    @Override
    public String getValueType() {
        return Integer.class.getName();
    }

    @Override
    public String getUnqualifiedValueType() {
        return "Integer";
    }

    @Override
    public SchemaHelper.Type getKey() {
        return SchemaHelper.Type.Integer;
    }

    @Override
    public Number parseNumber(ErrorBuffer errorBuffer, String source, String which) {
        try {
            return Integer.parseInt(source);
        }
        catch (Throwable t) {
            errorBuffer.add(new InvalidPropertySchemaToken(SchemaNode.class.getSimpleName(), source, "invalid_" + which + "_bound", StringUtils.capitalize((String)which) + " bound must be of type Integer."));
            return null;
        }
    }
}

