/*
 * Decompiled with CFR 0.152.
 */
package org.structr.schema.parser;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.error.ErrorBuffer;
import org.structr.common.error.FrameworkException;
import org.structr.core.property.JoinProperty;
import org.structr.schema.Schema;
import org.structr.schema.SchemaHelper;
import org.structr.schema.parser.PropertyDefinition;
import org.structr.schema.parser.PropertySourceGenerator;

public class JoinPropertyParser
extends PropertySourceGenerator {
    private static final Logger logger = LoggerFactory.getLogger((String)JoinPropertyParser.class.getName());
    private String parameters = "";

    public JoinPropertyParser(ErrorBuffer errorBuffer, String className, PropertyDefinition params) {
        super(errorBuffer, className, params);
    }

    @Override
    public SchemaHelper.Type getKey() {
        return SchemaHelper.Type.Join;
    }

    @Override
    public String getPropertyType() {
        return JoinProperty.class.getSimpleName();
    }

    @Override
    public String getValueType() {
        return String.class.getSimpleName();
    }

    @Override
    public String getUnqualifiedValueType() {
        return this.getValueType();
    }

    @Override
    public String getPropertyParameters() {
        return this.parameters;
    }

    @Override
    public void parseFormatString(Schema entity, String expression) throws FrameworkException {
        StreamTokenizer tokenizer = new StreamTokenizer(new StringReader(expression));
        StringBuilder buf = new StringBuilder();
        tokenizer.wordChars(95, 95);
        String token = null;
        int type = 0;
        try {
            do {
                token = null;
                type = tokenizer.nextToken();
                switch (type) {
                    case -2: {
                        token = String.valueOf(tokenizer.nval);
                        break;
                    }
                    case -3: {
                        token = tokenizer.sval;
                        break;
                    }
                    case -1: 
                    case 10: {
                        break;
                    }
                    case 34: 
                    case 39: {
                        token = "\"" + tokenizer.sval + "\"";
                    }
                }
                if (token == null) continue;
                if (token.startsWith("_")) {
                    token = token.substring(1) + "Property";
                }
                buf.append(", ");
                buf.append(token);
            } while (type != -1);
        }
        catch (IOException ex) {
            logger.warn("", (Throwable)ex);
        }
        this.parameters = buf.toString();
    }
}

