/*
 * Decompiled with CFR 0.152.
 */
package org.structr.schema.parser;

import org.apache.commons.lang3.StringUtils;
import org.structr.common.error.ErrorBuffer;
import org.structr.common.error.InvalidPropertySchemaToken;
import org.structr.core.entity.SchemaNode;
import org.structr.core.property.LongProperty;
import org.structr.schema.SchemaHelper;
import org.structr.schema.parser.NumericalPropertyParser;
import org.structr.schema.parser.PropertyDefinition;

public class LongPropertyParser
extends NumericalPropertyParser {
    public LongPropertyParser(ErrorBuffer errorBuffer, String className, PropertyDefinition params) {
        super(errorBuffer, className, params);
    }

    @Override
    public String getPropertyType() {
        return LongProperty.class.getSimpleName();
    }

    @Override
    public String getValueType() {
        return Long.class.getName();
    }

    @Override
    public String getUnqualifiedValueType() {
        return "Long";
    }

    @Override
    public SchemaHelper.Type getKey() {
        return SchemaHelper.Type.Long;
    }

    @Override
    public Number parseNumber(ErrorBuffer errorBuffer, String source, String which) {
        try {
            return Long.parseLong(source);
        }
        catch (Throwable t) {
            errorBuffer.add(new InvalidPropertySchemaToken(SchemaNode.class.getSimpleName(), source, "invalid_" + which + "_bound", StringUtils.capitalize((String)which) + " bound must be of type Long."));
            return null;
        }
    }

    @Override
    public String getDefaultValue() {
        return this.getSourceDefaultValue().concat("L");
    }
}

