/*
 * Decompiled with CFR 0.152.
 */
package org.structr.schema.parser;

import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.structr.common.error.ErrorBuffer;
import org.structr.common.error.FrameworkException;
import org.structr.common.error.InvalidPropertySchemaToken;
import org.structr.core.entity.SchemaNode;
import org.structr.core.property.CollectionNotionProperty;
import org.structr.core.property.EntityNotionProperty;
import org.structr.schema.Schema;
import org.structr.schema.SchemaHelper;
import org.structr.schema.parser.PropertyDefinition;
import org.structr.schema.parser.PropertySourceGenerator;

public class NotionPropertyParser
extends PropertySourceGenerator {
    private final Set<String> properties = new LinkedHashSet<String>();
    private boolean isPropertySet = false;
    private boolean isAutocreate = false;
    private String parameters = "";
    private String propertyType = null;
    private String relatedType = null;
    private String baseProperty = null;
    private String multiplicity = null;

    public NotionPropertyParser(ErrorBuffer errorBuffer, String className, PropertyDefinition params) {
        super(errorBuffer, className, params);
    }

    @Override
    public String getPropertyType() {
        return this.propertyType;
    }

    @Override
    public String getValueType() {
        return this.relatedType;
    }

    @Override
    public String getUnqualifiedValueType() {
        return this.relatedType;
    }

    @Override
    public String getPropertyParameters() {
        return this.parameters;
    }

    @Override
    public SchemaHelper.Type getKey() {
        return SchemaHelper.Type.Notion;
    }

    @Override
    public void parseFormatString(Schema entity, String expression) throws FrameworkException {
        if (StringUtils.isBlank((String)expression)) {
            throw new FrameworkException(422, "Empty notion property expression", new InvalidPropertySchemaToken(SchemaNode.class.getSimpleName(), expression, "invalid_property_definition", "Empty notion property expression."));
        }
        StringBuilder buf = new StringBuilder();
        String[] parts = expression.split("[, ]+");
        if (parts.length > 0) {
            boolean isBuiltinProperty = false;
            this.baseProperty = parts[0];
            this.multiplicity = entity.getMultiplicity(this.baseProperty);
            if (this.multiplicity != null) {
                boolean isBoolean;
                this.relatedType = entity.getRelatedType(this.baseProperty);
                switch (this.multiplicity) {
                    case "1X": {
                        isBuiltinProperty = true;
                    }
                    case "1": {
                        this.propertyType = EntityNotionProperty.class.getSimpleName();
                        break;
                    }
                    case "*X": {
                        isBuiltinProperty = true;
                    }
                    case "*": {
                        this.propertyType = CollectionNotionProperty.class.getSimpleName();
                        break;
                    }
                }
                buf.append(", ");
                buf.append(entity.getClassName());
                buf.append(".");
                buf.append(this.baseProperty);
                if (!isBuiltinProperty) {
                    buf.append("Property");
                }
                buf.append(",");
                this.isAutocreate = isBoolean = parts.length == 3 && "true".equals(parts[2].toLowerCase());
                if (parts.length == 2 || isBoolean) {
                    buf.append(" new PropertyNotion(");
                    this.isPropertySet = false;
                } else {
                    buf.append(" new PropertySetNotion(");
                    this.isPropertySet = true;
                }
                for (int i = 1; i < parts.length; ++i) {
                    String propertyName = parts[i];
                    String fullPropertyName = propertyName;
                    if (fullPropertyName.startsWith("_")) {
                        fullPropertyName = fullPropertyName.substring(1) + "Property";
                    }
                    if (!"true".equals(propertyName.toLowerCase()) && !propertyName.contains(".")) {
                        buf.append(this.relatedType);
                        buf.append(".");
                        fullPropertyName = this.relatedType + "." + fullPropertyName;
                    }
                    this.properties.add(fullPropertyName);
                    if (propertyName.startsWith("_")) {
                        propertyName = propertyName.substring(1) + "Property";
                    }
                    buf.append(propertyName);
                    if (i >= parts.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            } else {
                throw new FrameworkException(422, "Invalid notion property expression.", new InvalidPropertySchemaToken(SchemaNode.class.getSimpleName(), expression, "invalid_property_definition", "Invalid notion property expression."));
            }
        }
        this.parameters = buf.toString();
    }

    public boolean isPropertySet() {
        return this.isPropertySet;
    }

    public Set<String> getProperties() {
        return this.properties;
    }

    public boolean isAutocreate() {
        return this.isAutocreate;
    }

    public String getBaseProperty() {
        return this.baseProperty;
    }

    public String getMultiplicity() {
        return this.multiplicity;
    }
}

