/*
 * Decompiled with CFR 0.152.
 */
package org.structr.schema.parser;

import org.apache.commons.lang3.StringUtils;
import org.structr.common.error.ErrorBuffer;
import org.structr.common.error.FrameworkException;
import org.structr.common.error.InvalidPropertySchemaToken;
import org.structr.core.entity.SchemaNode;
import org.structr.schema.Schema;
import org.structr.schema.parser.PropertyDefinition;
import org.structr.schema.parser.PropertySourceGenerator;
import org.structr.schema.parser.Validator;

public abstract class NumericalPropertyParser
extends PropertySourceGenerator {
    private Number lowerBound = null;
    private Number upperBound = null;
    private boolean lowerExclusive = false;
    private boolean upperExclusive = false;

    public NumericalPropertyParser(ErrorBuffer errorBuffer, String className, PropertyDefinition params) {
        super(errorBuffer, className, params);
    }

    public abstract Number parseNumber(ErrorBuffer var1, String var2, String var3);

    @Override
    public String getPropertyParameters() {
        return "";
    }

    @Override
    public void parseFormatString(Schema entity, String expression) throws FrameworkException {
        boolean error = false;
        String rangeFormatErrorMessage = "Range expression must describe a (possibly open-ended) interval, e.g. [10,99] or ]9,100[ for all two-digit integers";
        if (StringUtils.isNotBlank((CharSequence)expression)) {
            if ((expression.startsWith("[") || expression.startsWith("]")) && (expression.endsWith("[") || expression.endsWith("]"))) {
                String range = expression.substring(1, expression.length() - 1);
                String[] parts = range.split(",+");
                if (parts.length == 2) {
                    this.lowerBound = this.parseNumber(this.getErrorBuffer(), parts[0].trim(), "lower");
                    this.upperBound = this.parseNumber(this.getErrorBuffer(), parts[1].trim(), "upper");
                    if (this.lowerBound == null || this.upperBound == null) {
                        error = true;
                    }
                    this.lowerExclusive = expression.startsWith("]");
                    this.upperExclusive = expression.endsWith("[");
                } else {
                    error = true;
                }
                if (!error) {
                    this.addGlobalValidator(new Validator("isValid" + this.getUnqualifiedValueType() + "InRange", this.getClassName(), this.getSourcePropertyName(), expression));
                }
            } else {
                error = true;
            }
        }
        if (error) {
            this.reportError(new InvalidPropertySchemaToken(SchemaNode.class.getSimpleName(), expression, "invalid_range_expression", "Range expression must describe a (possibly open-ended) interval, e.g. [10,99] or ]9,100[ for all two-digit integers"));
        }
    }

    public Number getLowerBound() {
        return this.lowerBound;
    }

    public Number getUpperBound() {
        return this.upperBound;
    }

    public boolean isLowerExclusive() {
        return this.lowerExclusive;
    }

    public boolean isUpperExclusive() {
        return this.upperExclusive;
    }
}

