/*
 * Decompiled with CFR 0.152.
 */
package org.structr.schema.parser;

import org.structr.common.error.ErrorBuffer;
import org.structr.common.error.FrameworkException;
import org.structr.common.error.InvalidPropertySchemaToken;
import org.structr.core.entity.SchemaNode;
import org.structr.core.property.ArrayProperty;
import org.structr.schema.Schema;
import org.structr.schema.SchemaHelper;
import org.structr.schema.parser.PropertyDefinition;
import org.structr.schema.parser.PropertySourceGenerator;

public class StringArrayPropertyParser
extends PropertySourceGenerator {
    public StringArrayPropertyParser(ErrorBuffer errorBuffer, String className, PropertyDefinition params) {
        super(errorBuffer, className, params);
    }

    @Override
    public String getPropertyType() {
        return ArrayProperty.class.getSimpleName().concat("<String>");
    }

    @Override
    public String getValueType() {
        return String[].class.getSimpleName();
    }

    @Override
    public String getUnqualifiedValueType() {
        return "String[]";
    }

    @Override
    public String getPropertyParameters() {
        return ", String.class";
    }

    @Override
    public SchemaHelper.Type getKey() {
        return SchemaHelper.Type.StringArray;
    }

    @Override
    public void parseFormatString(Schema entity, String expression) throws FrameworkException {
        if ("[]".equals(expression)) {
            this.reportError(new InvalidPropertySchemaToken(SchemaNode.class.getSimpleName(), expression, "invalid_validation_expression", "Empty validation expression."));
            return;
        }
    }

    @Override
    public String getDefaultValue() {
        return "\"".concat(this.getSourceDefaultValue()).concat("\"");
    }
}

