/*
 * Decompiled with CFR 0.152.
 */
package org.structr.util;

import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.util.StreamReader;

public abstract class AbstractProcess<T>
implements Callable<T> {
    private static final Logger logger = LoggerFactory.getLogger((String)AbstractProcess.class.getName());
    private final AtomicBoolean running = new AtomicBoolean(true);
    protected SecurityContext securityContext = null;
    private StreamReader stdOut = null;
    private StreamReader stdErr = null;
    private String cmd = null;
    private int exitCode = -1;

    public AbstractProcess(SecurityContext securityContext) {
        this.securityContext = securityContext;
    }

    public abstract StringBuilder getCommandLine();

    public abstract T processExited(int var1);

    public abstract void preprocess();

    @Override
    public T call() {
        try {
            this.preprocess();
            StringBuilder commandLine = this.getCommandLine();
            if (commandLine != null) {
                this.cmd = commandLine.toString();
                String[] args = new String[]{"/bin/sh", "-c", this.cmd};
                logger.info("Executing {}", (Object)this.cmd);
                Process proc = Runtime.getRuntime().exec(args);
                this.stdOut = new StreamReader(proc.getInputStream(), this.running);
                this.stdErr = new StreamReader(proc.getErrorStream(), this.running);
                this.stdOut.start();
                this.stdErr.start();
                this.exitCode = proc.waitFor();
            }
        }
        catch (IOException | InterruptedException ex) {
            logger.warn("", (Throwable)ex);
        }
        this.running.set(false);
        if (this.exitCode != 0) {
            logger.warn("Process {} exited with exit code {}, error stream:\n{}\n", new Object[]{this.cmd, this.exitCode, this.stdErr.getBuffer()});
        }
        return this.processExited(this.exitCode);
    }

    protected String outputStream() {
        return this.stdOut.getBuffer();
    }

    protected String errorStream() {
        return this.stdErr.getBuffer();
    }

    protected int exitCode() {
        return this.exitCode;
    }
}

