/*
 * Decompiled with CFR 0.152.
 */
package org.structr.util;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyingStreamReader
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger((String)CopyingStreamReader.class.getName());
    private InputStream inputStream = null;
    private OutputStream outputStream = null;
    private AtomicBoolean running = null;

    public CopyingStreamReader(InputStream is, OutputStream out, AtomicBoolean running) {
        super("StreamReader");
        this.inputStream = is;
        this.outputStream = out;
        this.running = running;
        this.setDaemon(true);
    }

    @Override
    public void run() {
        while (this.running.get()) {
            try {
                IOUtils.copy((InputStream)this.inputStream, (OutputStream)this.outputStream);
                Thread.sleep(10L);
            }
            catch (Throwable t) {
                logger.warn("", t);
            }
        }
    }
}

