/*
 * Decompiled with CFR 0.152.
 */
package org.structr.util;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamReader
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger((String)StreamReader.class.getName());
    private final Queue<String> queue = new ConcurrentLinkedQueue<String>();
    private BufferedReader reader = null;
    private AtomicBoolean running = null;

    public StreamReader(InputStream is, AtomicBoolean running) {
        super("StreamReader");
        this.reader = new BufferedReader(new InputStreamReader(is));
        this.running = running;
        this.setDaemon(true);
    }

    public String getBuffer() {
        StringBuilder buf = new StringBuilder();
        for (String line : this.queue) {
            buf.append(line);
            buf.append("\n");
        }
        return buf.toString();
    }

    @Override
    public void run() {
        while (this.running.get()) {
            try {
                String line = null;
                do {
                    if ((line = this.reader.readLine()) == null) continue;
                    this.queue.add(line);
                } while (line != null);
                Thread.sleep(10L);
            }
            catch (Throwable t) {
                logger.warn("", t);
            }
        }
    }
}

