/*
 * Decompiled with CFR 0.152.
 */
package org.structr.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.security.CodeSigner;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Base64;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.IOUtils;
import org.codehaus.plexus.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.service.Feature;
import org.structr.api.service.LicenseManager;
import org.structr.common.error.FrameworkException;
import org.structr.core.graph.MaintenanceCommand;
import org.structr.core.graph.NodeServiceCommand;
import org.structr.util.Base64;

public class StructrLicenseManager
implements LicenseManager {
    private static final Logger logger = LoggerFactory.getLogger(LicenseManager.class);
    private static final String Certificate = "MIIDpzCCAo+gAwIBAgIEbgcR/TANBgkqhkiG9w0BAQ0FADCBgzELMAkGA1UEBhMCREUxDzANBgNVBAgTBkhlc3NlbjEaMBgGA1UEBxMRRnJhbmtmdXJ0IGFtIE1haW4xFTATBgNVBAoTDFN0cnVjdHIgR21iSDEUMBIGA1UECxMLRGV2ZWxvcG1lbnQxGjAYBgNVBAMTEUNocmlzdGlhbiBNb3JnbmVyMB4XDTE3MDUxNzExMjExMloXDTI4MDQyOTExMjExMlowgYMxCzAJBgNVBAYTAkRFMQ8wDQYDVQQIEwZIZXNzZW4xGjAYBgNVBAcTEUZyYW5rZnVydCBhbSBNYWluMRUwEwYDVQQKEwxTdHJ1Y3RyIEdtYkgxFDASBgNVBAsTC0RldmVsb3BtZW50MRowGAYDVQQDExFDaHJpc3RpYW4gTW9yZ25lcjCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAI2i0WhHV9OauRZ6viefhuSKOZaKlTvVYi0HLmk99/JlfIvAkkmS3Dlz+xwp9SUUPdfFMvPvMpgwXyfj9HlZGMg6fdSGocZyJpozVSmzlM0D1xJB6MbU1k8lcvI52IYx6gUCa7jQIoPxkwb+8/NP2SXA56RVIsNQFGpb31AwKNFViE5CqCHcF4hQ3uB/rcbxPUQ9t94R51dNLMWw37lKiqpqiHGKYmriBOV9iivdgUFFFA0hNbclnRImXhYuUgCBaPmtjOGDywBfkRs5kbRBixR5V41DOqaFnG5jOKTW+ycLMMmtvHnPt1dHckvYTnnM0YUS9FINbXLoxZBw2hP1mfkCAwEAAaMhMB8wHQYDVR0OBBYEFBM6fjBbxeespRRG87mEHbqzfXCGMA0GCSqGSIb3DQEBDQUAA4IBAQANnACQFo5r8gNK8ULZ5yvndx8Bv3YNbQEtXgHSnaQLWAgIgflGE4GF8/0OwaxVuGxvyCd/ib74vjfCgOJvNe+XOHQQ+6o30JaILar2353QvVS5cqSUHACOyFaBa7ndjgHSYdzabZHdhmpIIv/Tx2whClYdCCLTQi1sYjtXGMJ4FJyyJqjmIjREcPU1KT8etnYQXaTvj2njM26lZVWc7DizsN83b+vL5h2m+z/4I5dAwVGEBMFZ/u7r3lfqJ4h5bVTb6AMJ9gl/lOyob46gH1jNbx5ld53/ADgDFRcMW2vwLiZhay0pNhx1o8vT2VnQUzZxU1G4gnkdtiXN6knFTorl";
    private static final String SignatureAlgorithm = "SHA512WithRSA";
    private static final String DatePattern = "yyyy-MM-dd";
    private static final String KeystoreAlias = "structr";
    private static final String KeyAlgorithm = "RSA";
    private static final String CharSet = "UTF-8";
    private static final String NameKey = "name";
    private static final String DateKey = "date";
    private static final String StartKey = "start";
    private static final String EndKey = "end";
    private static final String EditionKey = "edition";
    private static final String ModulesKey = "modules";
    private static final String MachineKey = "machine";
    private static final String SignatureKey = "key";
    private static final int CommunityMask = 1;
    private static final int BasicMask = 3;
    private static final int SmallBusinessMask = 7;
    private static final int EnterpriseMask = 15;
    private final Set<String> modules = new LinkedHashSet<String>(Arrays.asList("core", "rest", "ui"));
    private final SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
    private Certificate certificate = null;
    private PublicKey publicKey = null;
    private boolean allModulesLicensed = false;
    private boolean licensePresent = false;
    private String edition = "Community";
    private String licensee = null;
    private String startDateString = null;
    private String endDateString = null;
    private int editionMask = 1;

    public StructrLicenseManager(String licenseFileName) {
        logger.info("Host ID is {}", (Object)this.createHash());
        logger.info("Checking Structr license..");
        this.certificate = this.certFromBase64(Certificate);
        this.publicKey = this.certificate.getPublicKey();
        Map<String, String> properties = this.read(licenseFileName);
        if (this.licensePresent && this.isValid(properties)) {
            this.edition = properties.get(EditionKey);
            if (this.edition != null) {
                switch (this.edition) {
                    case "Enterprise": {
                        this.editionMask = 15;
                        break;
                    }
                    case "Small Business": {
                        this.editionMask = 7;
                        break;
                    }
                    case "Basic": {
                        this.editionMask = 3;
                    }
                }
            }
            this.licensee = properties.get(NameKey);
            this.startDateString = properties.get(StartKey);
            this.endDateString = properties.get(EndKey);
            String licensedModules = properties.get(ModulesKey);
            if (licensedModules != null) {
                this.modules.clear();
                if ("*".equals(licensedModules)) {
                    this.allModulesLicensed = true;
                } else if (!"none".equals(licensedModules)) {
                    for (String module : licensedModules.split(",")) {
                        this.modules.add(module.trim());
                    }
                }
            }
        }
        logger.info("Running {} Edition with {}.", (Object)this.edition, (Object)(this.allModulesLicensed ? "all modules" : "modules " + this.modules.toString()));
        if (this.licensee != null) {
            logger.info("Licensed for {}", (Object)this.licensee);
        } else {
            logger.info("Evaluation License");
        }
    }

    public boolean isModuleLicensed(String module) {
        return this.allModulesLicensed || this.modules.contains(module);
    }

    public boolean isEdition(int bitmask) {
        return (this.editionMask & bitmask) > 0;
    }

    public String getEdition() {
        return this.edition;
    }

    public String getLicensee() {
        return this.licensee;
    }

    public String getHardwareFingerprint() {
        return this.createHash();
    }

    public String getStartDate() {
        return this.startDateString;
    }

    public String getEndDate() {
        return this.endDateString;
    }

    public boolean isValid(Feature feature) {
        if (feature != null) {
            String moduleName = feature.getModuleName();
            return moduleName != null && this.isModuleLicensed(moduleName);
        }
        return false;
    }

    public boolean isValid(CodeSigner[] codeSigners) {
        if (codeSigners != null && codeSigners.length > 0) {
            for (CodeSigner codeSigner : codeSigners) {
                for (Certificate certificate : codeSigner.getSignerCertPath().getCertificates()) {
                    try {
                        certificate.verify(this.publicKey);
                        return true;
                    }
                    catch (Throwable throwable) {
                    }
                }
            }
        }
        return false;
    }

    private boolean isValid(Map<String, String> properties) {
        Date startDate;
        if (!this.licensePresent) {
            return false;
        }
        String src = StructrLicenseManager.collect(properties);
        String name = properties.get(NameKey);
        String key = properties.get(SignatureKey);
        String hostId = properties.get(MachineKey);
        String thisHostId = this.createHash();
        String edition = properties.get(EditionKey);
        String modules = properties.get(ModulesKey);
        String dateString = properties.get(DateKey);
        String startDateString = properties.get(StartKey);
        String endDateString = properties.get(EndKey);
        Date now = new Date();
        if (StringUtils.isEmpty((String)key)) {
            logger.error("Unable to read key from license file.");
            return false;
        }
        try {
            byte[] data = src.getBytes(CharSet);
            Signature signer = Signature.getInstance(SignatureAlgorithm);
            byte[] signature = Hex.decodeHex((char[])key.toCharArray());
            signer.initVerify(this.certificate);
            signer.update(data);
            if (!signer.verify(signature)) {
                logger.error("License signature verification failed, license is not valid.");
                return false;
            }
        }
        catch (Throwable t) {
            logger.error("Unable to verify license.", t);
            return false;
        }
        if (StringUtils.isEmpty((String)name)) {
            logger.error("License file doesn't contain licensee name.");
            return false;
        }
        if (StringUtils.isEmpty((String)edition)) {
            logger.error("License file doesn't contain edition.");
            return false;
        }
        if (StringUtils.isEmpty((String)modules)) {
            logger.error("License file doesn't contain modules.");
            return false;
        }
        if (StringUtils.isEmpty((String)hostId)) {
            logger.error("License file doesn't contain host ID.");
            return false;
        }
        if (StringUtils.isEmpty((String)dateString)) {
            logger.error("License file doesn't contain license date.");
            return false;
        }
        if (StringUtils.isEmpty((String)startDateString)) {
            logger.error("License file doesn't contain start date.");
            return false;
        }
        if (StringUtils.isEmpty((String)endDateString)) {
            logger.error("License file doesn't contain end date.");
            return false;
        }
        if (!thisHostId.equals(hostId) && !"*".equals(hostId)) {
            logger.error("Host ID found in license file does not match current host ID.");
            return false;
        }
        if ("*".equals(hostId)) {
            Calendar issuedAtPlusOneMonth = GregorianCalendar.getInstance();
            Calendar cal = GregorianCalendar.getInstance();
            issuedAtPlusOneMonth.setTime(this.parseDate(dateString));
            issuedAtPlusOneMonth.add(2, 1);
            if (cal.after(issuedAtPlusOneMonth)) {
                logger.error("Development license found in license file is not valid any more, license period ended {}.", (Object)this.format.format(issuedAtPlusOneMonth.getTime()));
                return false;
            }
        }
        if ((startDate = this.parseDate(startDateString)) != null && now.before(startDate) && !now.equals(startDate)) {
            logger.error("License found in license file is not yet valid, license period starts {}.", (Object)this.format.format(startDate.getTime()));
            return false;
        }
        Date endDate = this.parseDate(endDateString);
        if (endDate != null && now.after(endDate) && !now.equals(endDate)) {
            logger.error("License found in license file is not valid any more, license period ended {}.", (Object)this.format.format(endDate.getTime()));
            return false;
        }
        return true;
    }

    private Map<String, String> read(String fileName) {
        Base64.Decoder base64Decoder = java.util.Base64.getMimeDecoder();
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(base64Decoder.wrap(new FileInputStream(fileName))));){
            this.licensePresent = true;
            String line = reader.readLine();
            while (line != null) {
                int pos = line.indexOf("=");
                if (pos >= 0) {
                    String key = line.substring(0, pos).trim();
                    String value = line.substring(pos + 1).trim();
                    properties.put(key, value);
                }
                line = reader.readLine();
            }
        }
        catch (FileNotFoundException fnex) {
            this.licensePresent = false;
        }
        catch (IOException ioex) {
            logger.warn("Error reading license file: {}", (Object)ioex.getMessage());
        }
        return properties;
    }

    private Certificate certFromBase64(String src) {
        try {
            byte[] byteKey = Base64.decode(src.getBytes());
            X509EncodedKeySpec key = new X509EncodedKeySpec(byteKey);
            return CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(byteKey));
        }
        catch (Throwable t) {
            logger.warn("Unable to decode public key.", t);
            return null;
        }
    }

    private String toBase64(Key key) {
        try {
            return Base64.encodeToString(key.getEncoded(), true);
        }
        catch (Throwable t) {
            logger.warn("Unable to encode key.", t);
            return null;
        }
    }

    private String createHash() {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            for (NetworkInterface iface : this.getNetworkInterfaces()) {
                try {
                    byte[] hardwareAddress = iface.getHardwareAddress();
                    if (hardwareAddress == null) continue;
                    digest.update(hardwareAddress);
                }
                catch (SocketException socketException) {}
            }
            return Hex.encodeHexString((byte[])digest.digest());
        }
        catch (NoSuchAlgorithmException ex) {
            logger.warn("Unable to create hardware hash.", (Throwable)ex);
            return null;
        }
    }

    private byte[] toBytes(String stringOrNull) {
        if (stringOrNull != null) {
            try {
                return stringOrNull.getBytes(CharSet);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return new byte[0];
    }

    private byte[] toBytes(int value) {
        try {
            return Integer.toString(value).getBytes(CharSet);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new byte[0];
        }
    }

    private Iterable<NetworkInterface> getNetworkInterfaces() {
        LinkedList<NetworkInterface> interfaces = new LinkedList<NetworkInterface>();
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                interfaces.add(enumeration.nextElement());
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return interfaces;
    }

    private Date parseDate(String dateOrNull) {
        if (dateOrNull != null) {
            try {
                return this.alignToDay(this.format.parse(dateOrNull));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return new Date(0L);
    }

    private Date alignToDay(Date date) {
        try {
            return this.format.parse(this.format.format(date));
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readFile(String name) {
        try (FileInputStream is = new FileInputStream(name);){
            String string = IOUtils.toString((InputStream)is, (String)"utf-8");
            return string;
        }
        catch (IOException ioex) {
            logger.warn("Unable to read file.", (Throwable)ioex);
            return null;
        }
    }

    private static PrivateKey privateFromBase64(String src) {
        try {
            byte[] byteKey = Base64.decode(src.getBytes());
            PKCS8EncodedKeySpec key = new PKCS8EncodedKeySpec(byteKey);
            KeyFactory kf = KeyFactory.getInstance(KeyAlgorithm);
            return kf.generatePrivate(key);
        }
        catch (Throwable t) {
            logger.warn("Unable to decode private key.", t);
            return null;
        }
    }

    private static String collect(Map<String, String> properties) {
        StringBuilder buf = new StringBuilder();
        buf.append(properties.get(NameKey));
        buf.append(properties.get(DateKey));
        buf.append(properties.get(StartKey));
        buf.append(properties.get(EndKey));
        buf.append(properties.get(EditionKey));
        buf.append(properties.get(ModulesKey));
        buf.append(properties.get(MachineKey));
        return buf.toString();
    }

    private static void create(String name, String start, String end, String edition, String modules, String hostId, String keystoreFileName, String password, String outputFileName) {
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        SimpleDateFormat format = new SimpleDateFormat(DatePattern);
        properties.put(NameKey, name);
        properties.put(DateKey, format.format(System.currentTimeMillis()));
        properties.put(StartKey, start);
        properties.put(EndKey, end);
        properties.put(EditionKey, edition);
        properties.put(ModulesKey, modules);
        properties.put(MachineKey, hostId);
        StructrLicenseManager.sign(properties, keystoreFileName, password);
        StructrLicenseManager.write(properties, outputFileName);
    }

    private static void sign(Map<String, String> properties, String keystoreFileName, String password) {
        String src = StructrLicenseManager.collect(properties);
        try {
            byte[] data = src.getBytes(CharSet);
            Signature signer = Signature.getInstance(SignatureAlgorithm);
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            try (FileInputStream is = new FileInputStream(keystoreFileName);){
                keyStore.load(is, password.toCharArray());
                Key key = keyStore.getKey(KeystoreAlias, password.toCharArray());
                signer.initSign((PrivateKey)key);
                signer.update(data);
                properties.put(SignatureKey, Hex.encodeHexString((byte[])signer.sign()));
            }
        }
        catch (Throwable t) {
            logger.warn("Unable to sign license.", t);
        }
    }

    private static void write(Map<String, String> properties, String fileName) {
        Base64.Encoder base64Encoder = java.util.Base64.getMimeEncoder();
        try (OutputStreamWriter writer = new OutputStreamWriter(base64Encoder.wrap(new FileOutputStream(fileName)));){
            properties.forEach((key, value) -> {
                try {
                    writer.write((String)key);
                    writer.write(" = ");
                    writer.write((String)value);
                    writer.write("\n");
                }
                catch (IOException ioex) {
                    ioex.printStackTrace();
                }
            });
        }
        catch (IOException ioex) {
            logger.warn("Unable to write file.", (Throwable)ioex);
        }
    }

    public static class CreateLicenseCommand
    extends NodeServiceCommand
    implements MaintenanceCommand {
        @Override
        public void execute(Map<String, Object> attributes) throws FrameworkException {
            String name = (String)attributes.get(StructrLicenseManager.NameKey);
            String start = (String)attributes.get(StructrLicenseManager.StartKey);
            String end = (String)attributes.get(StructrLicenseManager.EndKey);
            String edition = (String)attributes.get(StructrLicenseManager.EditionKey);
            String modules = (String)attributes.get(StructrLicenseManager.ModulesKey);
            String hostId = (String)attributes.get(StructrLicenseManager.MachineKey);
            String keystore = (String)attributes.get("keystore");
            String password = (String)attributes.get("password");
            String outFile = (String)attributes.get("outFile");
            if (outFile == null) {
                outFile = "license.key";
            }
            if (name == null || start == null || end == null || edition == null || modules == null || hostId == null || keystore == null || password == null) {
                logger.warn("Cannot create license file, missing parameter. Parameters are: name, start, end, edition, modules, machine, keystore, password, outFile (optional).");
            } else {
                StructrLicenseManager.create(name, start, end, edition, modules, hostId, keystore, password, outFile);
                logger.info("Successfully created license file {}.", (Object)outFile);
            }
        }

        @Override
        public boolean requiresEnclosingTransaction() {
            return false;
        }

        @Override
        public boolean requiresFlushingOfCaches() {
            return false;
        }
    }
}

