/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.roster;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.AbstractConnectionClosedListener;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.ExceptionCallback;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPConnectionRegistry;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.filter.StanzaTypeFilter;
import org.jivesoftware.smack.iqrequest.AbstractIqRequestHandler;
import org.jivesoftware.smack.iqrequest.IQRequestHandler;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.roster.RosterEntries;
import org.jivesoftware.smack.roster.RosterEntry;
import org.jivesoftware.smack.roster.RosterGroup;
import org.jivesoftware.smack.roster.RosterListener;
import org.jivesoftware.smack.roster.RosterLoadedListener;
import org.jivesoftware.smack.roster.packet.RosterPacket;
import org.jivesoftware.smack.roster.rosterstore.RosterStore;
import org.jivesoftware.smack.util.Objects;
import org.jxmpp.util.XmppStringUtils;

public class Roster
extends Manager {
    private static final Logger LOGGER = Logger.getLogger(Roster.class.getName());
    private static final Map<XMPPConnection, Roster> INSTANCES;
    private static final StanzaFilter PRESENCE_PACKET_FILTER;
    private static boolean rosterLoadedAtLoginDefault;
    private static SubscriptionMode defaultSubscriptionMode;
    private RosterStore rosterStore;
    private final Map<String, RosterGroup> groups = new ConcurrentHashMap<String, RosterGroup>();
    private final Map<String, RosterEntry> entries = new ConcurrentHashMap<String, RosterEntry>();
    private final Set<RosterEntry> unfiledEntries = new CopyOnWriteArraySet<RosterEntry>();
    private final Set<RosterListener> rosterListeners = new LinkedHashSet<RosterListener>();
    private final Map<String, Map<String, Presence>> presenceMap = new ConcurrentHashMap<String, Map<String, Presence>>();
    private final Set<RosterLoadedListener> rosterLoadedListeners = new LinkedHashSet<RosterLoadedListener>();
    private final Object rosterListenersAndEntriesLock = new Object();
    private boolean loaded = false;
    private final PresencePacketListener presencePacketListener = new PresencePacketListener();
    private boolean rosterLoadedAtLogin = rosterLoadedAtLoginDefault;
    private SubscriptionMode subscriptionMode = Roster.getDefaultSubscriptionMode();

    public static synchronized Roster getInstanceFor(XMPPConnection connection) {
        Roster roster = INSTANCES.get(connection);
        if (roster == null) {
            roster = new Roster(connection);
            INSTANCES.put(connection, roster);
        }
        return roster;
    }

    public static SubscriptionMode getDefaultSubscriptionMode() {
        return defaultSubscriptionMode;
    }

    public static void setDefaultSubscriptionMode(SubscriptionMode subscriptionMode) {
        defaultSubscriptionMode = subscriptionMode;
    }

    private Roster(XMPPConnection connection) {
        super(connection);
        connection.registerIQRequestHandler((IQRequestHandler)new RosterPushListener());
        connection.addSyncStanzaListener((StanzaListener)this.presencePacketListener, PRESENCE_PACKET_FILTER);
        connection.addConnectionListener((ConnectionListener)new AbstractConnectionClosedListener(){

            public void authenticated(XMPPConnection connection, boolean resumed) {
                if (connection.isAnonymous()) {
                    return;
                }
                if (!Roster.this.isRosterLoadedAtLogin()) {
                    return;
                }
                if (resumed) {
                    return;
                }
                try {
                    Roster.this.reload();
                }
                catch (SmackException e) {
                    LOGGER.log(Level.SEVERE, "Could not reload Roster", e);
                    return;
                }
            }

            public void connectionTerminated() {
                Roster.this.setOfflinePresencesAndResetLoaded();
            }
        });
        if (connection.isAuthenticated()) {
            try {
                this.reload();
            }
            catch (SmackException e) {
                LOGGER.log(Level.SEVERE, "Could not reload Roster", e);
            }
        }
    }

    public SubscriptionMode getSubscriptionMode() {
        return this.subscriptionMode;
    }

    public void setSubscriptionMode(SubscriptionMode subscriptionMode) {
        this.subscriptionMode = subscriptionMode;
    }

    public void reload() throws SmackException.NotLoggedInException, SmackException.NotConnectedException {
        XMPPConnection connection = this.connection();
        if (!connection.isAuthenticated()) {
            throw new SmackException.NotLoggedInException();
        }
        if (connection.isAnonymous()) {
            throw new IllegalStateException("Anonymous users can't have a roster.");
        }
        RosterPacket packet = new RosterPacket();
        if (this.rosterStore != null && this.isRosterVersioningSupported()) {
            packet.setVersion(this.rosterStore.getRosterVersion());
        }
        connection.sendIqWithResponseCallback((IQ)packet, (StanzaListener)new RosterResultListener(), new ExceptionCallback(){

            public void processException(Exception exception) {
                LOGGER.log(Level.SEVERE, "Exception reloading roster", exception);
            }
        });
    }

    public void reloadAndWait() throws SmackException.NotLoggedInException, SmackException.NotConnectedException {
        this.reload();
        this.waitUntilLoaded();
    }

    public boolean setRosterStore(RosterStore rosterStore) {
        this.rosterStore = rosterStore;
        try {
            this.reload();
        }
        catch (SmackException.NotConnectedException | SmackException.NotLoggedInException e) {
            LOGGER.log(Level.FINER, "Could not reload roster", e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean waitUntilLoaded() {
        XMPPConnection connection = this.connection();
        while (!this.loaded) {
            long waitTime = connection.getPacketReplyTimeout();
            long start = System.currentTimeMillis();
            if (waitTime <= 0L) break;
            try {
                Roster roster = this;
                synchronized (roster) {
                    if (!this.loaded) {
                        ((Object)((Object)this)).wait(waitTime);
                    }
                }
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.FINE, "interrupted", e);
                break;
            }
            long now = System.currentTimeMillis();
            waitTime -= now - start;
            start = now;
        }
        return this.isLoaded();
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addRosterListener(RosterListener rosterListener) {
        Object object = this.rosterListenersAndEntriesLock;
        synchronized (object) {
            return this.rosterListeners.add(rosterListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeRosterListener(RosterListener rosterListener) {
        Object object = this.rosterListenersAndEntriesLock;
        synchronized (object) {
            return this.rosterListeners.remove(rosterListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addRosterLoadedListener(RosterLoadedListener rosterLoadedListener) {
        RosterLoadedListener rosterLoadedListener2 = rosterLoadedListener;
        synchronized (rosterLoadedListener2) {
            return this.rosterLoadedListeners.add(rosterLoadedListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeRosterLoadedListener(RosterLoadedListener rosterLoadedListener) {
        RosterLoadedListener rosterLoadedListener2 = rosterLoadedListener;
        synchronized (rosterLoadedListener2) {
            return this.rosterLoadedListeners.remove(rosterLoadedListener);
        }
    }

    public RosterGroup createGroup(String name) {
        XMPPConnection connection = this.connection();
        if (connection.isAnonymous()) {
            throw new IllegalStateException("Anonymous users can't have a roster.");
        }
        if (this.groups.containsKey(name)) {
            return this.groups.get(name);
        }
        RosterGroup group = new RosterGroup(name, connection);
        this.groups.put(name, group);
        return group;
    }

    public void createEntry(String user, String name, String[] groups) throws SmackException.NotLoggedInException, SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        XMPPConnection connection = this.connection();
        if (!connection.isAuthenticated()) {
            throw new SmackException.NotLoggedInException();
        }
        if (connection.isAnonymous()) {
            throw new IllegalStateException("Anonymous users can't have a roster.");
        }
        RosterPacket rosterPacket = new RosterPacket();
        rosterPacket.setType(IQ.Type.set);
        RosterPacket.Item item = new RosterPacket.Item(user, name);
        if (groups != null) {
            for (String group : groups) {
                if (group == null || group.trim().length() <= 0) continue;
                item.addGroupName(group);
            }
        }
        rosterPacket.addRosterItem(item);
        connection.createPacketCollectorAndSend((IQ)rosterPacket).nextResultOrThrow();
        Presence presencePacket = new Presence(Presence.Type.subscribe);
        presencePacket.setTo(user);
        connection.sendStanza((Stanza)presencePacket);
    }

    public void removeEntry(RosterEntry entry) throws SmackException.NotLoggedInException, SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        XMPPConnection connection = this.connection();
        if (!connection.isAuthenticated()) {
            throw new SmackException.NotLoggedInException();
        }
        if (connection.isAnonymous()) {
            throw new IllegalStateException("Anonymous users can't have a roster.");
        }
        if (!this.entries.containsKey(entry.getUser())) {
            return;
        }
        RosterPacket packet = new RosterPacket();
        packet.setType(IQ.Type.set);
        RosterPacket.Item item = RosterEntry.toRosterItem(entry);
        item.setItemType(RosterPacket.ItemType.remove);
        packet.addRosterItem(item);
        connection.createPacketCollectorAndSend((IQ)packet).nextResultOrThrow();
    }

    public int getEntryCount() {
        return this.getEntries().size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getEntriesAndAddListener(RosterListener rosterListener, RosterEntries rosterEntries) {
        Objects.requireNonNull((Object)rosterListener, (String)"listener must not be null");
        Objects.requireNonNull((Object)rosterEntries, (String)"rosterEntries must not be null");
        Object object = this.rosterListenersAndEntriesLock;
        synchronized (object) {
            rosterEntries.rosterEntires(this.entries.values());
            this.addRosterListener(rosterListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<RosterEntry> getEntries() {
        HashSet<RosterEntry> allEntries;
        Object object = this.rosterListenersAndEntriesLock;
        synchronized (object) {
            allEntries = new HashSet<RosterEntry>(this.entries.size());
            for (RosterEntry entry : this.entries.values()) {
                allEntries.add(entry);
            }
        }
        return allEntries;
    }

    public int getUnfiledEntryCount() {
        return this.unfiledEntries.size();
    }

    public Set<RosterEntry> getUnfiledEntries() {
        return Collections.unmodifiableSet(this.unfiledEntries);
    }

    public RosterEntry getEntry(String user) {
        if (user == null) {
            return null;
        }
        String key = this.getMapKey(user);
        return this.entries.get(key);
    }

    public boolean contains(String user) {
        return this.getEntry(user) != null;
    }

    public RosterGroup getGroup(String name) {
        return this.groups.get(name);
    }

    public int getGroupCount() {
        return this.groups.size();
    }

    public Collection<RosterGroup> getGroups() {
        return Collections.unmodifiableCollection(this.groups.values());
    }

    public Presence getPresence(String user) {
        String key = this.getMapKey(XmppStringUtils.parseBareJid((String)user));
        Map<String, Presence> userPresences = this.presenceMap.get(key);
        if (userPresences == null) {
            Presence presence = new Presence(Presence.Type.unavailable);
            presence.setFrom(user);
            return presence;
        }
        Presence presence = null;
        Presence unavailable = null;
        for (String resource : userPresences.keySet()) {
            Presence.Mode presenceMode;
            Presence p = userPresences.get(resource);
            if (!p.isAvailable()) {
                unavailable = p;
                continue;
            }
            if (presence == null || p.getPriority() > presence.getPriority()) {
                presence = p;
                continue;
            }
            if (p.getPriority() != presence.getPriority()) continue;
            Presence.Mode pMode = p.getMode();
            if (pMode == null) {
                pMode = Presence.Mode.available;
            }
            if ((presenceMode = presence.getMode()) == null) {
                presenceMode = Presence.Mode.available;
            }
            if (pMode.compareTo((Enum)presenceMode) >= 0) continue;
            presence = p;
        }
        if (presence == null) {
            if (unavailable != null) {
                return unavailable.clone();
            }
            presence = new Presence(Presence.Type.unavailable);
            presence.setFrom(user);
            return presence;
        }
        return presence.clone();
    }

    public Presence getPresenceResource(String userWithResource) {
        String key = this.getMapKey(userWithResource);
        String resource = XmppStringUtils.parseResource((String)userWithResource);
        Map<String, Presence> userPresences = this.presenceMap.get(key);
        if (userPresences == null) {
            Presence presence = new Presence(Presence.Type.unavailable);
            presence.setFrom(userWithResource);
            return presence;
        }
        Presence presence = userPresences.get(resource);
        if (presence == null) {
            presence = new Presence(Presence.Type.unavailable);
            presence.setFrom(userWithResource);
            return presence;
        }
        return presence.clone();
    }

    public List<Presence> getAllPresences(String bareJid) {
        ArrayList<Presence> res;
        Map<String, Presence> userPresences = this.presenceMap.get(this.getMapKey(bareJid));
        if (userPresences == null) {
            Presence unavailable = new Presence(Presence.Type.unavailable);
            unavailable.setFrom(bareJid);
            res = new ArrayList<Presence>(Arrays.asList(unavailable));
        } else {
            res = new ArrayList<Presence>(userPresences.values().size());
            for (Presence presence : userPresences.values()) {
                res.add(presence.clone());
            }
        }
        return res;
    }

    public List<Presence> getAvailablePresences(String bareJid) {
        List<Presence> allPresences = this.getAllPresences(bareJid);
        ArrayList<Presence> res = new ArrayList<Presence>(allPresences.size());
        for (Presence presence : allPresences) {
            if (!presence.isAvailable()) continue;
            res.add(presence);
        }
        return res;
    }

    public List<Presence> getPresences(String user) {
        List<Presence> res;
        String key = this.getMapKey(user);
        Map<String, Presence> userPresences = this.presenceMap.get(key);
        if (userPresences == null) {
            Presence presence = new Presence(Presence.Type.unavailable);
            presence.setFrom(user);
            res = Arrays.asList(presence);
        } else {
            ArrayList<Presence> answer = new ArrayList<Presence>();
            Presence unavailable = null;
            for (Presence presence : userPresences.values()) {
                if (presence.isAvailable()) {
                    answer.add(presence.clone());
                    continue;
                }
                unavailable = presence;
            }
            if (!answer.isEmpty()) {
                res = answer;
            } else if (unavailable != null) {
                res = Arrays.asList(unavailable.clone());
            } else {
                Presence presence = new Presence(Presence.Type.unavailable);
                presence.setFrom(user);
                res = Arrays.asList(presence);
            }
        }
        return res;
    }

    public boolean isSubscribedToMyPresence(String jid) {
        if (this.connection().getServiceName().equals(jid)) {
            return true;
        }
        RosterEntry entry = this.getEntry(jid);
        if (entry == null) {
            return false;
        }
        switch (entry.getType()) {
            case from: 
            case both: {
                return true;
            }
        }
        return false;
    }

    public void setRosterLoadedAtLogin(boolean rosterLoadedAtLogin) {
        this.rosterLoadedAtLogin = rosterLoadedAtLogin;
    }

    public boolean isRosterLoadedAtLogin() {
        return this.rosterLoadedAtLogin;
    }

    RosterStore getRosterStore() {
        return this.rosterStore;
    }

    private String getMapKey(String user) {
        if (user == null) {
            return null;
        }
        if (this.entries.containsKey(user)) {
            return user;
        }
        String key = XmppStringUtils.parseBareJid((String)user);
        return key.toLowerCase(Locale.US);
    }

    private void setOfflinePresencesAndResetLoaded() {
        for (String user : this.presenceMap.keySet()) {
            Map<String, Presence> resources = this.presenceMap.get(user);
            if (resources == null) continue;
            for (String resource : resources.keySet()) {
                Presence packetUnavailable = new Presence(Presence.Type.unavailable);
                packetUnavailable.setFrom(user + "/" + resource);
                try {
                    this.presencePacketListener.processPacket((Stanza)packetUnavailable);
                }
                catch (SmackException.NotConnectedException e) {
                    throw new IllegalStateException("presencePakcetListener should never throw a NotConnectedException when processPacket is called with a presence of type unavailable", e);
                }
            }
        }
        this.loaded = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireRosterChangedEvent(Collection<String> addedEntries, Collection<String> updatedEntries, Collection<String> deletedEntries) {
        Object object = this.rosterListenersAndEntriesLock;
        synchronized (object) {
            for (RosterListener listener : this.rosterListeners) {
                if (!addedEntries.isEmpty()) {
                    listener.entriesAdded(addedEntries);
                }
                if (!updatedEntries.isEmpty()) {
                    listener.entriesUpdated(updatedEntries);
                }
                if (deletedEntries.isEmpty()) continue;
                listener.entriesDeleted(deletedEntries);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireRosterPresenceEvent(Presence presence) {
        Object object = this.rosterListenersAndEntriesLock;
        synchronized (object) {
            for (RosterListener listener : this.rosterListeners) {
                listener.presenceChanged(presence);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addUpdateEntry(Collection<String> addedEntries, Collection<String> updatedEntries, Collection<String> unchangedEntries, RosterPacket.Item item, RosterEntry entry) {
        RosterEntry oldEntry;
        Object object = this.rosterListenersAndEntriesLock;
        synchronized (object) {
            oldEntry = this.entries.put(item.getUser(), entry);
        }
        if (oldEntry == null) {
            addedEntries.add(item.getUser());
        } else {
            RosterPacket.Item oldItem = RosterEntry.toRosterItem(oldEntry);
            if (!oldEntry.equalsDeep((Object)entry) || !item.getGroupNames().equals(oldItem.getGroupNames())) {
                updatedEntries.add(item.getUser());
            } else {
                unchangedEntries.add(item.getUser());
            }
        }
        if (item.getGroupNames().isEmpty()) {
            this.unfiledEntries.add(entry);
        } else {
            this.unfiledEntries.remove((Object)entry);
        }
        ArrayList<String> newGroupNames = new ArrayList<String>();
        for (String groupName : item.getGroupNames()) {
            newGroupNames.add(groupName);
            RosterGroup group = this.getGroup(groupName);
            if (group == null) {
                group = this.createGroup(groupName);
                this.groups.put(groupName, group);
            }
            group.addEntryLocal(entry);
        }
        ArrayList<String> oldGroupNames = new ArrayList<String>();
        for (RosterGroup group : this.getGroups()) {
            oldGroupNames.add(group.getName());
        }
        oldGroupNames.removeAll(newGroupNames);
        for (String groupName : oldGroupNames) {
            RosterGroup group = this.getGroup(groupName);
            group.removeEntryLocal(entry);
            if (group.getEntryCount() != 0) continue;
            this.groups.remove(groupName);
        }
    }

    private void deleteEntry(Collection<String> deletedEntries, RosterEntry entry) {
        String user = entry.getUser();
        this.entries.remove(user);
        this.unfiledEntries.remove((Object)entry);
        this.presenceMap.remove(XmppStringUtils.parseBareJid((String)user));
        deletedEntries.add(user);
        for (Map.Entry<String, RosterGroup> e : this.groups.entrySet()) {
            RosterGroup group = e.getValue();
            group.removeEntryLocal(entry);
            if (group.getEntryCount() != 0) continue;
            this.groups.remove(e.getKey());
        }
    }

    private void removeEmptyGroups() {
        for (RosterGroup group : this.getGroups()) {
            if (group.getEntryCount() != 0) continue;
            this.groups.remove(group.getName());
        }
    }

    private static boolean hasValidSubscriptionType(RosterPacket.Item item) {
        switch (item.getItemType()) {
            case from: 
            case both: 
            case none: 
            case to: {
                return true;
            }
        }
        return false;
    }

    public boolean isRosterVersioningSupported() {
        return this.connection().hasFeature("ver", "urn:xmpp:features:rosterver");
    }

    static {
        XMPPConnectionRegistry.addConnectionCreationListener((ConnectionCreationListener)new ConnectionCreationListener(){

            public void connectionCreated(XMPPConnection connection) {
                Roster.getInstanceFor(connection);
            }
        });
        INSTANCES = new WeakHashMap<XMPPConnection, Roster>();
        PRESENCE_PACKET_FILTER = StanzaTypeFilter.PRESENCE;
        rosterLoadedAtLoginDefault = true;
        defaultSubscriptionMode = SubscriptionMode.accept_all;
    }

    private class RosterPushListener
    extends AbstractIqRequestHandler {
        private RosterPushListener() {
            super("query", "jabber:iq:roster", IQ.Type.set, IQRequestHandler.Mode.sync);
        }

        public IQ handleIQRequest(IQ iqRequest) {
            XMPPConnection connection = Roster.this.connection();
            RosterPacket rosterPacket = (RosterPacket)iqRequest;
            String jid = XmppStringUtils.parseBareJid((String)connection.getUser());
            String from = rosterPacket.getFrom();
            if (from != null && !from.equals(jid)) {
                LOGGER.warning("Ignoring roster push with a non matching 'from' ourJid='" + jid + "' from='" + from + "'");
                return IQ.createErrorResponse((IQ)iqRequest, (XMPPError)new XMPPError(XMPPError.Condition.service_unavailable));
            }
            List<RosterPacket.Item> items = rosterPacket.getRosterItems();
            if (items.size() != 1) {
                LOGGER.warning("Ignoring roster push with not exaclty one entry. size=" + items.size());
                return IQ.createErrorResponse((IQ)iqRequest, (XMPPError)new XMPPError(XMPPError.Condition.bad_request));
            }
            ArrayList addedEntries = new ArrayList();
            ArrayList updatedEntries = new ArrayList();
            ArrayList deletedEntries = new ArrayList();
            ArrayList unchangedEntries = new ArrayList();
            RosterPacket.Item item = (RosterPacket.Item)items.iterator().next();
            RosterEntry entry = new RosterEntry(item.getUser(), item.getName(), item.getItemType(), item.getItemStatus(), Roster.this, connection);
            String version = rosterPacket.getVersion();
            if (item.getItemType().equals((Object)RosterPacket.ItemType.remove)) {
                Roster.this.deleteEntry(deletedEntries, entry);
                if (Roster.this.rosterStore != null) {
                    Roster.this.rosterStore.removeEntry(entry.getUser(), version);
                }
            } else if (Roster.hasValidSubscriptionType(item)) {
                Roster.this.addUpdateEntry(addedEntries, updatedEntries, unchangedEntries, item, entry);
                if (Roster.this.rosterStore != null) {
                    Roster.this.rosterStore.addEntry(item, version);
                }
            }
            Roster.this.removeEmptyGroups();
            Roster.this.fireRosterChangedEvent(addedEntries, updatedEntries, deletedEntries);
            return IQ.createResultIQ((IQ)rosterPacket);
        }
    }

    private class RosterResultListener
    implements StanzaListener {
        private RosterResultListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processPacket(Stanza packet) {
            Object rosterPacket;
            XMPPConnection connection = Roster.this.connection();
            LOGGER.fine("RosterResultListener received stanza");
            ArrayList addedEntries = new ArrayList();
            ArrayList updatedEntries = new ArrayList();
            ArrayList deletedEntries = new ArrayList();
            ArrayList unchangedEntries = new ArrayList();
            if (packet instanceof RosterPacket) {
                rosterPacket = (RosterPacket)packet;
                ArrayList<RosterPacket.Item> validItems = new ArrayList<RosterPacket.Item>();
                for (RosterPacket.Item item : ((RosterPacket)((Object)rosterPacket)).getRosterItems()) {
                    if (!Roster.hasValidSubscriptionType(item)) continue;
                    validItems.add(item);
                }
                for (RosterPacket.Item item : validItems) {
                    RosterEntry entry = new RosterEntry(item.getUser(), item.getName(), item.getItemType(), item.getItemStatus(), Roster.this, connection);
                    Roster.this.addUpdateEntry(addedEntries, updatedEntries, unchangedEntries, item, entry);
                }
                HashSet<String> toDelete = new HashSet<String>();
                for (RosterEntry entry : Roster.this.entries.values()) {
                    toDelete.add(entry.getUser());
                }
                toDelete.removeAll(addedEntries);
                toDelete.removeAll(updatedEntries);
                toDelete.removeAll(unchangedEntries);
                for (String user : toDelete) {
                    Roster.this.deleteEntry(deletedEntries, (RosterEntry)((Object)Roster.this.entries.get(user)));
                }
                if (Roster.this.rosterStore != null) {
                    String string = ((RosterPacket)((Object)rosterPacket)).getVersion();
                    Roster.this.rosterStore.resetEntries(validItems, string);
                }
                Roster.this.removeEmptyGroups();
            } else {
                for (RosterPacket.Item item : Roster.this.rosterStore.getEntries()) {
                    RosterEntry entry = new RosterEntry(item.getUser(), item.getName(), item.getItemType(), item.getItemStatus(), Roster.this, connection);
                    Roster.this.addUpdateEntry(addedEntries, updatedEntries, unchangedEntries, item, entry);
                }
            }
            Roster.this.loaded = true;
            rosterPacket = Roster.this;
            synchronized (rosterPacket) {
                ((Object)((Object)Roster.this)).notifyAll();
            }
            Roster.this.fireRosterChangedEvent(addedEntries, updatedEntries, deletedEntries);
            try {
                rosterPacket = Roster.this.rosterLoadedListeners;
                synchronized (rosterPacket) {
                    for (RosterLoadedListener rosterLoadedListener : Roster.this.rosterLoadedListeners) {
                        rosterLoadedListener.onRosterLoaded(Roster.this);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "RosterLoadedListener threw exception", e);
            }
        }
    }

    private class PresencePacketListener
    implements StanzaListener {
        private PresencePacketListener() {
        }

        private Map<String, Presence> getUserPresences(String key) {
            ConcurrentHashMap userPresences = (ConcurrentHashMap)Roster.this.presenceMap.get(key);
            if (userPresences == null) {
                userPresences = new ConcurrentHashMap();
                Roster.this.presenceMap.put(key, userPresences);
            }
            return userPresences;
        }

        public void processPacket(Stanza packet) throws SmackException.NotConnectedException {
            XMPPConnection connection = Roster.this.connection();
            Presence presence = (Presence)packet;
            String from = presence.getFrom();
            String key = Roster.this.getMapKey(from);
            Presence response = null;
            switch (presence.getType()) {
                case available: {
                    Map<String, Presence> userPresences = this.getUserPresences(key);
                    userPresences.remove("");
                    userPresences.put(XmppStringUtils.parseResource((String)from), presence);
                    if (!Roster.this.entries.containsKey(key)) break;
                    Roster.this.fireRosterPresenceEvent(presence);
                    break;
                }
                case unavailable: {
                    if ("".equals(XmppStringUtils.parseResource((String)from))) {
                        Map<String, Presence> userPresences = this.getUserPresences(key);
                        userPresences.put("", presence);
                    } else if (Roster.this.presenceMap.get(key) != null) {
                        Map userPresences = (Map)Roster.this.presenceMap.get(key);
                        userPresences.put(XmppStringUtils.parseResource((String)from), presence);
                    }
                    if (!Roster.this.entries.containsKey(key)) break;
                    Roster.this.fireRosterPresenceEvent(presence);
                    break;
                }
                case subscribe: {
                    switch (Roster.this.subscriptionMode) {
                        case accept_all: {
                            response = new Presence(Presence.Type.subscribed);
                            break;
                        }
                        case reject_all: {
                            response = new Presence(Presence.Type.unsubscribed);
                            break;
                        }
                    }
                    if (response == null) break;
                    response.setTo(presence.getFrom());
                    connection.sendStanza((Stanza)response);
                    break;
                }
                case unsubscribe: {
                    if (Roster.this.subscriptionMode == SubscriptionMode.manual) break;
                    response = new Presence(Presence.Type.unsubscribed);
                    response.setTo(presence.getFrom());
                    connection.sendStanza((Stanza)response);
                    break;
                }
                case error: {
                    if (!"".equals(XmppStringUtils.parseResource((String)from))) break;
                    Map<String, Presence> userPresences = this.getUserPresences(key);
                    userPresences.clear();
                    userPresences.put("", presence);
                    if (!Roster.this.entries.containsKey(key)) break;
                    Roster.this.fireRosterPresenceEvent(presence);
                    break;
                }
            }
        }
    }

    public static enum SubscriptionMode {
        accept_all,
        reject_all,
        manual;

    }
}

