/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.roster.rosterstore;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.roster.packet.RosterPacket;
import org.jivesoftware.smack.roster.rosterstore.RosterStore;
import org.jivesoftware.smack.util.FileUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smack.util.stringencoder.Base32;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class DirectoryRosterStore
implements RosterStore {
    private final File fileDir;
    private static final String ENTRY_PREFIX = "entry-";
    private static final String VERSION_FILE_NAME = "__version__";
    private static final String STORE_ID = "DEFAULT_ROSTER_STORE";
    private static final Logger LOGGER = Logger.getLogger(DirectoryRosterStore.class.getName());
    private static final FileFilter rosterDirFilter = new FileFilter(){

        @Override
        public boolean accept(File file) {
            String name = file.getName();
            return name.startsWith(DirectoryRosterStore.ENTRY_PREFIX);
        }
    };

    private DirectoryRosterStore(File baseDir) {
        this.fileDir = baseDir;
    }

    public static DirectoryRosterStore init(File baseDir) {
        DirectoryRosterStore store = new DirectoryRosterStore(baseDir);
        if (store.setRosterVersion("")) {
            return store;
        }
        return null;
    }

    public static DirectoryRosterStore open(File baseDir) {
        DirectoryRosterStore store = new DirectoryRosterStore(baseDir);
        String s = FileUtils.readFile((File)store.getVersionFile());
        if (s != null && s.startsWith("DEFAULT_ROSTER_STORE\n")) {
            return store;
        }
        return null;
    }

    private File getVersionFile() {
        return new File(this.fileDir, VERSION_FILE_NAME);
    }

    public List<RosterPacket.Item> getEntries() {
        ArrayList<RosterPacket.Item> entries = new ArrayList<RosterPacket.Item>();
        for (File file : this.fileDir.listFiles(rosterDirFilter)) {
            RosterPacket.Item entry = this.readEntry(file);
            if (entry == null) {
                this.log("Roster store file '" + file + "' is invalid.");
                continue;
            }
            entries.add(entry);
        }
        return entries;
    }

    @Override
    public RosterPacket.Item getEntry(String bareJid) {
        return this.readEntry(this.getBareJidFile(bareJid));
    }

    @Override
    public String getRosterVersion() {
        String s = FileUtils.readFile((File)this.getVersionFile());
        if (s == null) {
            return null;
        }
        String[] lines = s.split("\n", 2);
        if (lines.length < 2) {
            return null;
        }
        return lines[1];
    }

    private boolean setRosterVersion(String version) {
        return FileUtils.writeFile((File)this.getVersionFile(), (String)("DEFAULT_ROSTER_STORE\n" + version));
    }

    @Override
    public boolean addEntry(RosterPacket.Item item, String version) {
        return this.addEntryRaw(item) && this.setRosterVersion(version);
    }

    @Override
    public boolean removeEntry(String bareJid, String version) {
        return this.getBareJidFile(bareJid).delete() && this.setRosterVersion(version);
    }

    @Override
    public boolean resetEntries(Collection<RosterPacket.Item> items, String version) {
        for (File file : this.fileDir.listFiles(rosterDirFilter)) {
            file.delete();
        }
        for (RosterPacket.Item item : items) {
            if (this.addEntryRaw(item)) continue;
            return false;
        }
        return this.setRosterVersion(version);
    }

    private RosterPacket.Item readEntry(File file) {
        String s = FileUtils.readFile((File)file);
        if (s == null) {
            return null;
        }
        String user = null;
        String name = null;
        String type = null;
        String status = null;
        ArrayList<String> groupNames = new ArrayList<String>();
        try {
            XmlPullParser parser = XmlPullParserFactory.newInstance().newPullParser();
            parser.setInput((Reader)new StringReader(s));
            boolean done = false;
            while (!done) {
                int eventType = parser.next();
                String parserName = parser.getName();
                if (eventType == 2) {
                    if (parserName.equals("item")) {
                        status = null;
                        type = null;
                        name = null;
                        user = null;
                        continue;
                    }
                    if (parserName.equals("user")) {
                        parser.next();
                        user = parser.getText();
                        continue;
                    }
                    if (parserName.equals("name")) {
                        parser.next();
                        name = parser.getText();
                        continue;
                    }
                    if (parserName.equals("type")) {
                        parser.next();
                        type = parser.getText();
                        continue;
                    }
                    if (parserName.equals("status")) {
                        parser.next();
                        status = parser.getText();
                        continue;
                    }
                    if (!parserName.equals("group")) continue;
                    parser.next();
                    parser.next();
                    String group = parser.getText();
                    if (group != null) {
                        groupNames.add(group);
                        continue;
                    }
                    this.log("Invalid group entry in store entry file " + file);
                    continue;
                }
                if (eventType != 3 || !parserName.equals("item")) continue;
                done = true;
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "readEntry()", e);
            return null;
        }
        catch (XmlPullParserException e) {
            this.log("Invalid group entry in store entry file " + file);
            LOGGER.log(Level.SEVERE, "readEntry()", e);
            return null;
        }
        if (user == null) {
            return null;
        }
        RosterPacket.Item item = new RosterPacket.Item(user, name);
        for (String groupName : groupNames) {
            item.addGroupName(groupName);
        }
        if (type != null) {
            try {
                item.setItemType(RosterPacket.ItemType.valueOf(type));
            }
            catch (IllegalArgumentException e) {
                this.log("Invalid type in store entry file " + file);
                return null;
            }
            if (status != null) {
                RosterPacket.ItemStatus itemStatus = RosterPacket.ItemStatus.fromString(status);
                if (itemStatus == null) {
                    this.log("Invalid status in store entry file " + file);
                    return null;
                }
                item.setItemStatus(itemStatus);
            }
        }
        return item;
    }

    private boolean addEntryRaw(RosterPacket.Item item) {
        XmlStringBuilder xml = new XmlStringBuilder();
        xml.openElement("item");
        xml.element("user", item.getUser());
        xml.optElement("name", item.getName());
        xml.optElement("type", (Enum)item.getItemType());
        xml.optElement("status", (Enum)item.getItemStatus());
        for (String groupName : item.getGroupNames()) {
            xml.openElement("group");
            xml.element("groupName", groupName);
            xml.closeElement("group");
        }
        xml.closeElement("item");
        return FileUtils.writeFile((File)this.getBareJidFile(item.getUser()), (String)xml.toString());
    }

    private File getBareJidFile(String bareJid) {
        String encodedJid = Base32.encode((String)bareJid);
        return new File(this.fileDir, ENTRY_PREFIX + encodedJid);
    }

    private void log(String error) {
        System.err.println(error);
    }
}

