/*
 * Decompiled with CFR 0.152.
 */
package org.structr.mqtt;

import java.util.HashMap;
import java.util.Map;
import org.apache.cxf.common.util.StringUtils;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.service.InitializationCallback;
import org.structr.common.error.FrameworkException;
import org.structr.core.Services;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.graph.Tx;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.PropertyMap;
import org.structr.mqtt.MQTTClientConnection;
import org.structr.mqtt.MQTTInfo;
import org.structr.mqtt.entity.MQTTClient;

public abstract class MQTTContext {
    private static final Logger logger = LoggerFactory.getLogger((String)MQTTContext.class.getName());
    private static final Map<String, MQTTClientConnection> connections = new HashMap<String, MQTTClientConnection>();

    public static MQTTClientConnection getClientForId(String string) {
        return connections.get(string);
    }

    public static void disconnect(MQTTInfo mQTTInfo) throws FrameworkException {
        MQTTClientConnection mQTTClientConnection = MQTTContext.getClientForId(mQTTInfo.getUuid());
        if (mQTTClientConnection != null) {
            mQTTClientConnection.disconnect();
            connections.remove(mQTTInfo.getUuid());
        }
    }

    public static void connect(MQTTInfo mQTTInfo) throws FrameworkException {
        try {
            MQTTClientConnection mQTTClientConnection = MQTTContext.getClientForId(mQTTInfo.getUuid());
            if (mQTTClientConnection == null) {
                mQTTClientConnection = new MQTTClientConnection(mQTTInfo);
                connections.put(mQTTInfo.getUuid(), mQTTClientConnection);
                mQTTClientConnection.connect();
            } else if (!mQTTClientConnection.isConnected()) {
                mQTTClientConnection.connect();
            }
        }
        catch (MqttException mqttException) {
            throw new FrameworkException(422, "Error while connecting to MQTT broker.");
        }
    }

    public static void subscribeAllTopics(MQTTInfo mQTTInfo) throws FrameworkException {
        MQTTClientConnection mQTTClientConnection = MQTTContext.getClientForId(mQTTInfo.getUuid());
        for (String string : mQTTInfo.getTopics()) {
            if (StringUtils.isEmpty((String)string)) continue;
            mQTTClientConnection.subscribeTopic(string);
        }
    }

    static {
        Services.getInstance().registerInitializationCallback(new InitializationCallback(){

            public void initializationDone() {
                new Thread(new SubscriptionWorker()).start();
            }
        });
    }

    private static class SubscriptionWorker
    implements Runnable {
        private SubscriptionWorker() {
        }

        @Override
        public void run() {
            while (!Services.getInstance().isInitialized()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            App app = StructrApp.getInstance();
            try (Tx tx = app.tx();){
                for (MQTTClient mQTTClient : app.nodeQuery(MQTTClient.class).getAsList()) {
                    mQTTClient.setProperties(mQTTClient.getSecurityContext(), new PropertyMap(MQTTClient.isConnected, (Object)false));
                    if (!((Boolean)mQTTClient.getProperty((PropertyKey)MQTTClient.isEnabled)).booleanValue()) continue;
                    MQTTContext.connect(mQTTClient);
                    MQTTContext.subscribeAllTopics(mQTTClient);
                }
                tx.success();
            }
            catch (Throwable throwable) {
                logger.warn("Could not connect to MQTT broker.");
            }
        }
    }
}

