/*
 * Decompiled with CFR 0.152.
 */
package org.structr.mqtt.function;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.error.FrameworkException;
import org.structr.mqtt.entity.MQTTClient;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class MQTTPublishFunction
extends Function<Object, Object> {
    private static final Logger logger = LoggerFactory.getLogger((String)MQTTPublishFunction.class.getName());
    public static final String ERROR_MESSAGE_MQTTPUBLISH = "Usage: ${mqtt_publish(client, topic, message)}. Example ${mqtt_publish(client, 'myTopic', 'myMessage')}";
    public static final String ERROR_MESSAGE_MQTTPUBLISH_JS = "Usage: ${{Structr.mqtt_publish(client, topic, message)}}. Example ${{Structr.mqtt_publish(client, topic, message)}}";

    public Object apply(ActionContext actionContext, Object object, Object[] objectArray) throws FrameworkException {
        if (objectArray != null && objectArray.length == 3 && objectArray[0] != null && objectArray[1] != null && objectArray[2] != null) {
            MQTTClient mQTTClient = null;
            if (objectArray[0] instanceof MQTTClient) {
                mQTTClient = (MQTTClient)objectArray[0];
            }
            if (mQTTClient == null) {
                this.logParameterError(object, objectArray, actionContext.isJavaScriptContext());
                return "";
            }
            mQTTClient.sendMessage(objectArray[1].toString(), objectArray[2].toString());
        } else {
            this.logParameterError(object, objectArray, actionContext.isJavaScriptContext());
        }
        return "";
    }

    public String usage(boolean bl) {
        return bl ? ERROR_MESSAGE_MQTTPUBLISH_JS : ERROR_MESSAGE_MQTTPUBLISH;
    }

    public String shortDescription() {
        return "Publishes message on given mqtt client with given topic.";
    }

    public String getName() {
        return "mqtt_publish";
    }
}

