/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.admin;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import org.neo4j.commandline.admin.AdminCommandSection;
import org.neo4j.commandline.admin.CommandFailed;
import org.neo4j.commandline.admin.IncorrectUsage;
import org.neo4j.commandline.admin.OutsideWorld;
import org.neo4j.commandline.arguments.Arguments;
import org.neo4j.helpers.Service;
import org.neo4j.helpers.collection.Iterables;

public interface AdminCommand {
    public void execute(String[] var1) throws IncorrectUsage, CommandFailed;

    public static interface Blocker {
        public boolean doesBlock(Path var1, Path var2);

        @Nonnull
        public Set<String> commands();

        @Nonnull
        public String explanation();
    }

    public static abstract class Provider
    extends Service {
        protected Provider(String key, String ... altKeys) {
            super(key, altKeys);
        }

        @Nonnull
        public String name() {
            return (String)Iterables.last((Iterable)this.getKeys());
        }

        @Nonnull
        public abstract Arguments allArguments();

        @Nonnull
        public List<Arguments> possibleArguments() {
            return Arrays.asList(this.allArguments());
        }

        @Nonnull
        public abstract String summary();

        @Nonnull
        public abstract AdminCommandSection commandSection();

        @Nonnull
        public abstract String description();

        @Nonnull
        public abstract AdminCommand create(Path var1, Path var2, OutsideWorld var3);

        public final void printSummary(Consumer<String> output) {
            output.accept(String.format("%s", this.name()));
            output.accept("    " + this.summary());
        }
    }
}

