/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.admin;

import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Supplier;
import org.neo4j.commandline.admin.AdminCommand;
import org.neo4j.helpers.Service;
import org.neo4j.helpers.collection.Iterables;

public interface CommandLocator {
    public AdminCommand.Provider findProvider(String var1) throws NoSuchElementException;

    public Iterable<AdminCommand.Provider> getAllProviders();

    public static CommandLocator fromServiceLocator() {
        return new CommandLocator(){

            @Override
            public AdminCommand.Provider findProvider(String name) {
                return (AdminCommand.Provider)Service.load(AdminCommand.Provider.class, (String)name);
            }

            @Override
            public Iterable<AdminCommand.Provider> getAllProviders() {
                return Service.load(AdminCommand.Provider.class);
            }
        };
    }

    public static CommandLocator withAdditionalCommand(final Supplier<AdminCommand.Provider> command, final CommandLocator commands) {
        return new CommandLocator(){

            @Override
            public AdminCommand.Provider findProvider(String name) {
                AdminCommand.Provider provider = (AdminCommand.Provider)((Object)command.get());
                return Objects.equals(name, provider.name()) ? provider : commands.findProvider(name);
            }

            @Override
            public Iterable<AdminCommand.Provider> getAllProviders() {
                return Iterables.append(command.get(), commands.getAllProviders());
            }
        };
    }
}

