/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.neo4j.configuration.ConfigOptions;
import org.neo4j.configuration.ConfigValue;
import org.neo4j.configuration.LoadableConfig;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.config.SettingValidator;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.configuration.AnnotationBasedConfigurationMigrator;
import org.neo4j.kernel.configuration.BoltConnector;
import org.neo4j.kernel.configuration.ConfigurationMigrator;
import org.neo4j.kernel.configuration.ConfigurationValidator;
import org.neo4j.kernel.configuration.Connector;
import org.neo4j.kernel.configuration.HttpConnector;
import org.neo4j.kernel.configuration.HttpConnectorValidator;
import org.neo4j.kernel.configuration.IndividualSettingsValidator;
import org.neo4j.kernel.configuration.ServerConfigurationValidator;
import org.neo4j.kernel.info.DiagnosticsPhase;
import org.neo4j.kernel.info.DiagnosticsProvider;
import org.neo4j.logging.BufferingLog;
import org.neo4j.logging.Log;
import org.neo4j.logging.Logger;

public class Config
implements DiagnosticsProvider,
Configuration {
    private final List<ConfigOptions> configOptions;
    private final Map<String, String> params = new ConcurrentHashMap<String, String>();
    private final ConfigurationMigrator migrator;
    private final Optional<File> configFile;
    private final List<ConfigurationValidator> validators = new ArrayList<ConfigurationValidator>();
    private Log log;

    public static Config empty() {
        return Config.embeddedDefaults(Optional.empty());
    }

    public static Config defaults() {
        return Config.embeddedDefaults(Optional.empty());
    }

    public static Config embeddedDefaults(Map<String, String> additionalConfig) {
        return Config.embeddedDefaults(Optional.empty(), additionalConfig);
    }

    public static Config embeddedDefaults(Optional<File> configFile) {
        return Config.embeddedDefaults(configFile, Collections.emptyMap());
    }

    public static Config embeddedDefaults(ConfigurationValidator ... validators) {
        return Config.embeddedDefaults(Optional.empty(), Collections.emptyMap(), Arrays.asList(validators));
    }

    public static Config embeddedDefaults(Optional<File> configFile, Map<String, String> additionalConfig) {
        return Config.embeddedDefaults(configFile, additionalConfig, Collections.emptyList());
    }

    public static Config embeddedDefaults(Map<String, String> additionalConfig, Collection<ConfigurationValidator> additionalValidators) {
        return Config.embeddedDefaults(Optional.empty(), additionalConfig, additionalValidators);
    }

    public static Config embeddedDefaults(Optional<File> configFile, Map<String, String> additionalConfig, Collection<ConfigurationValidator> additionalValidators) {
        return new Config(configFile, additionalConfig, settings -> {}, additionalValidators, Optional.empty());
    }

    public static Config serverDefaults() {
        return Config.serverDefaults(Optional.empty(), Collections.emptyMap(), Collections.emptyList());
    }

    public static Config serverDefaults(Map<String, String> additionalConfig) {
        return Config.serverDefaults(Optional.empty(), additionalConfig, Collections.emptyList());
    }

    public static Config serverDefaults(Optional<File> configFile, Map<String, String> additionalConfig, Collection<ConfigurationValidator> additionalValidators) {
        ArrayList<ConfigurationValidator> validators = new ArrayList<ConfigurationValidator>();
        validators.addAll(additionalValidators);
        validators.add(new ServerConfigurationValidator());
        HttpConnector http = new HttpConnector("http", HttpConnector.Encryption.NONE);
        HttpConnector https = new HttpConnector("https", HttpConnector.Encryption.TLS);
        BoltConnector bolt = new BoltConnector("bolt");
        return new Config(configFile, additionalConfig, settings -> {
            settings.putIfAbsent(GraphDatabaseSettings.auth_enabled.name(), "true");
            settings.putIfAbsent(http.enabled.name(), "true");
            settings.putIfAbsent(https.enabled.name(), "true");
            settings.putIfAbsent(bolt.enabled.name(), "true");
        }, validators, Optional.empty());
    }

    private Config(Optional<File> configFile, Map<String, String> overriddenSettings, Consumer<Map<String, String>> settingsPostProcessor, Collection<ConfigurationValidator> additionalValidators, Optional<Log> log) {
        this(configFile, overriddenSettings, settingsPostProcessor, additionalValidators, log, LoadableConfig.allConfigClasses());
    }

    Config(Optional<File> configFile, Map<String, String> overriddenSettings, Consumer<Map<String, String>> settingsPostProcessor, Collection<ConfigurationValidator> additionalValidators, Optional<Log> log, List<LoadableConfig> settingsClasses) {
        this.log = log.orElse((Log)new BufferingLog());
        this.configFile = configFile;
        this.configOptions = settingsClasses.stream().map(LoadableConfig::getConfigOptions).flatMap(Collection::stream).collect(Collectors.toList());
        this.validators.addAll(additionalValidators);
        this.migrator = new AnnotationBasedConfigurationMigrator(settingsClasses);
        Map<String, String> settings = Config.initSettings(configFile, settingsPostProcessor, overriddenSettings, this.log);
        this.replaceSettings(settings, configFile.isPresent());
    }

    public Config with(Map<String, String> additionalConfig) {
        HashMap<String, String> newParams = new HashMap<String, String>(this.params);
        newParams.putAll(additionalConfig);
        return new Config(Optional.empty(), newParams, settings -> {}, this.validators, Optional.of(this.log));
    }

    public Config withDefaults(Map<String, String> additionalDefaults) {
        HashMap<String, String> newParams = new HashMap<String, String>(this.params);
        additionalDefaults.entrySet().forEach(s -> {
            String cfr_ignored_0 = (String)newParams.putIfAbsent((String)s.getKey(), (String)s.getValue());
        });
        return new Config(Optional.empty(), newParams, settings -> {}, this.validators, Optional.of(this.log));
    }

    public <T> T get(Setting<T> setting) {
        return (T)setting.apply(this.params::get);
    }

    public Config augment(Map<String, String> changes) {
        HashMap<String, String> params = new HashMap<String, String>(this.params);
        params.putAll(changes);
        this.replaceSettings(params, false);
        return this;
    }

    public void setLogger(Log log) {
        if (this.log instanceof BufferingLog) {
            ((BufferingLog)this.log).replayInto(log);
        }
        this.log = log;
    }

    public Set<String> getConfiguredSettingKeys() {
        return new HashSet<String>(this.params.keySet());
    }

    public Optional<String> getRaw(@Nonnull String key) {
        return Optional.ofNullable(this.params.get(key));
    }

    public Map<String, String> getRaw() {
        return new HashMap<String, String>(this.params);
    }

    public Optional<?> getValue(@Nonnull String key) {
        return this.configOptions.stream().map(it -> it.asConfigValues(this.params)).flatMap(Collection::stream).filter(it -> it.name().equals(key)).map(ConfigValue::value).findFirst().orElse(Optional.empty());
    }

    public Map<String, ConfigValue> getConfigValues() {
        return this.configOptions.stream().map(it -> it.asConfigValues(this.params)).flatMap(Collection::stream).collect(Collectors.toMap(ConfigValue::name, it -> it, (val1, val2) -> {
            throw new RuntimeException("Duplicate setting: " + val1.name() + ": " + val1 + " and " + val2);
        }));
    }

    @Override
    public String getDiagnosticsIdentifier() {
        return this.getClass().getName();
    }

    @Override
    public void acceptDiagnosticsVisitor(Object visitor) {
    }

    @Override
    public void dump(DiagnosticsPhase phase, Logger logger) {
        if (phase.isInitialization() || phase.isExplicitlyRequested()) {
            logger.log("Neo4j Kernel properties:");
            for (Map.Entry<String, String> param : this.params.entrySet()) {
                logger.log("%s=%s", new Object[]{param.getKey(), param.getValue()});
            }
        }
    }

    public Optional<Path> getConfigFile() {
        return this.configFile.map(File::toPath);
    }

    public String toString() {
        ArrayList<String> keys = new ArrayList<String>(this.params.keySet());
        Collections.sort(keys);
        LinkedHashMap<String, String> output = new LinkedHashMap<String, String>();
        for (String key : keys) {
            output.put(key, this.params.get(key));
        }
        return output.toString();
    }

    private synchronized void replaceSettings(Map<String, String> userSettings, boolean warnOnUnknownSettings) {
        Map<String, String> validSettings = this.migrator.apply(userSettings, this.log);
        List<SettingValidator> settingValidators = this.configOptions.stream().map(ConfigOptions::settingGroup).collect(Collectors.toList());
        validSettings = new IndividualSettingsValidator(warnOnUnknownSettings).validate(settingValidators, validSettings, this.log, this.configFile.isPresent());
        for (ConfigurationValidator validator : this.validators) {
            validSettings = validator.validate(settingValidators, validSettings, this.log, this.configFile.isPresent());
        }
        this.params.clear();
        this.params.putAll(validSettings);
        this.configFile.ifPresent(file -> this.warnAboutDeprecations(userSettings));
    }

    private void warnAboutDeprecations(Map<String, String> userSettings) {
        this.configOptions.stream().flatMap(it -> it.asConfigValues(userSettings).stream()).filter(config -> userSettings.containsKey(config.name()) && config.deprecated()).forEach(c -> {
            if (c.replacement().isPresent()) {
                this.log.warn("%s is deprecated. Replaced by %s", new Object[]{c.name(), c.replacement().get()});
            } else {
                this.log.warn("%s is deprecated.", new Object[]{c.name()});
            }
        });
    }

    @Nonnull
    private static Map<String, String> initSettings(@Nonnull Optional<File> configFile, @Nonnull Consumer<Map<String, String>> settingsPostProcessor, @Nonnull Map<String, String> overriddenSettings, @Nonnull Log log) {
        HashMap<String, String> settings = new HashMap<String, String>();
        configFile.ifPresent(file -> settings.putAll(Config.loadFromFile(file, log)));
        settingsPostProcessor.accept(settings);
        settings.putAll(overriddenSettings);
        return settings;
    }

    @Nonnull
    private static Map<String, String> loadFromFile(@Nonnull File file, @Nonnull Log log) {
        if (!file.exists()) {
            log.warn("Config file [%s] does not exist.", new Object[]{file});
            return new HashMap<String, String>();
        }
        try {
            return MapUtil.load((File)file);
        }
        catch (IOException e) {
            log.error("Unable to load config file [%s]: %s", new Object[]{file, e.getMessage()});
            return new HashMap<String, String>();
        }
    }

    @Nonnull
    public List<String> allConnectorIdentifiers() {
        return Config.allConnectorIdentifiers(this.params);
    }

    @Nonnull
    public static List<String> allConnectorIdentifiers(@Nonnull Map<String, String> params) {
        Pattern pattern = Pattern.compile(Pattern.quote("dbms.connector.") + "([^\\.]+)\\.(.+)");
        return params.keySet().stream().map(pattern::matcher).filter(Matcher::matches).map(match -> match.group(1)).distinct().collect(Collectors.toList());
    }

    @Nonnull
    public List<BoltConnector> boltConnectors() {
        return Config.boltConnectors(this.params);
    }

    @Nonnull
    public static List<BoltConnector> boltConnectors(@Nonnull Map<String, String> params) {
        return Config.allConnectorIdentifiers(params).stream().map(BoltConnector::new).filter(c -> {
            if (c.group.groupKey.equalsIgnoreCase("bolt")) return true;
            if (!Connector.ConnectorType.BOLT.equals(c.type.apply(params::get))) return false;
            return true;
        }).collect(Collectors.toList());
    }

    @Nonnull
    public List<BoltConnector> enabledBoltConnectors() {
        return Config.enabledBoltConnectors(this.params);
    }

    @Nonnull
    public static List<BoltConnector> enabledBoltConnectors(@Nonnull Map<String, String> params) {
        return Config.boltConnectors(params).stream().filter(c -> (Boolean)c.enabled.apply(params::get)).collect(Collectors.toList());
    }

    @Nonnull
    public List<HttpConnector> httpConnectors() {
        return Config.httpConnectors(this.params);
    }

    @Nonnull
    public static List<HttpConnector> httpConnectors(@Nonnull Map<String, String> params) {
        return Config.allConnectorIdentifiers(params).stream().map(Connector::new).filter(c -> {
            if (c.group.groupKey.equalsIgnoreCase("http")) return true;
            if (c.group.groupKey.equalsIgnoreCase("https")) return true;
            if (!Connector.ConnectorType.HTTP.equals(c.type.apply(params::get))) return false;
            return true;
        }).map(c -> {
            HttpConnector.Encryption defaultEncryption;
            String name;
            switch (name = c.group.groupKey) {
                case "https": {
                    defaultEncryption = HttpConnector.Encryption.TLS;
                    break;
                }
                default: {
                    defaultEncryption = HttpConnector.Encryption.NONE;
                }
            }
            return new HttpConnector(name, (HttpConnector.Encryption)((Object)((Object)HttpConnectorValidator.encryptionSetting(name, defaultEncryption).apply(params::get))));
        }).collect(Collectors.toList());
    }

    @Nonnull
    public List<HttpConnector> enabledHttpConnectors() {
        return Config.enabledHttpConnectors(this.params);
    }

    @Nonnull
    public static List<HttpConnector> enabledHttpConnectors(@Nonnull Map<String, String> params) {
        return Config.httpConnectors(params).stream().filter(c -> (Boolean)c.enabled.apply(params::get)).collect(Collectors.toList());
    }
}

